/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;

public final class BarDataPointTick
implements IBarDataPoint {
    public final NDateTime tradeDate;
    public final NDateTime time;
    public int tradeTicks;
    public int volume;
    public BuySell side;
    public boolean isLive = false;

    public BarDataPointTick(NDateTime td, NDateTime tm, int ticks, int vol, BuySell s, boolean live) {
        this.tradeDate = td;
        this.time = tm;
        this.tradeTicks = ticks;
        this.volume = vol;
        this.side = s;
        this.isLive = live;
    }

    @Override
    public boolean isAggregable() {
        return false;
    }

    @Override
    public NDateTime getTradeDate() {
        return this.tradeDate;
    }

    @Override
    public NDateTime getTime() {
        return this.time;
    }

    @Override
    public double getValue() {
        return this.tradeTicks;
    }

    @Override
    public NDateTime getCloseTime() {
        return this.time;
    }

    @Override
    public void setCloseTime(NDateTime value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public double getOpen() {
        return this.tradeTicks;
    }

    @Override
    public void setOpen(double value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public double getHigh() {
        return this.tradeTicks;
    }

    @Override
    public void setHigh(double value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public double getLow() {
        return this.tradeTicks;
    }

    @Override
    public void setLow(double value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public double getClose() {
        return this.tradeTicks;
    }

    @Override
    public void setClose(double value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(int value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public int getVolumeAtBid() {
        if (this.side.equals(BuySell.Buy)) {
            return this.volume;
        }
        return 0;
    }

    @Override
    public void setVolumeAtBid(int value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public int getVolumeAtOffer() {
        if (this.side.equals(BuySell.Sell)) {
            return this.volume;
        }
        return 0;
    }

    @Override
    public void setVolumeAtOffer(int value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public int getTradeCount() {
        return 1;
    }

    @Override
    public void setTradeCount(int value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public int getTradesAtBid() {
        if (this.side.equals(BuySell.Buy)) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setTradesAtBid(int value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public int getTradesAtOffer() {
        if (this.side.equals(BuySell.Sell)) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setTradesAtOffer(int value) {
        throw new UnsupportedOperationException("This data point does not support aggregation.");
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public void setIsLive(boolean value) {
        this.isLive = value;
    }
}

