/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import java.math.BigDecimal;

public final class BarDataPointF
implements IBarDataPoint {
    private final NDateTime tradeDate;
    private final NDateTime time;
    private NDateTime closeTime;
    private BigDecimal openPrice;
    private BigDecimal highPrice;
    private BigDecimal lowPrice;
    private BigDecimal closePrice;
    private int volume;
    private int volumeAtBid;
    private int volumeAtOffer;
    private int tradeCount;
    private int tradeCountAtBid;
    private int tradeCountAtOffer;
    private boolean isLive = false;

    public BarDataPointF(NDateTime td, NDateTime tm, NDateTime clsTm, Price open, Price high, Price low, Price close, int vol, int volB, int volO, int trds, int trdsB, int trdsO, boolean live) {
        this.tradeDate = td;
        this.time = tm;
        this.closeTime = clsTm;
        this.openPrice = open.getDecimalValue();
        this.highPrice = high.getDecimalValue();
        this.lowPrice = low.getDecimalValue();
        this.closePrice = close.getDecimalValue();
        this.volume = vol;
        this.volumeAtBid = volB;
        this.volumeAtOffer = volO;
        this.tradeCount = trds;
        this.tradeCountAtBid = trdsB;
        this.tradeCountAtOffer = trdsO;
        this.isLive = live;
    }

    @Override
    public boolean isAggregable() {
        return true;
    }

    @Override
    public NDateTime getTradeDate() {
        return this.tradeDate;
    }

    @Override
    public NDateTime getTime() {
        return this.time;
    }

    @Override
    public double getValue() {
        return this.closePrice.doubleValue();
    }

    @Override
    public NDateTime getCloseTime() {
        return this.closeTime;
    }

    @Override
    public void setCloseTime(NDateTime value) {
        this.closeTime = value;
    }

    @Override
    public double getOpen() {
        return this.openPrice.doubleValue();
    }

    @Override
    public void setOpen(double value) {
        this.openPrice = new BigDecimal(value);
    }

    @Override
    public double getHigh() {
        return this.highPrice.doubleValue();
    }

    @Override
    public void setHigh(double value) {
        this.highPrice = new BigDecimal(value);
    }

    @Override
    public double getLow() {
        return this.lowPrice.doubleValue();
    }

    @Override
    public void setLow(double value) {
        this.lowPrice = new BigDecimal(value);
    }

    @Override
    public double getClose() {
        return this.closePrice.doubleValue();
    }

    @Override
    public void setClose(double value) {
        this.closePrice = new BigDecimal(value);
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(int value) {
        this.volume = value;
    }

    @Override
    public int getVolumeAtBid() {
        return this.volumeAtBid;
    }

    @Override
    public void setVolumeAtBid(int value) {
        this.volumeAtBid = value;
    }

    @Override
    public int getVolumeAtOffer() {
        return this.volumeAtOffer;
    }

    @Override
    public void setVolumeAtOffer(int value) {
        this.volumeAtOffer = value;
    }

    @Override
    public int getTradeCount() {
        return this.tradeCount;
    }

    @Override
    public void setTradeCount(int value) {
        this.tradeCount = value;
    }

    @Override
    public int getTradesAtBid() {
        return this.tradeCountAtBid;
    }

    @Override
    public void setTradesAtBid(int value) {
        this.tradeCountAtBid = value;
    }

    @Override
    public int getTradesAtOffer() {
        return this.tradeCountAtOffer;
    }

    @Override
    public void setTradesAtOffer(int value) {
        this.tradeCountAtOffer = value;
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public void setIsLive(boolean value) {
        this.isLive = value;
    }
}

