/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.chart.chartdata.BarDataPointF;
import com.t4login.application.chart.chartdata.BarDataPointTick;
import com.t4login.application.chart.chartdata.BarDataPointTickF;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.priceconversion.Price;

public final class BarDataPoint
implements IBarDataPoint {
    private final NDateTime tradeDate;
    private final NDateTime time;
    private NDateTime closeTime;
    private int openTicks;
    private int highTicks;
    private int lowTicks;
    private int closeTicks;
    private int volume;
    private int volumeAtBid;
    private int volumeAtOffer;
    private int tradeCount;
    private int tradeCountAtBid;
    private int tradeCountAtOffer;
    private boolean isLive = false;

    public static IBarDataPoint CreateBar(NDateTime td, NDateTime tm, NDateTime closeTime, Price openPrice, Price highPrice, Price lowPrice, Price closePrice, int vol, int volB, int volO, int trds, int trdsB, int trdsO, boolean islive) {
        boolean isSingleTrade;
        boolean fractional = !openPrice.isIntegral() || !highPrice.isIntegral() || !lowPrice.isIntegral() || !closePrice.isIntegral();
        boolean bl = isSingleTrade = trds == 1 && openPrice.equals(highPrice) && openPrice.equals(lowPrice) && openPrice.equals(closePrice) && tm == closeTime;
        if (!isSingleTrade) {
            if (!fractional) {
                return new BarDataPoint(td, tm, closeTime, openPrice.getIntegerValue(), highPrice.getIntegerValue(), lowPrice.getIntegerValue(), closePrice.getIntegerValue(), vol, volB, volO, trds, trdsB, trdsO, islive);
            }
            return new BarDataPointF(td, tm, closeTime, openPrice, highPrice, lowPrice, closePrice, vol, volB, volO, trds, trdsB, trdsO, islive);
        }
        BuySell side = BuySell.Undefined;
        if (trdsB > 0) {
            side = BuySell.Buy;
        } else if (trdsO > 0) {
            side = BuySell.Sell;
        }
        if (!fractional) {
            return new BarDataPointTick(td, tm, openPrice.getIntegerValue(), vol, side, islive);
        }
        return new BarDataPointTickF(td, tm, openPrice, vol, side, islive);
    }

    public static IBarDataPoint CreateBar(NDateTime td, NDateTime tm, NDateTime closeTime, double open, double high, double low, double close, int vol, int volB, int volO, int trds, int trdsB, int trdsO, boolean islive) {
        boolean isSingleTrade;
        boolean fractional = open % 1.0 != 0.0 || high % 1.0 != 0.0 || low % 1.0 != 0.0 || close % 1.0 != 0.0;
        boolean bl = isSingleTrade = trds == 1 && open == high && open == low && open == close && tm == closeTime;
        if (!isSingleTrade) {
            if (!fractional) {
                return new BarDataPoint(td, tm, closeTime, (int)open, (int)high, (int)low, (int)close, vol, volB, volO, trds, trdsB, trdsO, islive);
            }
            return new BarDataPointF(td, tm, closeTime, Price.of(open), Price.of(high), Price.of(low), Price.of(close), vol, volB, volO, trds, trdsB, trdsO, islive);
        }
        BuySell side = BuySell.Undefined;
        if (trdsB > 0) {
            side = BuySell.Buy;
        } else if (trdsO > 0) {
            side = BuySell.Sell;
        }
        if (!fractional) {
            return new BarDataPointTick(td, tm, (int)open, vol, side, islive);
        }
        return new BarDataPointTickF(td, tm, Price.of(open), vol, side, islive);
    }

    public static IBarDataPoint CreateAggregableBar(IBarDataPoint bar) {
        if (bar instanceof BarDataPointTickF) {
            return new BarDataPointF(bar.getTradeDate(), bar.getTime(), bar.getCloseTime(), Price.of(bar.getOpen()), Price.of(bar.getHigh()), Price.of(bar.getLow()), Price.of(bar.getClose()), bar.getVolume(), bar.getVolumeAtBid(), bar.getVolumeAtOffer(), bar.getTradeCount(), bar.getTradesAtBid(), bar.getTradesAtOffer(), bar.isLive());
        }
        return new BarDataPoint(bar.getTradeDate(), bar.getTime(), bar.getCloseTime(), (int)bar.getOpen(), (int)bar.getHigh(), (int)bar.getLow(), (int)bar.getClose(), bar.getVolume(), bar.getVolumeAtBid(), bar.getVolumeAtOffer(), bar.getTradeCount(), bar.getTradesAtBid(), bar.getTradesAtOffer(), bar.isLive());
    }

    public BarDataPoint(NDateTime td, NDateTime tm, NDateTime clsTm, int open, int high, int low, int close, int vol, int volB, int volO, int trds, int trdsB, int trdsO, boolean live) {
        this.tradeDate = td;
        this.time = tm;
        this.closeTime = clsTm;
        this.openTicks = open;
        this.highTicks = high;
        this.lowTicks = low;
        this.closeTicks = close;
        this.volume = vol;
        this.volumeAtBid = volB;
        this.volumeAtOffer = volO;
        this.tradeCount = trds;
        this.tradeCountAtBid = trdsB;
        this.tradeCountAtOffer = trdsO;
        this.isLive = live;
    }

    @Override
    public boolean isAggregable() {
        return true;
    }

    @Override
    public NDateTime getTradeDate() {
        return this.tradeDate;
    }

    @Override
    public NDateTime getTime() {
        return this.time;
    }

    @Override
    public double getValue() {
        return this.closeTicks;
    }

    @Override
    public NDateTime getCloseTime() {
        return this.closeTime;
    }

    @Override
    public void setCloseTime(NDateTime value) {
        this.closeTime = value;
    }

    @Override
    public double getOpen() {
        return this.openTicks;
    }

    @Override
    public void setOpen(double value) {
        this.openTicks = (int)value;
    }

    @Override
    public double getHigh() {
        return this.highTicks;
    }

    @Override
    public void setHigh(double value) {
        this.highTicks = (int)value;
    }

    @Override
    public double getLow() {
        return this.lowTicks;
    }

    @Override
    public void setLow(double value) {
        this.lowTicks = (int)value;
    }

    @Override
    public double getClose() {
        return this.closeTicks;
    }

    @Override
    public void setClose(double value) {
        this.closeTicks = (int)value;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(int value) {
        this.volume = value;
    }

    @Override
    public int getVolumeAtBid() {
        return this.volumeAtBid;
    }

    @Override
    public void setVolumeAtBid(int value) {
        this.volumeAtBid = value;
    }

    @Override
    public int getVolumeAtOffer() {
        return this.volumeAtOffer;
    }

    @Override
    public void setVolumeAtOffer(int value) {
        this.volumeAtOffer = value;
    }

    @Override
    public int getTradeCount() {
        return this.tradeCount;
    }

    @Override
    public void setTradeCount(int value) {
        this.tradeCount = value;
    }

    @Override
    public int getTradesAtBid() {
        return this.tradeCountAtBid;
    }

    @Override
    public void setTradesAtBid(int value) {
        this.tradeCountAtBid = value;
    }

    @Override
    public int getTradesAtOffer() {
        return this.tradeCountAtOffer;
    }

    @Override
    public void setTradesAtOffer(int value) {
        this.tradeCountAtOffer = value;
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public void setIsLive(boolean value) {
        this.isLive = value;
    }
}

