/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart;

import com.t4login.Log;
import com.t4login.application.chart.SessionTime;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;

public class SessionTimeRange
implements Comparable<SessionTimeRange> {
    public static final String TAG = "SessionTimeRange";
    public static final SessionTimeRange Empty = new SessionTimeRange();
    private final Range<SessionTime> mRange;

    public SessionTimeRange() {
        this.mRange = Range.empty();
    }

    public SessionTimeRange(SessionTime start, SessionTime end) {
        this.mRange = Range.of(start, end);
    }

    public SessionTimeRange(String enc) {
        Range<Object> rng;
        String[] parts = enc.split("-");
        if (parts.length != 2) {
            Log.e(TAG, "SessionTimeRange(), encoding is invalid: '" + enc + "'. Expected hh:mm-hh:mm");
            rng = Range.empty();
        } else {
            String[] sparts1 = parts[0].split(":");
            String[] sparts2 = parts[1].split(":");
            if (sparts1.length != 2 || sparts2.length != 2) {
                Log.e(TAG, "SessionTimeRange(), encoding is invalid: '" + enc + "'. Expected hh:mm-hh:mm");
                rng = Range.empty();
            } else {
                try {
                    int sh = Integer.valueOf(sparts1[0]);
                    int sm = Integer.valueOf(sparts1[1]);
                    int eh = Integer.valueOf(sparts2[0]);
                    int em = Integer.valueOf(sparts2[1]);
                    if (sh < 0 || sh > 23 || sm < 0 || sm > 59 || eh < 0 || eh > 23 || em < 0 || em > 59) {
                        Log.e(TAG, "SessionTimeRange(), encoding is invalid: '" + enc + "'. Expected hh:mm-hh:mm");
                        rng = Range.empty();
                    } else {
                        rng = Range.of(new SessionTime(sh, sm), new SessionTime(eh, em));
                    }
                }
                catch (Exception ex) {
                    Log.e(TAG, "SessionTimeRange(), encoding is invalid: '" + enc + "'. Expected hh:mm-hh:mm", ex);
                    rng = Range.empty();
                }
            }
        }
        this.mRange = rng;
    }

    public boolean isEmpty() {
        return this.mRange.isEmpty() || this.mRange.start().equals(this.mRange.end());
    }

    public boolean isAllInclusive() {
        return this.isEmpty();
    }

    public boolean isOvernight() {
        return this.mRange.start().compareTo(this.mRange.end()) == 1;
    }

    public SessionTime startTime() {
        return this.isEmpty() ? SessionTime.Empty : this.mRange.start();
    }

    public SessionTime endTime() {
        return this.isEmpty() ? SessionTime.Empty : this.mRange.end();
    }

    public boolean contains(NDateTime time) {
        if (this.isAllInclusive()) {
            return true;
        }
        SessionTime stime = new SessionTime(time);
        return this.contains(stime);
    }

    public boolean contains(SessionTime stime) {
        if (this.isAllInclusive()) {
            return true;
        }
        if (this.mRange.start().compareTo(this.mRange.end()) <= 0) {
            return stime.compareTo(this.mRange.start()) >= 0 && stime.compareTo(this.mRange.end()) < 0;
        }
        return stime.compareTo(this.mRange.end()) >= 0 && stime.compareTo(this.mRange.start()) < 0;
    }

    public boolean intersects(SessionTimeRange rng) {
        if (this.isAllInclusive() || rng.isAllInclusive()) {
            return true;
        }
        return this.contains(rng.startTime()) || this.contains(rng.endTime()) || rng.contains(this.mRange.start()) || rng.contains(this.mRange.end());
    }

    public SessionTimeRange reversed() {
        return new SessionTimeRange(this.mRange.end(), this.mRange.end());
    }

    public String encoded() {
        return String.format("%02d:%02d-%02d:%02d", this.mRange.start().getHour(), this.mRange.start().getMinute(), this.mRange.end().getHour(), this.mRange.end().getMinute());
    }

    public String toString() {
        return this.mRange.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTimeRange that = (SessionTimeRange)o;
        return !(this.mRange == null ? that.mRange != null : !this.mRange.equals(that.mRange));
    }

    public int hashCode() {
        return this.mRange != null ? this.mRange.hashCode() : 0;
    }

    @Override
    public int compareTo(SessionTimeRange other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.isOvernight() && !other.isOvernight()) {
            return -1;
        }
        if (!this.isOvernight() && other.isOvernight()) {
            return 1;
        }
        if (this.isOvernight() && other.isOvernight()) {
            return this.mRange.start().compareTo(other.mRange.start());
        }
        return this.mRange.start().compareTo(other.mRange.start());
    }
}

