/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart;

import com.t4login.Log;
import com.t4login.datetime.NDateTime;
import com.t4login.util.SortUtil;

public class SessionTime
implements Comparable<SessionTime> {
    private static String TAG = "SessionTime";
    public static SessionTime Empty = new SessionTime(0, 0);
    private final byte mHour;
    private final byte mMinute;

    public SessionTime(int hour, int minute) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be between 0 and 23.");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be between 0 and 59.");
        }
        this.mHour = (byte)hour;
        this.mMinute = (byte)minute;
    }

    public SessionTime(NDateTime time) {
        this.mHour = (byte)time.getHour();
        this.mMinute = (byte)time.getMinute();
    }

    public SessionTime addMinutes(int minutes) {
        if (this != Empty) {
            NDateTime d = new NDateTime(2000, 1, 1, this.mHour, this.mMinute, 0);
            d = d.AddMinutes(minutes);
            return new SessionTime(d);
        }
        return Empty;
    }

    public SessionTime AddHours(int hours) {
        if (this != Empty) {
            NDateTime d = new NDateTime(2000, 1, 1, this.mHour, this.mMinute, 0);
            d = d.AddHours(hours);
            return new SessionTime(d);
        }
        return Empty;
    }

    public NDateTime toDateTime(NDateTime date) {
        return new NDateTime(date.getYear(), date.getMonth(), date.getDay(), this.mHour, this.mMinute, 0);
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public String toString() {
        return String.format("%02d:%02d", this.mHour, this.mMinute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTime that = (SessionTime)o;
        if (this.mHour != that.mHour) {
            return false;
        }
        return this.mMinute == that.mMinute;
    }

    public int hashCode() {
        int result = this.mHour;
        result = 31 * result + this.mMinute;
        return result;
    }

    @Override
    public int compareTo(SessionTime other) {
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        long lhs = this.mHour << 8 | this.mMinute;
        long rhs = this.mHour << 8 | other.mMinute;
        return SortUtil.compare(lhs, rhs);
    }

    public static SessionTime valueOf(String value) {
        String[] pieces = value.split(":");
        if (pieces.length == 2) {
            int hour = Integer.parseInt(pieces[0]);
            int minute = Integer.parseInt(pieces[1]);
            return new SessionTime(hour, minute);
        }
        Log.e(TAG, "valueOf(), Invalid session time format '%s'. Expected hh:mm", value);
        return Empty;
    }
}

