/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum ChartInterval {
    Tick(0, "chartinterval_tick", "chartinterval_tick_abbr"),
    TickRange(1, "chartinterval_tickrange", "chartinterval_tickrange_abbr"),
    Volume(2, "chartinterval_volume", "chartinterval_volume_abbr"),
    Second(3, "chartinterval_second", "chartinterval_second_abbr"),
    Minute(4, "chartinterval_minute", "chartinterval_minute_abbr"),
    Hour(5, "chartinterval_hour", "chartinterval_hour_abbr"),
    Day(6, "chartinterval_day", "chartinterval_day_abbr"),
    Week(7, "chartinterval_week", "chartinterval_week_abbr"),
    Month(8, "chartinterval_month", "chartinterval_month_abbr"),
    Year(9, "chartinterval_year", "chartinterval_year_abbr");

    private final int value;
    private final String descr_loc;
    private final String abbrDescr_loc;
    private static Map<Integer, ChartInterval> map;

    private ChartInterval(int value, String descr_loc, String abbrDescr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
        this.abbrDescr_loc = abbrDescr_loc;
    }

    public String getDescr() {
        return Resource.localizeString(this.descr_loc);
    }

    public String getAbbrDescr() {
        return Resource.localizeString(this.abbrDescr_loc);
    }

    public int getValue() {
        return this.value;
    }

    public static ChartInterval get(int value) {
        return map.get(value);
    }

    public String toString() {
        return this.getDescr();
    }

    static {
        map = new HashMap<Integer, ChartInterval>();
        for (ChartInterval t : ChartInterval.values()) {
            map.put(t.getValue(), t);
        }
    }
}

