/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart;

import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.IMarketFormatter;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.dataprovider.IBarDataProvider;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.application.chart.settings.ChartProfile;
import com.t4login.application.contract.ladder.DepthSnapshot;
import com.t4login.definitions.ChartType;

public class ChartContext {
    private final DepthProvider mDepthProvider;
    public final ChartProfile Profile;
    public final IChartMarket PrimaryMarket;
    public final IBarDataProvider BarProvider;
    public final IMarketFormatter MarketFormatter;

    public ChartContext(DepthProvider dp, ChartProfile profile, IChartMarket primaryMarket, IBarDataProvider provider, IMarketFormatter marketFormatter) {
        this.mDepthProvider = dp;
        this.Profile = profile;
        this.PrimaryMarket = primaryMarket;
        this.BarProvider = provider;
        this.MarketFormatter = marketFormatter;
    }

    public DepthSnapshot getDepth() {
        return this.mDepthProvider.getDepth();
    }

    public ChartContext getCustomized(ChartType chartType, BarInterval intvl) {
        DataLoadArgs customArgs = new DataLoadArgs.Builder(this.BarProvider.args()).setChartType(chartType).setBarInterval(intvl).createDataLoadArgs();
        ChartContext cc = new ChartContext(this.mDepthProvider, this.Profile, this.PrimaryMarket, this.BarProvider.getCustomized(customArgs), this.MarketFormatter);
        return cc;
    }

    public static interface DepthProvider {
        public DepthSnapshot getDepth();
    }
}

