/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart;

import com.t4login.application.chart.ChartInterval;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.util.SortUtil;

public final class BarInterval
implements Comparable<BarInterval> {
    public static final BarInterval Default = new BarInterval(15, ChartInterval.Minute);
    public static final BarInterval Bar1Day = new BarInterval(1, ChartInterval.Day);
    public static final BarInterval Bar1Hour = new BarInterval(1, ChartInterval.Hour);
    public static final BarInterval Bar30Minute = new BarInterval(30, ChartInterval.Minute);
    public static final BarInterval Bar15Minute = new BarInterval(15, ChartInterval.Minute);
    public static final BarInterval Bar5Minute = new BarInterval(5, ChartInterval.Minute);
    public static final BarInterval Bar1Minute = new BarInterval(1, ChartInterval.Minute);
    public static final BarInterval Bar30Second = new BarInterval(30, ChartInterval.Second);
    public static final BarInterval Bar15Second = new BarInterval(15, ChartInterval.Second);
    public static final BarInterval Bar5Second = new BarInterval(5, ChartInterval.Second);
    public static final BarInterval Bar1Second = new BarInterval(1, ChartInterval.Second);
    public static final NDateTime BaseTime = new NDateTime(2000, 1, 1, 0, 0, 0, 0);
    public final ChartInterval Interval;
    public final int Period;
    public NDateTime AnchorTime = new NDateTime(2000, 1, 1, 0, 0, 0, 0);

    public static String toSerializationString(BarInterval intvl) {
        return String.format("%s;%s", new Object[]{intvl.Period, intvl.Interval});
    }

    public static BarInterval fromSerializationString(String sval) {
        String[] parts = sval.split(";");
        int period = Integer.valueOf(parts[0]);
        ChartInterval intvl = ChartInterval.Day;
        try {
            intvl = Enum.valueOf(ChartInterval.class, parts[1]);
        }
        catch (IllegalArgumentException ex) {
            for (ChartInterval c : ChartInterval.values()) {
                if (!parts[1].equals(c.name())) continue;
                intvl = c;
                break;
            }
        }
        return new BarInterval(period, intvl);
    }

    public BarInterval(int period, ChartInterval interval) {
        this.Period = period;
        this.Interval = interval;
    }

    public String getAbbreviatedDescription() {
        return this.toString(true);
    }

    private boolean isIntraDayAnchored() {
        return this.Interval.getValue() < ChartInterval.Day.getValue() && this.AnchorTime != BaseTime;
    }

    public boolean isTimeBased() {
        return this.Interval == ChartInterval.Second || this.Interval == ChartInterval.Minute || this.Interval == ChartInterval.Hour || this.Interval == ChartInterval.Day || this.Interval == ChartInterval.Week || this.Interval == ChartInterval.Month || this.Interval == ChartInterval.Year;
    }

    public boolean isIntraDay() {
        return this.Interval != ChartInterval.Day && this.Interval != ChartInterval.Week && this.Interval != ChartInterval.Month && this.Interval != ChartInterval.Year;
    }

    public int intervalsBetween(NDateTime time1, NDateTime time2, NTimeSpan avgInterval) {
        NDateTime itime1 = this.roundDownToInterval(time1, avgInterval);
        NDateTime itime2 = this.roundDownToInterval(time2, avgInterval);
        if (this.Interval == ChartInterval.Month) {
            int yr1 = itime1.getYear();
            int yr2 = itime2.getYear();
            int mo1 = itime1.getMonth();
            int mo2 = itime2.getMonth();
            return (12 * (yr2 - yr1) + mo2 - mo1) / this.Period;
        }
        if (this.Interval == ChartInterval.Year) {
            return (itime2.getYear() - itime1.getYear()) / this.Period;
        }
        itime1 = this.roundDownToInterval(time1, avgInterval);
        itime2 = this.roundDownToInterval(time2, avgInterval);
        NTimeSpan ts = itime2.Subtract(itime1);
        NTimeSpan intvlspan = this.getTimeSpan(avgInterval);
        return (int)(ts.getTicks() / intvlspan.getTicks());
    }

    public float intervalsBetweenF(NDateTime time1, NDateTime time2, NTimeSpan avgInterval) {
        if (this.Interval == ChartInterval.Year) {
            NTimeSpan ts = time2.Subtract(time1);
            return (float)(ts.getTotalDays() / (365.2425 * (double)this.Period));
        }
        if (this.Interval == ChartInterval.Month) {
            NTimeSpan ts = time2.Subtract(time1);
            float mof = (float)(ts.getTotalDays() / (30.436875 * (double)this.Period));
            return mof;
        }
        NTimeSpan ts = time2.Subtract(time1);
        NTimeSpan intvlspan = this.getTimeSpan(avgInterval);
        return (float)((double)ts.getTicks() / (double)intvlspan.getTicks());
    }

    public NDateTime roundToNearestInterval(NDateTime time, NTimeSpan avgInterval) {
        if (!this.isTimeBased()) {
            return time;
        }
        return this.roundDownToInterval(time, avgInterval);
    }

    public NDateTime roundUpToInterval(NDateTime time, NTimeSpan avgInterval) {
        if (!this.isTimeBased()) {
            return time;
        }
        NDateTime intvltime = this.roundDownToInterval(time, avgInterval);
        if (this.Interval == ChartInterval.Year) {
            if (time.compareTo(intvltime) > 0) {
                return intvltime.AddYears(this.Period);
            }
            return intvltime;
        }
        if (this.Interval == ChartInterval.Month) {
            if (time.compareTo(intvltime) > 0) {
                return intvltime.AddMonths(this.Period);
            }
            return intvltime;
        }
        if (this.Interval == ChartInterval.Week) {
            if (time.compareTo(intvltime) > 0) {
                return intvltime.AddDays(7 * this.Period);
            }
            return intvltime;
        }
        NTimeSpan intvlspan = this.getTimeSpan(avgInterval);
        NDateTime roundedtime = new NDateTime(BaseTime.getTicks() + (long)(Math.ceil(((double)time.getTicks() - (double)BaseTime.getTicks()) / (double)intvlspan.getTicks()) * (double)intvlspan.getTicks()));
        return roundedtime;
    }

    public NDateTime roundDownToInterval(NDateTime time, NTimeSpan avgInterval) {
        if (!this.isTimeBased()) {
            return new NDateTime(time);
        }
        if (this.Interval == ChartInterval.Year) {
            return new NDateTime(time.getYear() - (time.getYear() - BaseTime.getYear()) % this.Period, 1, 1, 0, 0, 0);
        }
        if (this.Interval == ChartInterval.Month) {
            int monthdiff = 12 * (time.getYear() - BaseTime.getYear()) + time.getMonth() - BaseTime.getMonth();
            return new NDateTime(time.getYear(), time.getMonth(), 1, 0, 0, 0).AddMonths(-(monthdiff % this.Period));
        }
        if (this.Interval == ChartInterval.Week) {
            NDateTime baseweek = this.roundToWeek(BaseTime);
            time = this.roundToWeek(time);
            NTimeSpan weekspan = new NTimeSpan(7, 0, 0, 0, 0);
            NDateTime week = time.AddTicks(-((time.getTicks() - baseweek.getTicks()) % (weekspan.getTicks() * (long)this.Period)));
            return week;
        }
        NTimeSpan intvlspan = this.getTimeSpan(avgInterval);
        NDateTime roundedtime = new NDateTime(BaseTime.getTicks() + (long)(Math.floor(((double)time.getTicks() - (double)BaseTime.getTicks()) / (double)intvlspan.getTicks()) * (double)intvlspan.getTicks()));
        return roundedtime;
    }

    public NDateTime roundToWeek(NDateTime time) {
        int dayoffset = 0;
        switch (time.getDayOfWeek().getValue()) {
            case 6: {
                dayoffset += 2;
                break;
            }
            case 0: {
                ++dayoffset;
                break;
            }
            case 2: {
                --dayoffset;
                break;
            }
            case 3: {
                dayoffset -= 2;
                break;
            }
            case 4: {
                dayoffset -= 3;
                break;
            }
            case 5: {
                dayoffset -= 4;
            }
        }
        NDateTime week = new NDateTime(time.getYear(), time.getMonth(), time.getDay(), 0, 0, 0);
        week = week.AddDays(dayoffset);
        return week;
    }

    public NDateTime getNextIntervalTime(NDateTime time, NTimeSpan avgInterval) {
        NDateTime intvltime = this.roundDownToInterval(time, avgInterval);
        if (this.Interval == ChartInterval.Year) {
            intvltime.incrementYears(this.Period);
        } else if (this.Interval == ChartInterval.Month) {
            intvltime.incrementMonths(this.Period);
        } else if (this.Interval == ChartInterval.Week) {
            intvltime.incrementDays(7 * this.Period);
        } else if (this.Interval == ChartInterval.Day) {
            intvltime.incrementDays(this.Period);
        } else {
            NTimeSpan intvlspan = this.getTimeSpan(avgInterval);
            intvltime.increment(intvlspan);
        }
        return intvltime;
    }

    public NDateTime addIntervals(NDateTime time, int n, NTimeSpan avgInterval) {
        if (this.Interval == ChartInterval.Year) {
            return time.AddYears(n * this.Period);
        }
        if (this.Interval == ChartInterval.Month) {
            return time.AddMonths(n * this.Period);
        }
        if (this.Interval == ChartInterval.Week) {
            return time.AddDays(7 * n * this.Period);
        }
        if (this.Interval == ChartInterval.Day) {
            return time.AddDays(n * this.Period);
        }
        return time.AddTicks(this.getTimeSpan(avgInterval).getTicks() * (long)n);
    }

    public NDateTime addIntervals(NDateTime time, float n, NTimeSpan avgInterval) {
        if (this.Interval == ChartInterval.Year) {
            int y = (int)Math.floor(n *= (float)this.Period);
            double f = n % 1.0f;
            return time.AddYears(y).AddDays((int)(365.2425 * f));
        }
        if (this.Interval == ChartInterval.Month) {
            return time.AddDays((int)(30.436875 * (double)(n *= (float)this.Period)));
        }
        if (this.Interval == ChartInterval.Week) {
            NTimeSpan wkts = new NTimeSpan(7, 0, 0, 0);
            int d = (int)Math.floor(n *= (float)this.Period);
            double f = n % 1.0f;
            return time.AddDays(7 * d).AddTicks((long)(f * (double)wkts.getTicks()));
        }
        if (this.Interval == ChartInterval.Day) {
            NTimeSpan dayts = new NTimeSpan(1, 0, 0, 0);
            int d = (int)Math.floor(Math.abs(n *= (float)this.Period)) * (n < 0.0f ? -1 : 1);
            double f = n % 1.0f;
            return time.AddDays(d).AddTicks((long)(f * (double)dayts.getTicks()));
        }
        return time.AddTicks((long)((double)this.getTimeSpan(avgInterval).getTicks() * (double)n));
    }

    private NTimeSpan getTimeSpan(NTimeSpan avgInterval) {
        if (!this.isTimeBased()) {
            return avgInterval;
        }
        if (this.Interval == ChartInterval.Second) {
            return new NTimeSpan(0, 0, this.Period);
        }
        if (this.Interval == ChartInterval.Minute) {
            return new NTimeSpan(0, this.Period, 0);
        }
        if (this.Interval == ChartInterval.Hour) {
            return new NTimeSpan(this.Period, 0, 0);
        }
        if (this.Interval == ChartInterval.Day) {
            return new NTimeSpan(this.Period, 0, 0, 0, 0);
        }
        if (this.Interval == ChartInterval.Week) {
            return new NTimeSpan(7 * this.Period, 0, 0, 0, 0);
        }
        return NTimeSpan.Zero;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean abbreviate) {
        String intvltext = abbreviate ? this.Interval.getAbbrDescr() : this.Interval.getDescr();
        return String.format("%d %s", this.Period, intvltext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarInterval that = (BarInterval)o;
        if (this.Period != that.Period) {
            return false;
        }
        if (this.Interval != that.Interval) {
            return false;
        }
        return this.AnchorTime.equals(that.AnchorTime);
    }

    public int hashCode() {
        int result = this.Interval.hashCode();
        result = 31 * result + this.Period;
        result = 31 * result + this.AnchorTime.hashCode();
        return result;
    }

    @Override
    public int compareTo(BarInterval other) {
        if (other != null) {
            if (this.Interval == other.Interval) {
                return SortUtil.compare(this.Period, other.Period);
            }
            return this.Interval.compareTo(other.Interval);
        }
        return 1;
    }
}

