/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.alertmanager;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum AlertFilter {
    All(0, "alertfilter_menu_all", "alertfilter_title_all"),
    Active(1, "alertfilter_menu_active", "alertfilter_title_active"),
    Inactive(2, "alertfilter_menu_inactive", "alertfilter_title_inactive");

    private final int value;
    private final String menuLabel_loc;
    private final String activityTitle_loc;
    private static Map<Integer, AlertFilter> map;

    private AlertFilter(int value, String lablel_loc, String title_loc) {
        this.value = value;
        this.menuLabel_loc = lablel_loc;
        this.activityTitle_loc = title_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getMenuLabel() {
        return Resource.localizeString(this.menuLabel_loc);
    }

    public String getActivityTitle() {
        return Resource.localizeString(this.activityTitle_loc);
    }

    public static AlertFilter get(int value) {
        AlertFilter v = map.get(value);
        if (v == null) {
            v = All;
        }
        return v;
    }

    public String toString() {
        return this.name();
    }

    static {
        map = new HashMap<Integer, AlertFilter>();
        for (AlertFilter t : AlertFilter.values()) {
            map.put(t.getValue(), t);
        }
    }
}

