/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.accountboard;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum PositionFilter {
    All(0, "navview_allpositions_top", "navview_allpositions"),
    Active(1, "navview_activepositions_top", "navview_activepositions"),
    Open(2, "navview_openpositions_top", "navview_openpositions"),
    Flat(3, "navview_flatpositions_top", "navview_flatpositions"),
    Closed(3, "navview_flatpositions_top", "navview_flatpositions");

    private final int value;
    private final String mTitle_loc;
    private final String mNavLabel_loc;
    private static Map<Integer, PositionFilter> map;

    private PositionFilter(int value, String title_loc, String navlbl_loc) {
        this.value = value;
        this.mTitle_loc = title_loc;
        this.mNavLabel_loc = navlbl_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getTitle() {
        return Resource.localizeString(this.mTitle_loc);
    }

    public String getNavLabel() {
        return Resource.localizeString(this.mNavLabel_loc);
    }

    public static PositionFilter get(int value) {
        PositionFilter v = map.get(value);
        if (v == null) {
            v = All;
        }
        return v;
    }

    public Boolean isOpenPosition() {
        return this == Active || this == Open;
    }

    public String toString() {
        return this.name();
    }

    static {
        map = new HashMap<Integer, PositionFilter>();
        for (PositionFilter t : PositionFilter.values()) {
            map.put(t.getValue(), t);
        }
    }
}

