/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.accountboard;

import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.accounts.PositionProfit;
import com.t4login.application.settings.UPLCalcType;
import java.math.BigDecimal;

public class AccountBoardItem {
    private Market mMarket;
    private PositionProfit mPP;

    public AccountBoardItem(Market market, PositionProfit pp) {
        this.mMarket = market;
        this.mPP = pp;
    }

    public void updateItem(Market market, PositionProfit pp) {
        this.mMarket = market;
        this.mPP = pp;
    }

    public String getAccountID() {
        return this.mPP.AccountID;
    }

    public Market getMarket() {
        return this.mMarket;
    }

    public String getMarketDescription(MarketData marketData) {
        if (marketData != null) {
            return marketData.getFormattedMarketDescription(this.mMarket);
        }
        return this.mMarket.getDescription();
    }

    public int getPositionNet() {
        return this.mPP.getNet();
    }

    public String getPositionNetDisplay() {
        return this.mPP.getNetDisplay();
    }

    public BigDecimal getPositionPL(UPLCalcType uplCalcType) {
        return uplCalcType == UPLCalcType.Trade ? this.mPP.getPLTrade() : this.mPP.getPL();
    }

    public int getBuys() {
        return this.mPP.getBuys();
    }

    public int getSells() {
        return this.mPP.getSells();
    }

    public int getWorkingBuys() {
        return this.mPP.getWorkingBuys();
    }

    public int getWorkingSells() {
        return this.mPP.getWorkingSells();
    }
}

