/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application;

import com.t4login.application.ContextSettings;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.TextUtils;
import java.util.ArrayList;

public class ContextWriter {
    private static final String TAG = "ContextWriter";
    private final String mBaseContext;
    private final ContextSettings mContext;

    public ContextWriter(ContextSettings.ContextType type) {
        this.mBaseContext = "";
        switch (type) {
            case Persistent: {
                this.mContext = ContextSettings.persistent;
                break;
            }
            default: {
                this.mContext = ContextSettings.nonpersistent;
            }
        }
    }

    public ContextWriter(ContextSettings.ContextType type, String baseContext) {
        this.mBaseContext = baseContext;
        switch (type) {
            case Persistent: {
                this.mContext = ContextSettings.persistent;
                break;
            }
            default: {
                this.mContext = ContextSettings.nonpersistent;
            }
        }
    }

    public void saveContextSetting(String[] subContexts, String name, int value) {
        String key = this.getKey(subContexts, name);
        this.mContext.saveInt(key, value);
    }

    public void saveContextSetting(String subContext, String name, int value) {
        String key = this.getKey(subContext, name);
        this.mContext.saveInt(key, value);
    }

    public void saveContextSetting(String[] subContexts, String name, float value) {
        String key = this.getKey(subContexts, name);
        this.mContext.saveFloat(key, value);
    }

    public void saveContextSetting(String subContext, String name, float value) {
        String key = this.getKey(subContext, name);
        this.mContext.saveFloat(key, value);
    }

    public void saveContextSetting(String[] subContexts, String name, boolean value) {
        String key = this.getKey(subContexts, name);
        this.mContext.saveBoolean(key, value);
    }

    public void saveContextSetting(String subContext, String name, boolean value) {
        String key = this.getKey(subContext, name);
        this.mContext.saveBoolean(key, value);
    }

    public void saveContextSetting(String[] subContexts, String name, String value) {
        String key = this.getKey(subContexts, name);
        this.mContext.saveString(key, value);
    }

    public void saveContextSetting(String subContext, String name, String value) {
        String key = this.getKey(subContext, name);
        this.mContext.saveString(key, value);
    }

    public void saveContextSetting(String[] subContexts, String name, Price value) {
        String key = this.getKey(subContexts, name);
        this.mContext.savePrice(key, value);
    }

    public void saveContextSetting(String subContext, String name, Price value) {
        String key = this.getKey(subContext, name);
        this.mContext.savePrice(key, value);
    }

    public int getIntContextSetting(String[] subContexts, String name, int defaultValue) {
        String key = this.getKey(subContexts, name);
        return this.mContext.getInt(key, defaultValue);
    }

    public int getIntContextSetting(String subContext, String name, int defaultValue) {
        String key = this.getKey(subContext, name);
        return this.mContext.getInt(key, defaultValue);
    }

    public float getFloatContextSetting(String[] subContexts, String name, float defaultValue) {
        String key = this.getKey(subContexts, name);
        return this.mContext.getFloat(key, defaultValue);
    }

    public float getFloatContextSetting(String subContext, String name, float defaultValue) {
        String key = this.getKey(subContext, name);
        return this.mContext.getFloat(key, defaultValue);
    }

    public boolean getBooleanContextSetting(String[] subContexts, String name, boolean defaultValue) {
        String key = this.getKey(subContexts, name);
        return this.mContext.getBoolean(key, defaultValue);
    }

    public boolean getBooleanContextSetting(String subContext, String name, boolean defaultValue) {
        String key = this.getKey(subContext, name);
        return this.mContext.getBoolean(key, defaultValue);
    }

    public String getStringContextSetting(String[] subContexts, String name, String defaultValue) {
        String key = this.getKey(subContexts, name);
        return this.mContext.getString(key, defaultValue);
    }

    public String getStringContextSetting(String subContext, String name, String defaultValue) {
        String key = this.getKey(subContext, name);
        return this.mContext.getString(key, defaultValue);
    }

    public Price getPriceContextSetting(String[] subContexts, String name, Price defaultValue) {
        String key = this.getKey(subContexts, name);
        return this.mContext.getPrice(key, defaultValue);
    }

    public Price getPriceContextSetting(String subContext, String name, Price defaultValue) {
        String key = this.getKey(subContext, name);
        return this.mContext.getPrice(key, defaultValue);
    }

    private String getKey(String[] subContexts, String name) {
        ArrayList<String> contexts = new ArrayList<String>();
        if (!this.mBaseContext.isEmpty()) {
            contexts.add(this.mBaseContext);
        }
        for (String subContext : subContexts) {
            if (subContext == null || subContext.isEmpty()) continue;
            contexts.add(subContext);
        }
        contexts.add(name);
        return TextUtils.join((CharSequence)"::", contexts);
    }

    private String getKey(String subContext, String name) {
        ArrayList<String> contexts = new ArrayList<String>();
        if (!this.mBaseContext.isEmpty()) {
            contexts.add(this.mBaseContext);
        }
        if (subContext != null && !subContext.isEmpty()) {
            contexts.add(subContext);
        }
        contexts.add(name);
        return TextUtils.join((CharSequence)"::", contexts);
    }
}

