/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application;

import com.t4login.Log;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Pair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ContextSettings {
    private static final String TAG = "ContextSettings";
    public static final ContextSettings persistent = new ContextSettings(ContextType.Persistent);
    public static final ContextSettings nonpersistent = new ContextSettings(ContextType.NonPersistent);
    private static final List<ContextSettingsChangedHandler> mContextSettingsChangedHandlers = new CopyOnWriteArrayList<ContextSettingsChangedHandler>();
    private final ContextType mContextType;
    private final Map<String, String> mContextSettings = new HashMap<String, String>();
    private int mBeginBatchCounter = 0;
    private List<Pair<String, String>> batchedUpdates = new ArrayList<Pair<String, String>>();
    private List<String> batchedRemoves = new ArrayList<String>();

    public static void registerForContextSettingsChanges(ContextSettingsChangedHandler handler) {
        if (!mContextSettingsChangedHandlers.contains(handler)) {
            mContextSettingsChangedHandlers.add(handler);
        }
    }

    public static void unregisterForContextSettingsChanges(ContextSettingsChangedHandler handler) {
        if (mContextSettingsChangedHandlers.contains(handler)) {
            mContextSettingsChangedHandlers.remove(handler);
        }
    }

    private ContextSettings(ContextType contextType) {
        this.mContextType = contextType;
    }

    private void onSettingUpdated(String name, String value) {
        if (this.mBeginBatchCounter == 0) {
            ArrayList<Pair<String, String>> updated = new ArrayList<Pair<String, String>>();
            ArrayList<String> removed = new ArrayList<String>();
            updated.add(new Pair<String, String>(name, value));
            for (ContextSettingsChangedHandler h : mContextSettingsChangedHandlers) {
                if (!this.mContextType.equals((Object)h.getContextType())) continue;
                try {
                    h.onContextSettingsChanged(updated, removed);
                }
                catch (Exception ex) {
                    Log.e(TAG, "onSettingsChanged(), Error.", ex);
                }
            }
        } else {
            this.batchedUpdates.removeIf(p -> ((String)p.first).equals(name));
            this.batchedRemoves.removeIf(k -> k.equals(name));
            this.batchedUpdates.add(new Pair<String, String>(name, value));
        }
    }

    private void onSettingRemoved(String name) {
        if (this.mBeginBatchCounter == 0) {
            ArrayList<Pair<String, String>> updated = new ArrayList<Pair<String, String>>();
            ArrayList<String> removed = new ArrayList<String>();
            removed.add(name);
            for (ContextSettingsChangedHandler h : mContextSettingsChangedHandlers) {
                if (!this.mContextType.equals((Object)h.getContextType())) continue;
                try {
                    h.onContextSettingsChanged(updated, removed);
                }
                catch (Exception ex) {
                    Log.e(TAG, "onSettingRemoved(), Error.", ex);
                }
            }
        } else {
            this.batchedUpdates.removeIf(p -> ((String)p.first).equals(name));
            this.batchedRemoves.removeIf(k -> k.equals(name));
            this.batchedRemoves.add(name);
        }
    }

    private void onBatchComplete() {
        ArrayList<Pair<String, String>> updated = new ArrayList<Pair<String, String>>(this.batchedUpdates);
        ArrayList<String> removed = new ArrayList<String>(this.batchedRemoves);
        this.batchedUpdates.clear();
        this.batchedRemoves.clear();
        for (ContextSettingsChangedHandler h : mContextSettingsChangedHandlers) {
            if (!this.mContextType.equals((Object)h.getContextType())) continue;
            try {
                h.onContextSettingsChanged(updated, removed);
            }
            catch (Exception ex) {
                Log.e(TAG, "onBatchComplete(), Error.", ex);
            }
        }
    }

    public void beginBatchUpdate() {
        ++this.mBeginBatchCounter;
    }

    public void endBatchUpdate(boolean notify) {
        --this.mBeginBatchCounter;
        if (this.mBeginBatchCounter < 0) {
            this.mBeginBatchCounter = 0;
        }
        if (notify && this.mBeginBatchCounter == 0) {
            this.onBatchComplete();
        }
    }

    public void clear() {
        this.mContextSettings.clear();
    }

    public void remove(String name) {
        this.mContextSettings.remove(name);
        this.onSettingRemoved(name);
    }

    public void saveString(String name, String value) {
        this.mContextSettings.put(name, value);
        this.onSettingUpdated(name, value);
    }

    public String getString(String name) {
        return this.mContextSettings.get(name);
    }

    public String getString(String name, String defaultValue) {
        String value = this.mContextSettings.get(name);
        return value != null ? value : defaultValue;
    }

    public void saveInt(String name, int value) {
        String encodedValue = String.valueOf(value);
        this.mContextSettings.put(name, encodedValue);
        this.onSettingUpdated(name, encodedValue);
    }

    public Integer getInt(String name) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Integer.parseInt(encodedValue);
            }
            catch (NumberFormatException nex) {
                return null;
            }
        }
        return null;
    }

    public int getInt(String name, int defaultValue) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Integer.parseInt(encodedValue);
            }
            catch (NumberFormatException nex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void saveLong(String name, long value) {
        String encodedValue = String.valueOf(value);
        this.mContextSettings.put(name, encodedValue);
        this.onSettingUpdated(name, encodedValue);
    }

    public Long getLong(String name) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Long.parseLong(encodedValue);
            }
            catch (NumberFormatException nex) {
                return null;
            }
        }
        return null;
    }

    public long getLong(String name, long defaultValue) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Long.parseLong(encodedValue);
            }
            catch (NumberFormatException nex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void saveFloat(String name, float value) {
        String encodedValue = String.valueOf(value);
        this.mContextSettings.put(name, encodedValue);
        this.onSettingUpdated(name, encodedValue);
    }

    public Float getFloat(String name) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Float.valueOf(Float.parseFloat(encodedValue));
            }
            catch (NumberFormatException nex) {
                return null;
            }
        }
        return null;
    }

    public float getFloat(String name, float defaultValue) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Float.parseFloat(encodedValue);
            }
            catch (NumberFormatException nex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void savePrice(String name, Price value) {
        String encodedValue = value.getDecimalValue().toString();
        this.mContextSettings.put(name, encodedValue);
        this.onSettingUpdated(name, encodedValue);
    }

    public Price getPrice(String name) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return new Price(new BigDecimal(encodedValue));
            }
            catch (NumberFormatException nex) {
                return null;
            }
        }
        return null;
    }

    public Price getPrice(String name, Price defaultValue) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return new Price(new BigDecimal(encodedValue));
            }
            catch (NumberFormatException nex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void saveBoolean(String name, boolean value) {
        String encodedValue = Boolean.toString(value);
        this.mContextSettings.put(name, encodedValue);
        this.onSettingUpdated(name, encodedValue);
    }

    public Boolean getBoolean(String name) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Boolean.parseBoolean(encodedValue);
            }
            catch (NumberFormatException nex) {
                return null;
            }
        }
        return null;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String encodedValue = this.mContextSettings.get(name);
        if (encodedValue != null) {
            try {
                return Boolean.parseBoolean(encodedValue);
            }
            catch (NumberFormatException nex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public Map<String, ?> getAllContextSettings() {
        return this.mContextSettings;
    }

    public void setTo(Map<String, String> values) {
        this.mContextSettings.clear();
        this.mContextSettings.putAll(values);
        Log.d(TAG, "setTo(), [%s], Retrieved user context settings from remote API. n: %d", this.mContextType.name(), this.mContextSettings.size());
        this.mContextSettings.entrySet().stream().forEach(x -> Log.d(TAG, "setTo(), [%s],     KEY: %s, VALUE: %s", this.mContextType.name(), x.getKey(), x.getValue()));
    }

    public static enum ContextType {
        Persistent,
        NonPersistent;

    }

    public static interface ContextSettingsChangedHandler {
        public ContextType getContextType();

        public void onContextSettingsChanged(List<Pair<String, String>> var1, List<String> var2);
    }
}

