/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application;

import com.t4login.application.chart.settings.ChartProfile;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.IConfigBuilder;
import com.t4login.application.configuration.RequiresRole;
import com.t4login.application.configuration.UserRole;
import com.t4login.application.quoteboard.settings.QuoteBoardPage;
import com.t4login.application.settings.GeneralSettings;
import java.lang.reflect.Field;

public class ConfigContext {
    public static final ConfigContext Default = new ConfigContext();
    public UserRole mUserRole = UserRole.Basic;

    public Object createConfigurable(String name) {
        if (name.equals("GeneralSettings")) {
            return new GeneralSettings();
        }
        return null;
    }

    public void setUserRole(UserRole r) {
        this.mUserRole = r;
    }

    public UserRole getUserRole() {
        return this.mUserRole;
    }

    public boolean isFiltered(Configurable config, Field f) {
        boolean filtered = config.filterProperty(f.getName());
        if (!filtered) {
            UserRole fieldRole = UserRole.Basic;
            RequiresRole reqRole = f.getAnnotation(RequiresRole.class);
            if (reqRole != null) {
                fieldRole = reqRole.value();
            }
            if (fieldRole == UserRole.NotAllowed || fieldRole.ordinal() > this.mUserRole.ordinal()) {
                filtered = true;
            }
        }
        return filtered;
    }

    static {
        Configurable.registerConfigBuilder("ChartProfile", new IConfigBuilder(){

            @Override
            public Configurable buildConfigObject(String uid) {
                return new ChartProfile();
            }
        });
        Configurable.registerConfigBuilder("GeneralSettings", uid -> new GeneralSettings());
        Configurable.registerConfigBuilder("DataSettings", uid -> new GeneralSettings());
        Configurable.registerConfigBuilder("QuoteBoardPage", uid -> new QuoteBoardPage());
        Configurable.registerConfigBuilder("QuoteBoardPage$PageEntry", uid -> new QuoteBoardPage.PageEntry());
    }
}

