/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.apivalidation;

import com.t4login.APIName;
import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.UnValidated;
import com.t4login.messages.Message;
import com.t4login.messages.MessageType;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValidationBuilder {
    private static final String TAG = "ValidationBuilder";
    List<MessageClass> mMessages = new ArrayList<MessageClass>();
    HashMap<String, EnumClass> mEnumClasses = new HashMap();

    public List<String> getEnumList() {
        ArrayList<String> enums = new ArrayList<String>();
        for (EnumClass enumClass : this.mEnumClasses.values()) {
            Object prefix = "";
            if (enumClass.IsSafe) {
                prefix = (String)prefix + "*";
            }
            if (enumClass.IsSet) {
                prefix = (String)prefix + "+";
            }
            if (!((String)prefix).isEmpty()) {
                prefix = (String)prefix + " ";
            }
            if (enumClass.Class.isAnnotationPresent(APIName.class)) {
                APIName apiName = enumClass.Class.getAnnotation(APIName.class);
                enums.add((String)prefix + apiName.value() + " as " + enumClass.Class.getSimpleName());
                continue;
            }
            enums.add((String)prefix + enumClass.Class.getSimpleName());
        }
        Collections.sort(enums);
        return enums;
    }

    public boolean addMessage(Class<?> msgClass) {
        if (!Message.class.isAssignableFrom(msgClass)) {
            Log.d(TAG, "addMessage(), Class '" + msgClass.getName() + "' is not a subclass of Message.");
            return false;
        }
        if (msgClass.isAnnotationPresent(UnValidated.class)) {
            Log.d(TAG, "addMessage(), Class '" + msgClass.getName() + "' is marked UnValidated.");
            return false;
        }
        try {
            Constructor<?> constructor = msgClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Message instance = (Message)constructor.newInstance(new Object[0]);
            MessageType msgType = instance.getMessageType();
            this.mMessages.add(new MessageClass(msgClass, msgType));
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        for (Field f : msgClass.getDeclaredFields()) {
            boolean hasDescr;
            Type type = f.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type[] ata = pType.getActualTypeArguments();
                TypeVariable<Class<T>>[] tps = ((Class)pType.getRawType()).getTypeParameters();
                for (int i = 0; i < tps.length; ++i) {
                    boolean hasDescr2;
                    Class value = (Class)ata[i];
                    if (ata[i] instanceof TypeVariable) continue;
                    boolean isEnum = value.isEnum();
                    boolean isFlags = pType.getRawType() == EnumSet.class || pType.getRawType() == Set.class;
                    boolean bl = hasDescr2 = this.getDescrField(value) != null;
                    if (isEnum) {
                        this.mEnumClasses.put(value.getName(), new EnumClass(value, false, isFlags, hasDescr2));
                        continue;
                    }
                    if (value.isAnnotationPresent(AsEnum.class)) {
                        this.mEnumClasses.put(value.getName(), new EnumClass(value, true, isFlags, hasDescr2));
                        continue;
                    }
                    if (value.getPackage() != msgClass.getPackage()) continue;
                    this.addType(value);
                }
                continue;
            }
            Class<?> fieldType = f.getType();
            boolean isEnum = fieldType.isEnum();
            boolean bl = hasDescr = this.getDescrField(fieldType) != null;
            if (isEnum) {
                this.mEnumClasses.put(fieldType.getName(), new EnumClass(fieldType, false, false, hasDescr));
                continue;
            }
            if (fieldType.isAnnotationPresent(AsEnum.class)) {
                this.mEnumClasses.put(fieldType.getName(), new EnumClass(fieldType, true, false, hasDescr));
                continue;
            }
            if (fieldType.getPackage() != msgClass.getPackage()) continue;
            this.addType(fieldType);
        }
        return true;
    }

    public boolean addType(Class<?> msgClass) {
        for (Field f : msgClass.getDeclaredFields()) {
            boolean hasDescr;
            Type type = f.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type[] ata = pType.getActualTypeArguments();
                TypeVariable<Class<T>>[] tps = ((Class)pType.getRawType()).getTypeParameters();
                for (int i = 0; i < tps.length; ++i) {
                    boolean hasDescr2;
                    Class value = (Class)ata[i];
                    if (ata[i] instanceof TypeVariable) continue;
                    value = (Class)ata[i];
                    boolean isEnum = value.isEnum();
                    boolean isFlags = pType.getRawType() == EnumSet.class || pType.getRawType() == Set.class;
                    boolean bl = hasDescr2 = this.getDescrField(value) != null;
                    if (isEnum) {
                        this.mEnumClasses.put(value.getName(), new EnumClass(value, false, isFlags, hasDescr2));
                        continue;
                    }
                    if (value.isAnnotationPresent(AsEnum.class)) {
                        this.mEnumClasses.put(value.getName(), new EnumClass(value, true, isFlags, hasDescr2));
                        continue;
                    }
                    if (value.getPackage() != msgClass.getPackage()) continue;
                    this.addType(value);
                }
                continue;
            }
            Class<?> fieldType = f.getType();
            boolean isEnum = fieldType.isEnum();
            boolean bl = hasDescr = this.getDescrField(fieldType) != null;
            if (isEnum) {
                this.mEnumClasses.put(fieldType.getName(), new EnumClass(fieldType, false, false, hasDescr));
                continue;
            }
            if (fieldType.isAnnotationPresent(AsEnum.class)) {
                this.mEnumClasses.put(fieldType.getName(), new EnumClass(fieldType, true, false, hasDescr));
                continue;
            }
            if (fieldType.getPackage() != msgClass.getPackage()) continue;
            this.addType(fieldType);
        }
        return true;
    }

    public boolean createValidationFile(String fileName) {
        try {
            Document doc = this.getvalidationDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            File ext = new File("./");
            Log.d(TAG, "createValidationFile(), Location: " + ext.getAbsolutePath());
            StreamResult result = new StreamResult(new File(ext, fileName));
            transformer.transform(source, result);
            return true;
        }
        catch (SecurityException e) {
            Log.e(TAG, "createValidationFile(), Error.", e);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "createValidationFile(), Error.", e);
        }
        catch (TransformerException e) {
            Log.e(TAG, "createValidationFile(), Error.", e);
        }
        return false;
    }

    public boolean dumpValidationFile() {
        try {
            Document doc = this.getvalidationDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(source, result);
            return true;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return false;
    }

    private Document getvalidationDocument() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("api");
            doc.appendChild(rootElement);
            Element xmlMessages = doc.createElement("messages");
            rootElement.appendChild(xmlMessages);
            for (MessageClass msg : this.mMessages) {
                Element xmlMessage = doc.createElement("message");
                xmlMessages.appendChild(xmlMessage);
                String msgName = msg.Class.getSimpleName();
                if (msg.Class.isAnnotationPresent(APIName.class)) {
                    APIName apiName = msg.Class.getAnnotation(APIName.class);
                    msgName = apiName.value();
                }
                xmlMessage.setAttribute("name", msgName);
                xmlMessage.setAttribute("type", Integer.toString(msg.MessageType.getValue()));
                xmlMessage.setAttribute("version", Integer.toString(msg.MessageType.getVersion()));
                xmlMessage.setAttribute("minSupportedVersion", Integer.toString(msg.MessageType.getMinSupportedVersion()));
            }
            Element xmlEnums = doc.createElement("enums");
            rootElement.appendChild(xmlEnums);
            for (EnumClass enumClass : this.mEnumClasses.values()) {
                Element xmlEnum = doc.createElement("enum");
                xmlEnums.appendChild(xmlEnum);
                String enumName = enumClass.Class.getSimpleName();
                String javaName = "";
                if (enumClass.Class.isAnnotationPresent(APIName.class)) {
                    APIName apiName = enumClass.Class.getAnnotation(APIName.class);
                    javaName = enumName;
                    enumName = apiName.value();
                }
                xmlEnum.setAttribute("name", enumName);
                if (!javaName.equals("")) {
                    xmlEnum.setAttribute("javaname", javaName);
                }
                xmlEnum.setAttribute("safe", Boolean.toString(enumClass.IsSafe));
                xmlEnum.setAttribute("set", Boolean.toString(enumClass.IsSet));
                xmlEnum.setAttribute("descr", Boolean.toString(enumClass.HasDescr));
                if (enumClass.Class.isEnum()) {
                    Method getValueMethod = enumClass.Class.getMethod("getValue", new Class[0]);
                    for (Object obj : enumClass.Class.getEnumConstants()) {
                        String constantName = obj.toString();
                        if (enumClass.Class.getField(constantName).isAnnotationPresent(APIName.class)) {
                            APIName apiName = enumClass.Class.getField(constantName).getAnnotation(APIName.class);
                            constantName = apiName.value();
                        }
                        Integer constantValue = (Integer)getValueMethod.invoke(obj, (Object[])null);
                        Element xmlEnumConstant = doc.createElement("constant");
                        xmlEnum.appendChild(xmlEnumConstant);
                        xmlEnumConstant.setAttribute("name", constantName);
                        xmlEnumConstant.setAttribute("value", Integer.toString(constantValue));
                        xmlEnumConstant.setAttribute("descr", "");
                    }
                    continue;
                }
                if (!enumClass.Class.isAnnotationPresent(AsEnum.class)) continue;
                Field descrField = this.getDescrField(enumClass.Class);
                if (descrField != null) {
                    descrField.setAccessible(true);
                }
                for (Field field : enumClass.Class.getFields()) {
                    if (!field.isAnnotationPresent(Constant.class)) continue;
                    Constant constant = field.getAnnotation(Constant.class);
                    String constantName = field.getName();
                    if (field.isAnnotationPresent(APIName.class)) {
                        APIName apiName = enumClass.Class.getField(constantName).getAnnotation(APIName.class);
                        constantName = apiName.value();
                    }
                    int constantValue = constant.value();
                    Element xmlEnumConstant = doc.createElement("constant");
                    xmlEnum.appendChild(xmlEnumConstant);
                    xmlEnumConstant.setAttribute("name", constantName);
                    xmlEnumConstant.setAttribute("value", Integer.toString(constantValue));
                    xmlEnumConstant.setAttribute("descr", "");
                }
            }
            return doc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Field getDescrField(Class<?> type) {
        Field descrField = null;
        try {
            descrField = type.getDeclaredField("descr");
        }
        catch (NoSuchFieldException nfex) {
            descrField = null;
        }
        return descrField;
    }

    private static class EnumClass {
        public final Class<?> Class;
        public final boolean IsSafe;
        public final boolean IsSet;
        public final boolean HasDescr;

        public EnumClass(Class<?> cls, boolean safe, boolean set, boolean descr) {
            this.Class = cls;
            this.IsSafe = safe;
            this.IsSet = set;
            this.HasDescr = descr;
        }
    }

    private static class MessageClass {
        public final Class<?> Class;
        public final MessageType MessageType;

        public MessageClass(Class<?> cls, MessageType msgtyp) {
            this.Class = cls;
            this.MessageType = msgtyp;
        }
    }
}

