/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.usersettings;

import com.t4login.Log;
import com.t4login.api.UserData;
import com.t4login.api.usersettings.ISettingsParser;
import com.t4login.api.usersettings.RetainedSettingsParser;
import com.t4login.api.usersettings.T4WebTraderUserSettingsXmlParser;
import com.t4login.application.ContextSettings;
import com.t4login.application.quoteboard.settings.QuoteBoardLayout;
import com.t4login.application.quoteboard.settings.QuoteBoardPage;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.messages.MsgUserSettings;
import com.t4login.util.Pair;
import com.t4login.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UserSettingsXmlParser {
    private static final String TAG = "UserSettingsXmlParser";
    private static final String ns = null;
    private Map<String, ISettingsParser> mSettingsParsers = new HashMap<String, ISettingsParser>();
    private RetainedSettingsParser mRetainedSettingsParser = new RetainedSettingsParser();

    public UserSettingsXmlParser registerSettingParser(String name, ISettingsParser parser) {
        this.mSettingsParsers.put(name.toLowerCase(), parser);
        return this;
    }

    public static NDateTime parseTimeStamp(String xml) {
        if (xml == null || xml.isEmpty()) {
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF8"));
            try {
                XmlPullParser parser = Xml.newPullParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput(in, null);
                parser.nextTag();
                String name = parser.getName();
                if (name.equalsIgnoreCase("t4android")) {
                    String versionStr = parser.getAttributeValue(null, "v");
                    int version = 0;
                    if (versionStr != null && !versionStr.isEmpty()) {
                        version = Integer.parseInt(versionStr);
                    }
                    String dtStr = parser.getAttributeValue(null, "dt");
                    NDateTime dt = null;
                    if (dtStr != null && !dtStr.isEmpty()) {
                        dt = NDateTime.from(dtStr, UserData.TIMESTAMP_FORMAT);
                        return dt;
                    }
                }
            }
            catch (XmlPullParserException pex) {
                Log.e(TAG, "parseTimeStamp(), Parser error.", pex);
            }
            catch (Exception ex) {
                Log.e(TAG, "parseTimeStamp(), Error processing user settings.", ex);
            }
        }
        catch (UnsupportedEncodingException encex) {
            Log.e(TAG, "parseTimeStamp(), Encoding error processing user settings.", encex);
        }
        return null;
    }

    public void registerSettingsParser(String name, ISettingsParser parser) {
        this.mSettingsParsers.put(name, parser);
    }

    public List<Pair<String, String>> getRetainedSettings() {
        return this.mRetainedSettingsParser.retainedSettings;
    }

    public int parse(MsgUserSettings msg) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(msg.Settings.getBytes("UTF8"));
            try {
                return this.parse(in);
            }
            catch (XmlPullParserException pex) {
                Log.e(TAG, "Parser error processing user settings.", pex);
            }
            catch (Exception ex) {
                Log.e(TAG, "Error processing user settings.", ex);
            }
        }
        catch (UnsupportedEncodingException encex) {
            Log.e(TAG, "Encoding error processing user settings.", encex);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            ContextSettings.persistent.beginBatchUpdate();
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput(in, null);
            parser.nextTag();
            String name = parser.getName();
            if (name.equalsIgnoreCase("t4android")) {
                int ver;
                int n = ver = this.readT4AndroidSettings(parser);
                return n;
            }
            if (name.equalsIgnoreCase("T4WebTraderSettings")) {
                this.readT4WebTraderSettings(parser);
                int n = 0;
                return n;
            }
            if (name.equalsIgnoreCase("UserSettings")) {
            } else {
                Log.e(TAG, "Unexpected tag in config file: '" + name + "'. Expected <t4android>.");
            }
        }
        finally {
            in.close();
            ContextSettings.persistent.endBatchUpdate(false);
        }
        return -1;
    }

    private int readT4AndroidSettings(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "t4android");
        String versionStr = parser.getAttributeValue(null, "v");
        int version = 0;
        if (versionStr != null && !versionStr.isEmpty()) {
            version = Integer.parseInt(versionStr);
        }
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            Log.d(TAG, "readT4AndroidSettings(), Element: " + parser.getName());
            ISettingsParser settingsParser = this.mSettingsParsers.get(name.toLowerCase());
            if (settingsParser != null) {
                settingsParser.parse(parser);
                continue;
            }
            this.mRetainedSettingsParser.parse(parser);
        }
        AppSettings.settingsUpdated(true);
        return version;
    }

    public static String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        int event = parser.next();
        if (event == 4) {
            result = parser.getText();
            parser.nextTag();
        } else if (event == 5) {
            result = parser.getText();
        }
        return result;
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.nextToken()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    public static String getInnerXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder();
        int depth = 1;
        block4: while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    if (--depth <= 0) continue block4;
                    sb.append("</" + parser.getName() + ">");
                    continue block4;
                }
                case 2: {
                    ++depth;
                    StringBuilder attrs = new StringBuilder();
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrs.append(parser.getAttributeName(i) + "=\"" + parser.getAttributeValue(i) + "\" ");
                    }
                    sb.append("<" + parser.getName() + " " + attrs.toString() + ">");
                    continue block4;
                }
            }
            sb.append(parser.getText());
        }
        String content = sb.toString();
        return content;
    }

    private void readT4WebTraderSettings(XmlPullParser parser) throws XmlPullParserException, IOException {
        T4WebTraderUserSettingsXmlParser wt = new T4WebTraderUserSettingsXmlParser();
        wt.parseT4WebTraderSettings(parser);
        AppSettings.instance.General.ShowPL = !wt.hideAccountSummary;
        boolean bl = AppSettings.instance.General.ShowCash = !wt.hideAccountSummary;
        if (!wt.soundsEnabled) {
            AppSettings.instance.Sounds.OnFill.Enabled = false;
            AppSettings.instance.Sounds.OnPartialFill.Enabled = false;
            AppSettings.instance.Sounds.OnPitFill.Enabled = false;
            AppSettings.instance.Sounds.OnSubmission.Enabled = false;
            AppSettings.instance.Sounds.OnWorking.Enabled = false;
            AppSettings.instance.Sounds.OnPulled.Enabled = false;
            AppSettings.instance.Sounds.OnRejected.Enabled = false;
        } else {
            int maskFill = 32;
            int maskPartFill = 16;
            int maskWorking = 8;
            int maskRej = 4;
            int maskSub = 2;
            int maskPull = 1;
            AppSettings.instance.Sounds.OnFill.Enabled = (wt.sounds & maskFill) == maskFill;
            AppSettings.instance.Sounds.OnPartialFill.Enabled = (wt.sounds & maskPartFill) == maskPartFill;
            AppSettings.instance.Sounds.OnPitFill.Enabled = (wt.sounds & maskFill) == maskFill;
            AppSettings.instance.Sounds.OnSubmission.Enabled = (wt.sounds & maskSub) == maskSub;
            AppSettings.instance.Sounds.OnWorking.Enabled = (wt.sounds & maskWorking) == maskWorking;
            AppSettings.instance.Sounds.OnPulled.Enabled = (wt.sounds & maskPull) == maskPull;
            AppSettings.instance.Sounds.OnRejected.Enabled = (wt.sounds & maskRej) == maskRej;
        }
        AppSettings.instance.DisplayLight.BidColor = wt.buyColor;
        AppSettings.instance.DisplayLight.OfferColor = wt.sellColor;
        AppSettings.instance.DisplayLight.TradeColor = wt.cTradeColor;
        AppSettings.instance.DisplayLight.PositiveValueColor = wt.gainColor;
        AppSettings.instance.DisplayLight.NegativeValueColor = wt.lossColor;
        QuoteBoardLayout.instance.Pages.clear();
        int idx = 0;
        for (T4WebTraderUserSettingsXmlParser.Tab tab : wt.tabs) {
            QuoteBoardPage pg = new QuoteBoardPage();
            pg.PageName = tab.name;
            QuoteBoardLayout.addPage(pg);
            for (T4WebTraderUserSettingsXmlParser.TabItem item : tab.items) {
                QuoteBoardPage.PageEntry entry = new QuoteBoardPage.PageEntry();
                entry.ExchangeID = item.exchange;
                entry.ContractID = item.contract;
                entry.MarketID = item.market;
                pg.Entries.add(entry);
            }
            if (tab.active) {
                ContextSettings.persistent.saveInt("quoteboard.currentpage", idx);
            }
            ++idx;
        }
    }
}

