/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.usersettings;

import com.t4login.api.usersettings.UserSettingsXmlParser;
import com.t4login.util.ColorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class T4WebTraderUserSettingsXmlParser {
    private static final String TAG = "T4WebTraderUserSettingsXmlParser";
    public boolean hideAccountSummary = false;
    public boolean persistAlerts = false;
    public int orderSort = 0;
    public int positionSort = 0;
    public int quoteSort = 0;
    public int quoteBoardVolume = 0;
    public int contractVolume = 0;
    public int buyColor = 0;
    public int sellColor = 0;
    public int gainColor = 0;
    public int lossColor = 0;
    public int qBidColor = 0;
    public int qOfferColor = 0;
    public int qTradeColor = 0;
    public int cBidColor = 0;
    public int cOfferColor = 0;
    public int cTradeColor = 0;
    public boolean soundsEnabled = false;
    public int sounds = 0;
    public List<Tab> tabs = new ArrayList<Tab>();
    private static final String ns = null;

    public void parseT4WebTraderSettings(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "T4WebTraderSettings");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("windows")) {
                this.parseWindows(parser);
                continue;
            }
            if (name.equalsIgnoreCase("colors")) {
                this.parseColors(parser);
                continue;
            }
            if (name.equalsIgnoreCase("sounds")) {
                this.parseSounds(parser);
                continue;
            }
            if (name.equalsIgnoreCase("tabs")) {
                this.parseTabs(parser);
                continue;
            }
            UserSettingsXmlParser.skip(parser);
        }
    }

    private void parseWindows(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "windows");
        while (parser.next() != 3) {
            int val;
            String valText;
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("hideAcctSum")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.hideAccountSummary = val = !valText.equals("0") ? 1 : 0;
                continue;
            }
            if (name.equalsIgnoreCase("persistAlerts")) {
                valText = UserSettingsXmlParser.readText(parser);
                val = !valText.equals("0") ? 1 : 0;
                this.persistAlerts = val;
                continue;
            }
            if (name.equalsIgnoreCase("orderSort")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.orderSort = val = Integer.parseInt(valText);
                continue;
            }
            if (name.equalsIgnoreCase("positionSort")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.positionSort = val = Integer.parseInt(valText);
                continue;
            }
            if (name.equalsIgnoreCase("quoteSort")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.quoteSort = val = Integer.parseInt(valText);
                continue;
            }
            if (name.equalsIgnoreCase("qbVolume")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.quoteBoardVolume = val = Integer.parseInt(valText);
                continue;
            }
            if (name.equalsIgnoreCase("dpVolume")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.contractVolume = val = Integer.parseInt(valText);
                continue;
            }
            UserSettingsXmlParser.skip(parser);
        }
    }

    public void parseColors(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "colors");
        while (parser.next() != 3) {
            int cVal;
            String cValText;
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("buy")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.buyColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("sell")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.sellColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("gain")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.gainColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("loss")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.lossColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("qBid")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.qBidColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("qOffer")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.qOfferColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("qTrade")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.qTradeColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("cBid")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.cBidColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("cOffer")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.cOfferColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            if (name.equalsIgnoreCase("cTrade")) {
                cValText = UserSettingsXmlParser.readText(parser);
                this.cTradeColor = cVal = ColorUtil.parseColor(cValText);
                continue;
            }
            UserSettingsXmlParser.skip(parser);
        }
    }

    public void parseSounds(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "sounds");
        while (parser.next() != 3) {
            int val;
            String valText;
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("enabled")) {
                valText = UserSettingsXmlParser.readText(parser);
                val = !valText.equals("0") ? 1 : 0;
                this.soundsEnabled = val;
                continue;
            }
            if (name.equalsIgnoreCase("play")) {
                valText = UserSettingsXmlParser.readText(parser);
                this.sounds = val = Integer.parseInt(valText);
                continue;
            }
            UserSettingsXmlParser.skip(parser);
        }
    }

    public void parseTabs(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "tabs");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("tab")) {
                this.parseTab(parser);
                continue;
            }
            UserSettingsXmlParser.skip(parser);
        }
    }

    public void parseTab(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "tab");
        String markets = "";
        String contracts = "";
        String exchanges = "";
        Tab tab = new Tab();
        this.tabs.add(tab);
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("markets")) {
                markets = UserSettingsXmlParser.readText(parser);
                continue;
            }
            if (name.equalsIgnoreCase("contracts")) {
                contracts = UserSettingsXmlParser.readText(parser);
                continue;
            }
            if (name.equalsIgnoreCase("exchanges")) {
                exchanges = UserSettingsXmlParser.readText(parser);
                continue;
            }
            if (name.equalsIgnoreCase("title")) {
                tab.name = UserSettingsXmlParser.readText(parser);
                continue;
            }
            if (name.equalsIgnoreCase("active")) {
                boolean val;
                String valText = UserSettingsXmlParser.readText(parser);
                tab.active = val = !valText.equals("0");
                continue;
            }
            UserSettingsXmlParser.skip(parser);
        }
        if (!markets.isEmpty()) {
            String[] mktVals = markets.split("\\|");
            String[] cntrVals = contracts.split("\\|");
            String[] exchVals = exchanges.split("\\|");
            for (int i = 0; i < mktVals.length; ++i) {
                TabItem item = new TabItem();
                item.exchange = exchVals[i];
                item.contract = cntrVals[i];
                item.market = mktVals[i];
                tab.items.add(item);
            }
        }
    }

    public static class Tab {
        public String name = "";
        public boolean active = false;
        public List<TabItem> items = new ArrayList<TabItem>();
    }

    public static class TabItem {
        public String exchange = "";
        public String contract = "";
        public String market = "";
    }
}

