/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.usersettings;

import com.t4login.Log;
import com.t4login.api.usersettings.ISettingsParser;
import com.t4login.application.ContextSettings;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ContextSettingsParser
implements ISettingsParser {
    private static final String TAG = "ContextSettingsParser";

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "context_settings");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("setting")) {
                this.readSetting(parser);
                continue;
            }
            ContextSettingsParser.skip(parser);
        }
    }

    private void readSetting(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, null, "setting");
        String name = parser.getAttributeValue(null, "name");
        String type = parser.getAttributeValue(null, "type");
        if (type.equals("s")) {
            String sVal = ContextSettingsParser.readText(parser);
            ContextSettings.persistent.saveString(name, sVal);
        } else if (type.equals("x")) {
            String sVal = ContextSettingsParser.readText(parser);
            ContextSettings.persistent.saveString(name, sVal);
        } else if (type.equals("i")) {
            String sVal = ContextSettingsParser.readText(parser);
            try {
                Integer iVal = Integer.parseInt(sVal);
                ContextSettings.persistent.saveInt(name, iVal);
            }
            catch (NumberFormatException fmtEx) {
                Log.e(TAG, "readSetting(), Error reading integer setting: name: " + name + ", value: " + sVal, fmtEx);
            }
        } else if (type.equals("f")) {
            String sVal = ContextSettingsParser.readText(parser);
            try {
                Float fVal = Float.valueOf(Float.parseFloat(sVal));
                ContextSettings.persistent.saveFloat(name, fVal.floatValue());
            }
            catch (NumberFormatException fmtEx) {
                Log.e(TAG, "readSetting(), Error reading float setting: name: " + name + ", value: " + sVal, fmtEx);
            }
        } else if (type.equals("b")) {
            String sVal = ContextSettingsParser.readText(parser);
            try {
                Boolean bVal = Boolean.parseBoolean(sVal);
                ContextSettings.persistent.saveBoolean(name, bVal);
            }
            catch (NumberFormatException fmtEx) {
                Log.e(TAG, "readSetting(), Error reading boolean setting: name: " + name + ", value: " + sVal, fmtEx);
            }
        } else if (type.equals("l")) {
            String sVal = ContextSettingsParser.readText(parser);
            try {
                Long lVal = Long.parseLong(sVal);
                ContextSettings.persistent.saveLong(name, lVal);
            }
            catch (NumberFormatException fmtEx) {
                Log.e(TAG, "readSetting(), Error reading long setting: name: " + name + ", value: " + sVal, fmtEx);
            }
        } else if (type.equals("m")) {
            Log.e(TAG, "readSetting(), Error reading Set<string> setting. Not Implemented.");
        }
        parser.require(3, null, "setting");
    }

    public static String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        int event = parser.next();
        if (event == 4) {
            result = parser.getText();
            parser.nextTag();
        } else if (event == 5) {
            result = parser.getText();
        }
        return result;
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.nextToken()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }
}

