/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.user.notification;

import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserAlertMessaageData
implements Serializable {
    public static final String TAG = "UserAlertMessaageData";
    private String mSourceJSON = null;
    public UserData user = new UserData();
    public String taskID;
    public String taskDescription;
    public List<AlertData> alerts = new ArrayList<AlertData>();

    public UserAlertMessaageData() {
    }

    public UserAlertMessaageData(String srcJSON) {
        this.mSourceJSON = srcJSON;
    }

    public boolean tryCombineWith(UserAlertMessaageData newer) {
        if (this.user != null && newer.user != null && this.user.userID.equals(newer.user.userID) && this.taskID.equals(newer.taskID)) {
            this.alerts.addAll(newer.alerts);
            Collections.sort(this.alerts, new Comparator<AlertData>(this){

                @Override
                public int compare(AlertData o1, AlertData o2) {
                    return Long.compare(o2.timeStamp, o1.timeStamp);
                }
            });
            return true;
        }
        return false;
    }

    public JSONObject buildJSON() {
        JSONObject configObject = new JSONObject();
        try {
            JSONObject userObject = new JSONObject();
            configObject.put("user", (Object)userObject);
            userObject.put("serverType", (Object)this.user.serverType);
            userObject.put("userID", (Object)this.user.userID);
            userObject.put("firm", (Object)this.user.firm);
            userObject.put("userName", (Object)this.user.userName);
            configObject.put("taskID", (Object)this.taskID);
            configObject.put("taskDescription", (Object)this.taskDescription);
            JSONArray fillsArray = new JSONArray();
            configObject.put("fills", (Object)fillsArray);
            for (AlertData alert : this.alerts) {
                JSONObject fillObject = new JSONObject();
                fillsArray.put((Object)fillObject);
                fillObject.put("timeStamp", alert.timeStamp);
                fillObject.put("messageBody", (Object)alert.messageBody);
                fillObject.put("messageFooter", alert.messageFooter);
            }
        }
        catch (JSONException jex) {
            Log.e(TAG, "buildJSON(), Error: " + jex.toString());
        }
        return configObject;
    }

    public static UserAlertMessaageData fromJSON(String json) {
        UserAlertMessaageData msg = new UserAlertMessaageData(json);
        try {
            JSONObject msgObject = new JSONObject(json);
            if (msgObject.has("user")) {
                JSONObject userObject = msgObject.getJSONObject("user");
                if (userObject.has("serverType")) {
                    msg.user.serverType = userObject.getString("serverType");
                }
                if (userObject.has("userID")) {
                    msg.user.userID = userObject.getString("userID");
                }
                if (userObject.has("firm")) {
                    msg.user.firm = userObject.getString("firm");
                }
                if (userObject.has("userName")) {
                    msg.user.userName = userObject.getString("userName");
                }
            }
            if (msgObject.has("taskID")) {
                msg.taskID = msgObject.getString("taskID");
            }
            if (msgObject.has("taskDescription")) {
                msg.taskDescription = msgObject.getString("taskDescription");
            }
            if (msgObject.has("alerts")) {
                JSONArray alertsArray = msgObject.getJSONArray("alerts");
                for (int i = 0; i < alertsArray.length(); ++i) {
                    JSONObject alertObject = alertsArray.getJSONObject(i);
                    AlertData alert = new AlertData();
                    msg.alerts.add(alert);
                    if (alertObject.has("timeStamp")) {
                        alert.timeStamp = alertObject.getLong("timeStamp");
                    }
                    if (alertObject.has("messageBody")) {
                        alert.messageBody = alertObject.getString("messageBody");
                    }
                    if (!alertObject.has("messageFooter")) continue;
                    alert.messageFooter = alertObject.getInt("messageFooter");
                }
            }
        }
        catch (JSONException jex) {
            Log.e(TAG, "fromJSON(), Error: " + jex.toString());
        }
        return msg;
    }

    public static class UserData {
        public String serverType;
        public String userID;
        public String firm;
        public String userName;
    }

    public static class AlertData {
        public long timeStamp;
        public String messageBody;
        public int messageFooter;
    }
}

