/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.user.notification;

import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PositionUpdateMessageData
implements Serializable {
    public static final String TAG = "PositionUpdateMessageData";
    private String mSourceJSON = null;
    public UserData user = new UserData();
    public String accountID;
    public String account;
    public String marketID;
    public String market;
    public List<FillData> fills = new ArrayList<FillData>();
    public PositionData position = new PositionData();
    public NotificationOptions options = new NotificationOptions();

    public PositionUpdateMessageData() {
    }

    public PositionUpdateMessageData(String srcJSON) {
        this.mSourceJSON = srcJSON;
    }

    public String getSourceJSON() {
        return this.buildJSON().toString();
    }

    public boolean tryCombineWith(PositionUpdateMessageData newer) {
        if (this.user != null && newer.user != null && this.user.userID.equals(newer.user.userID) && this.accountID.equals(newer.accountID) && this.marketID.equals(newer.marketID)) {
            if (this.fills.size() > 0 && newer.fills.size() > 0) {
                this.fills.addAll(newer.fills);
                Collections.sort(this.fills, new Comparator<FillData>(this){

                    @Override
                    public int compare(FillData o1, FillData o2) {
                        return Long.compare(o2.timeStamp, o1.timeStamp);
                    }
                });
            }
            if (newer.position.timeStamp >= this.position.timeStamp) {
                this.position = newer.position;
            }
            return true;
        }
        return false;
    }

    public JSONObject buildJSON() {
        JSONObject configObject = new JSONObject();
        try {
            JSONObject userObject = new JSONObject();
            configObject.put("user", (Object)userObject);
            userObject.put("serverType", (Object)this.user.serverType);
            userObject.put("userID", (Object)this.user.userID);
            userObject.put("firm", (Object)this.user.firm);
            userObject.put("userName", (Object)this.user.userName);
            configObject.put("accountID", (Object)this.accountID);
            configObject.put("account", (Object)this.account);
            configObject.put("marketID", (Object)this.marketID);
            configObject.put("market", (Object)this.market);
            JSONArray fillsArray = new JSONArray();
            configObject.put("fills", (Object)fillsArray);
            for (FillData fill : this.fills) {
                JSONObject fillObject = new JSONObject();
                fillsArray.put((Object)fillObject);
                fillObject.put("timeStamp", fill.timeStamp);
                fillObject.put("buySell", (Object)fill.buySell);
                fillObject.put("volume", fill.volume);
                fillObject.put("price", (Object)fill.price);
                fillObject.put("tradeID", (Object)fill.tradeID);
            }
            JSONObject positionObject = new JSONObject();
            configObject.put("position", (Object)positionObject);
            positionObject.put("timeStamp", this.position.timeStamp);
            positionObject.put("buys", this.position.buys);
            positionObject.put("sells", this.position.sells);
            positionObject.put("net", this.position.net);
            positionObject.put("implied", this.position.implied);
            positionObject.put("balanced", this.position.balanced);
            positionObject.put("workingBuys", this.position.workingBuys);
            positionObject.put("workingSells", this.position.workingSells);
            JSONObject optionsObject = new JSONObject();
            configObject.put("options", (Object)optionsObject);
            optionsObject.put("alertSound", (Object)this.options.alertSound);
            optionsObject.put("alertSoundVolume", this.options.alertSoundVolume);
            optionsObject.put("onTapAction", (Object)this.options.onTapAction);
        }
        catch (JSONException jex) {
            Log.e(TAG, "buildJSON(), Error: " + jex.toString());
        }
        return configObject;
    }

    public static PositionUpdateMessageData fromJSON(String json) {
        PositionUpdateMessageData msg = new PositionUpdateMessageData(json);
        try {
            JSONObject msgObject = new JSONObject(json);
            if (msgObject.has("user")) {
                JSONObject userObject = msgObject.getJSONObject("user");
                if (userObject.has("serverType")) {
                    msg.user.serverType = userObject.getString("serverType");
                }
                if (userObject.has("userID")) {
                    msg.user.userID = userObject.getString("userID");
                }
                if (userObject.has("firm")) {
                    msg.user.firm = userObject.getString("firm");
                }
                if (userObject.has("userName")) {
                    msg.user.userName = userObject.getString("userName");
                }
            }
            if (msgObject.has("accountID")) {
                msg.accountID = msgObject.getString("accountID");
            }
            if (msgObject.has("account")) {
                msg.account = msgObject.getString("account");
            }
            if (msgObject.has("marketID")) {
                msg.marketID = msgObject.getString("marketID");
            }
            if (msgObject.has("market")) {
                msg.market = msgObject.getString("market");
            }
            if (msgObject.has("fills")) {
                JSONArray fillsArray = msgObject.getJSONArray("fills");
                for (int i = 0; i < fillsArray.length(); ++i) {
                    JSONObject fillObject = fillsArray.getJSONObject(i);
                    FillData fill = new FillData();
                    msg.fills.add(fill);
                    if (fillObject.has("timeStamp")) {
                        fill.timeStamp = fillObject.getLong("timeStamp");
                    }
                    if (fillObject.has("buySell")) {
                        fill.buySell = fillObject.getString("buySell");
                    }
                    if (fillObject.has("volume")) {
                        fill.volume = fillObject.getInt("volume");
                    }
                    if (fillObject.has("price")) {
                        fill.price = fillObject.getString("price");
                    }
                    if (!fillObject.has("tradeID")) continue;
                    fill.tradeID = fillObject.getString("tradeID");
                }
            }
            if (msgObject.has("position")) {
                JSONObject positionObject = msgObject.getJSONObject("position");
                if (positionObject.has("timeStamp")) {
                    msg.position.timeStamp = positionObject.getLong("timeStamp");
                }
                if (positionObject.has("buys")) {
                    msg.position.buys = positionObject.getInt("buys");
                }
                if (positionObject.has("sells")) {
                    msg.position.sells = positionObject.getInt("sells");
                }
                msg.position.net = positionObject.has("net") ? positionObject.getInt("net") : msg.position.buys - msg.position.sells;
                if (positionObject.has("implied")) {
                    msg.position.implied = positionObject.getBoolean("implied");
                }
                msg.position.balanced = positionObject.has("balanced") ? positionObject.getBoolean("balanced") : true;
                if (positionObject.has("workingBuys")) {
                    msg.position.workingBuys = positionObject.getInt("workingBuys");
                }
                if (positionObject.has("workingSells")) {
                    msg.position.workingSells = positionObject.getInt("workingSells");
                }
            }
            if (msgObject.has("options")) {
                JSONObject optionsObject = msgObject.getJSONObject("options");
                if (optionsObject.has("alertSound")) {
                    msg.options.alertSound = optionsObject.getString("alertSound");
                }
                if (optionsObject.has("alertSoundVolume")) {
                    msg.options.alertSoundVolume = optionsObject.getInt("alertSoundVolume");
                }
                if (optionsObject.has("onTapAction")) {
                    msg.options.onTapAction = optionsObject.getString("onTapAction");
                }
            }
        }
        catch (JSONException jex) {
            Log.e(TAG, "fromJSON(), Error: " + jex.toString());
        }
        return msg;
    }

    public static class UserData {
        public String serverType;
        public String userID;
        public String firm;
        public String userName;
    }

    public static class PositionData {
        public long timeStamp;
        public int buys;
        public int sells;
        public int net;
        public boolean implied;
        public boolean balanced;
        public int workingBuys;
        public int workingSells;
    }

    public static class NotificationOptions {
        public String alertSound;
        public int alertSoundVolume;
        public String onTapAction;
    }

    public static class FillData {
        public long timeStamp;
        public String buySell;
        public int volume;
        public String price;
        public String tradeID;
    }
}

