/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.user.notification;

import com.t4login.Log;
import com.t4login.application.settings.PositionNotificationTapAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationConfig {
    private static final String TAG = "NotificationConfig";
    public Accounts accounts = new Accounts();
    public String fillSound = "";
    public int fillSoundVolume = 100;
    public PositionNotificationTapAction onPositionTap = PositionNotificationTapAction.RecentFills;
    public boolean implySpreadPositions = false;

    public JSONObject buildJSON() {
        JSONObject configObject = new JSONObject();
        try {
            JSONObject accountsObject = new JSONObject();
            configObject.put("accounts", (Object)accountsObject);
            configObject.put("fillSound", (Object)this.fillSound);
            configObject.put("fillSoundVolume", this.fillSoundVolume);
            configObject.put("onPositionTap", (Object)this.onPositionTap);
            configObject.put("implySpreadPositions", this.implySpreadPositions);
            accountsObject.put("all", this.accounts.all);
            if (this.accounts.include != null) {
                JSONArray accountsArray = new JSONArray();
                accountsObject.put("include", (Object)accountsArray);
                for (String accountID : this.accounts.include) {
                    accountsArray.put((Object)accountID);
                }
            }
        }
        catch (JSONException jex) {
            Log.e(TAG, "buildJSON(), Error: " + jex.toString());
        }
        return configObject;
    }

    public static NotificationConfig fromJSON(String json) {
        NotificationConfig config = new NotificationConfig();
        try {
            JSONObject configObject = new JSONObject(json);
            if (configObject.has("fillSound")) {
                config.fillSound = configObject.getString("fillSound");
            }
            if (configObject.has("fillSoundVolume")) {
                config.fillSoundVolume = configObject.getInt("fillSoundVolume");
            }
            if (configObject.has("onPositionTap")) {
                config.onPositionTap = PositionNotificationTapAction.valueOf(configObject.getString("onPositionTap"));
            }
            if (configObject.has("implySpreadPositions")) {
                config.implySpreadPositions = configObject.getBoolean("implySpreadPositions");
            }
            if (configObject.has("accounts")) {
                JSONObject accountsObject = configObject.getJSONObject("accounts");
                if (accountsObject.has("all")) {
                    config.accounts.all = accountsObject.getBoolean("all");
                }
                if (accountsObject.has("include")) {
                    JSONArray accountsArray = accountsObject.getJSONArray("include");
                    for (int i = 0; i < accountsArray.length(); ++i) {
                        config.accounts.include.add(accountsArray.getString(i));
                    }
                }
            }
        }
        catch (JSONException jex) {
            Log.e(TAG, "fromJSON(), Error: " + jex.toString());
        }
        return config;
    }

    public static class Accounts {
        public boolean all;
        public List<String> include = new ArrayList<String>();

        public Set<String> getIncludedAccounts() {
            HashSet<String> included = new HashSet<String>();
            if (this.include != null) {
                included.addAll(this.include);
            }
            return included;
        }
    }
}

