/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.user.notification;

import com.t4login.Log;
import com.t4login.definitions.IdentityResult;
import com.t4login.definitions.IdentityStatus;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class IdentityStatusMessageData
implements Serializable {
    public static final String TAG = "IdentityStatusMessageData";
    public UserData user = new UserData();
    public IdentityStatus status;
    public IdentityResult result;

    public boolean tryCombineWith(IdentityStatusMessageData newer) {
        if (this.user != null && newer.user != null && this.user.userID.equals(newer.user.userID)) {
            this.status = newer.status;
            this.result = newer.result;
            return true;
        }
        return false;
    }

    public JSONObject buildJSON() {
        JSONObject configObject = new JSONObject();
        try {
            JSONObject userObject = new JSONObject();
            configObject.put("user", (Object)userObject);
            userObject.put("serverType", (Object)this.user.serverType);
            userObject.put("userID", (Object)this.user.userID);
            userObject.put("firm", (Object)this.user.firm);
            userObject.put("userName", (Object)this.user.userName);
            configObject.put("status", (Object)this.status);
            configObject.put("result", (Object)this.result);
        }
        catch (JSONException jex) {
            Log.e(TAG, "buildJSON(), Error: " + jex.toString());
        }
        return configObject;
    }

    public static IdentityStatusMessageData fromJSON(String json) {
        IdentityStatusMessageData msg = new IdentityStatusMessageData();
        try {
            JSONObject msgObject = new JSONObject(json);
            if (msgObject.has("user")) {
                JSONObject userObject = msgObject.getJSONObject("user");
                if (userObject.has("serverType")) {
                    msg.user.serverType = userObject.getString("serverType");
                }
                if (userObject.has("userID")) {
                    msg.user.userID = userObject.getString("userID");
                }
                if (userObject.has("firm")) {
                    msg.user.firm = userObject.getString("firm");
                }
                if (userObject.has("userName")) {
                    msg.user.userName = userObject.getString("userName");
                }
            }
            if (msgObject.has("status")) {
                msg.status = IdentityStatus.get(msgObject.getInt("status"));
            }
            if (msgObject.has("result")) {
                msg.result = IdentityResult.get(msgObject.getInt("result"));
            }
        }
        catch (JSONException jex) {
            Log.e(TAG, "fromJSON(), Error: " + jex.toString());
        }
        return msg;
    }

    public static class UserData {
        public String serverType;
        public String userID;
        public String firm;
        public String userName;
    }
}

