/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.sparkline;

import com.t4login.Log;
import com.t4login.api.T4HostService;
import com.t4login.api.sparkline.ISparklineRequestor;
import com.t4login.api.sparkline.ISparklineSubscriptionHandler;
import com.t4login.api.sparkline.SparklineDataArgs;
import com.t4login.application.sparkline.SparklineChartData;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.TradingSchedule;
import com.t4login.util.TimeRange;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SparklineSubscription {
    private static final String TAG = "SparklineSubscription";
    private final T4HostService mService;
    private final ISparklineRequestor mSparklineRequestor;
    private final SparklineDataArgs mDataArgs;
    private final ISparklineSubscriptionHandler mDataHandler;
    private volatile SparklineChartData mSparkline = SparklineChartData.Empty;
    private volatile NDateTime mLastUpdateTime = NDateTime.MinValue;

    public SparklineSubscription(T4HostService s, ISparklineRequestor requestor, SparklineDataArgs args, ISparklineSubscriptionHandler h) {
        this.mService = s;
        this.mSparklineRequestor = requestor;
        this.mDataArgs = args;
        this.mDataHandler = h;
    }

    public SparklineChartData getSparkline() {
        return this.mSparkline;
    }

    public NDateTime getLastUpdateTime() {
        return this.mLastUpdateTime;
    }

    public String getMarketId() {
        return this.mDataArgs.Market.getMarketID();
    }

    public void start() {
        Log.d(TAG, "start(), %@, Starting sparkline subscription.");
        this.mSparkline = SparklineChartData.Empty;
        NDateTime tradeDate = this.getActiveTradeDate();
        Log.d(TAG, "start(), [%@], Requesting sparkline snapshot. TradeDate: %@", this.getMarketId(), tradeDate);
        SparklineChartData data = this.mSparklineRequestor.requestSparklineChart(this.mDataArgs.Market.getExchangeID(), this.mDataArgs.Market.getContractID(), this.mDataArgs.Market.getMarketID(), tradeDate, null);
        if (data != null) {
            Log.d(TAG, "start(), [%@], Snapshot received. TradeDate: %@, LTT: %@, Points: %d", this.getMarketId(), data.TradeDate.toDateString(), data.LastTradeTime.toDateTimeString(), data.Points.size());
            this.mSparkline = data;
            this.mDataHandler.onUpdated(this);
        } else {
            Log.e(TAG, "start(), [%@], Failed to retrieve spakline snapshot.", this.getMarketId());
        }
    }

    public void update() {
        NDateTime now = this.mService.getRemoteTime();
        if (now.Subtract(this.mLastUpdateTime).getTotalSeconds() > 60.0) {
            this.mLastUpdateTime = now;
            NDateTime tradeDate = this.getActiveTradeDate();
            if (tradeDate != this.mSparkline.TradeDate) {
                Log.d(TAG, "update(), Restarting the subscription with a new trade date: %@ (was %@)", tradeDate.toDateString(), this.mSparkline.TradeDate.toDateString());
                this.start();
                return;
            }
            Log.d(TAG, "update(), [%@], Requesting sparkline update. TradeDate: %@", this.getMarketId(), tradeDate.toDateString());
            SparklineChartData data = this.mSparklineRequestor.requestSparklineChart(this.mDataArgs.Market.getExchangeID(), this.mDataArgs.Market.getContractID(), this.mDataArgs.Market.getMarketID(), tradeDate, this.mSparkline.LastTradeTime);
            if (data != null) {
                Log.d(TAG, "start(), [%@], Update received. TradeDate: %@, LTT: %@, Points: %d", this.getMarketId(), data.TradeDate.toDateString(), data.LastTradeTime.toDateTimeString(), data.Points.size());
                if (data.Points.size() > 0) {
                    SparklineChartData updated;
                    NDateTime firstPointTime = data.Points.get((int)0).Time;
                    ArrayList points = this.mSparkline.Points.stream().filter(pt -> pt.gtTime().compareTo(firstPointTime) < 0).collect(Collectors.toCollection(ArrayList::new));
                    points.addAll(data.Points);
                    this.mSparkline = updated = new SparklineChartData(this.mSparkline.TradeDate, this.mSparkline.ExchangeID, this.mSparkline.ContractID, this.mSparkline.MarketID, this.mSparkline.Market, this.mSparkline.Resolution, this.mSparkline.Settlement, data.LastTradeTime, points);
                    this.mDataHandler.onUpdated(this);
                }
            } else {
                Log.e(TAG, "start(), [%@], Failed to retrieve spakline update. TradeDate: %@", this.getMarketId(), tradeDate);
            }
        }
    }

    public NDateTime getActiveTradeDate() {
        NDateTime now = this.mService.getRemoteTime();
        NDateTime tradeDate = this.mDataArgs.Market.Contract.getTradeDate(now);
        if (tradeDate == now.getDate()) {
            return tradeDate;
        }
        TradingSchedule schedule = this.mDataArgs.Market.Contract.getTradingSchedule();
        if (schedule.TradeDates.size() > 0) {
            List<TimeRange> openSessions = schedule.getOpenSessions(tradeDate);
            NDateTime lastTradeDate = schedule.TradeDates.get((int)(schedule.TradeDates.size() - 1)).tradeDate;
            if (openSessions.size() > 0 && now.compareTo(openSessions.get(0).start()) < 0) {
                NDateTime today = now.getDate();
                while (tradeDate.compareTo(now.getDate()) > 0) {
                    today = today.AddDays(-1.0);
                    tradeDate = this.mDataArgs.Market.Contract.getTradeDate(today);
                }
            } else if (tradeDate.compareTo(lastTradeDate) > 0) {
                return lastTradeDate;
            }
        }
        return tradeDate;
    }
}

