/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.sparkline;

import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.application.sparkline.SparklineChartData;
import com.t4login.application.sparkline.SparklineDataPoint;
import com.t4login.connection.CountingInputStream;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.VPT;
import com.t4login.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class SparklineReader {
    private static final String TAG = "SparklineReader";
    private static final int CTAG_SOF = 1;
    private static final int CTAG_MARKET_DEFINITION = 2;
    private static final int CTAG_SPARKLINE_POINT = 60;
    private static final int CTAG_SPARKLINE_POINT_N = 61;
    private static final int CTAG_SETTLEMENT_PRICE = 107;

    public static SparklineChartData readSparklineData(byte[] data, int dataLen) throws IOException {
        CountingInputStream cin = new CountingInputStream(new ByteArrayInputStream(data, 0, dataLen));
        int ver = Message.readInteger(cin);
        String exchangeId = Message.readString(cin);
        String contractId = Message.readString(cin);
        String marketId = Message.readString(cin);
        NDateTime td = new NDateTime(Message.readLong(cin));
        ChartDataType chartDataType = ChartDataType.get(Message.readInteger(cin));
        NDateTime lastTradeTime = new NDateTime(Message.readLong(cin));
        int chartDataLen = Message.readInteger(cin);
        ByteArrayInputStream chin = new ByteArrayInputStream(data, (int)cin.getCount(), chartDataLen);
        CountingInputStream cchin = new CountingInputStream(chin);
        int binVersion = 0;
        NDateTime tradeDate = NDateTime.MinValue;
        SparklineDataPoint settlement = null;
        ArrayList<SparklineDataPoint> points = new ArrayList<SparklineDataPoint>();
        IMarketConversion priceArgs = SparklineReader.getMarketConversion("", Price.Zero, 0, "", BigDecimal.ZERO, "", Price.Zero);
        while (cchin.available() > 0) {
            long nRead;
            cchin.resetCount();
            int len = Message.read7BitInteger(cchin);
            int tag = Message.read7BitInteger(cchin);
            switch (tag) {
                case 1: {
                    binVersion = Message.read7BitInteger(cchin);
                    tradeDate = new NDateTime(Message.read7BitLong(cchin));
                    break;
                }
                case 2: {
                    priceArgs = SparklineReader.getMarketConversion(Message.readString(cchin), Message.read7BitPrice(cchin), Message.read7BitInteger(cchin), Message.readString(cchin), Message.read7BitDecimal(cchin), Message.readString(cchin), Message.read7BitPriceN(cchin));
                    break;
                }
                case 60: {
                    points.add(new SparklineDataPoint(new NDateTime(Message.read7BitLong(cchin)), Message.read7BitInteger(cchin)));
                    break;
                }
                case 61: {
                    points.add(new SparklineDataPoint(new NDateTime(Message.read7BitLong(cchin)), -1 * Message.read7BitInteger(cchin)));
                    break;
                }
                case 107: {
                    settlement = new SparklineDataPoint(new NDateTime(Message.read7BitLong(cchin)), Message.read7BitInteger(cchin));
                    break;
                }
                default: {
                    Log.d(TAG, "readSparklineData(), Ignoring unknown tag: %d", tag);
                }
            }
            if ((nRead = cchin.getCount()) >= (long)len) continue;
            cchin.skip((long)len - nRead);
        }
        return new SparklineChartData(tradeDate, exchangeId, contractId, priceArgs.getMarketID(), priceArgs, chartDataType, settlement, lastTradeTime, points);
    }

    public static SparklineChartData emptyOf(Market market) {
        return new SparklineChartData(NDateTime.MinValue, market.getExchangeID(), market.getContractID(), market.getMarketID(), market, ChartDataType.Minute, null, NDateTime.MinValue, new ArrayList<SparklineDataPoint>());
    }

    private static IMarketConversion getMarketConversion(final String marketId, final Price minPriceIncrement, int decimals, final String priceCode, BigDecimal tickValue, String vptSpec, final Price minCabPrice) {
        final VPT vpt = new VPT(vptSpec);
        return new IMarketConversion(){

            @Override
            public String getMarketID() {
                return marketId;
            }

            @Override
            public int getDenominator() {
                return 0;
            }

            @Override
            public String getPriceCode() {
                return priceCode;
            }

            @Override
            public Price getMinPriceIncrement() {
                return minPriceIncrement;
            }

            @Override
            public VPT getVPT() {
                return vpt;
            }

            @Override
            public Price getMinCabPrice() {
                return minCabPrice;
            }

            @Override
            public int getRealDecimals() {
                return 0;
            }

            @Override
            public int getClearingDecimals() {
                return 0;
            }

            @Override
            public BigDecimal getPointValue() {
                return null;
            }

            @Override
            public Integer getYieldYears() {
                return null;
            }

            @Override
            public Double getYieldParValue() {
                return null;
            }

            @Override
            public Double getYieldRate() {
                return null;
            }

            @Override
            public Integer getYieldValueDenominator() {
                return null;
            }

            @Override
            public Double getYieldRedemption() {
                return null;
            }

            @Override
            public Double getYieldPaymentsPerYear() {
                return null;
            }

            @Override
            public Integer getYieldBasis() {
                return null;
            }
        };
    }
}

