/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.sparkline;

import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.api.T4HostService;
import com.t4login.api.sparkline.ISparklineDataHandler;
import com.t4login.api.sparkline.ISparklineRequestor;
import com.t4login.api.sparkline.ISparklineSubscriptionHandler;
import com.t4login.api.sparkline.SparklineDataArgs;
import com.t4login.api.sparkline.SparklineSubscription;
import com.t4login.application.sparkline.SparklineChartData;
import com.t4login.datetime.NDateTime;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SparklineData
implements ISparklineSubscriptionHandler {
    private static final String TAG = "SparklineData";
    private final T4HostService service;
    private final ISparklineRequestor sparklineRequestor;
    private final List<ISparklineDataHandler> sparklineDataHandlers = new CopyOnWriteArrayList<ISparklineDataHandler>();
    private final ConcurrentMap<String, SparklineSubscription> sparklineSubscriptions = new ConcurrentHashMap<String, SparklineSubscription>(100, 0.9f, 1);

    public SparklineData(T4HostService s, ISparklineRequestor r) {
        this.service = s;
        this.sparklineRequestor = r;
    }

    public void registerForSparklineData(ISparklineDataHandler handler) {
        if (!this.sparklineDataHandlers.contains(handler)) {
            this.sparklineDataHandlers.add(handler);
        }
    }

    public void unregisterForSparklineData(ISparklineDataHandler handler) {
        if (this.sparklineDataHandlers.contains(handler)) {
            this.sparklineDataHandlers.remove(handler);
        }
    }

    synchronized SparklineChartData getSparklineChart(Market market) {
        SparklineSubscription subscription = (SparklineSubscription)this.sparklineSubscriptions.get(market.getMarketID());
        if (subscription == null) {
            subscription = new SparklineSubscription(this.service, this.sparklineRequestor, new SparklineDataArgs(market), this);
            this.sparklineSubscriptions.put(market.getMarketID(), subscription);
            subscription.start();
            for (ISparklineDataHandler h : this.sparklineDataHandlers) {
                try {
                    h.onSparklineUpdated(subscription.getSparkline());
                }
                catch (Exception ex) {
                    Log.e(TAG, "getSparklineChart(), Callback raised as unhandled expcetion.", ex);
                }
            }
        } else if (subscription.getSparkline().TradeDate != NDateTime.MinValue) {
            subscription.update();
        }
        return subscription.getSparkline();
    }

    @Override
    public void onUpdated(SparklineSubscription subscription) {
        for (ISparklineDataHandler h : this.sparklineDataHandlers) {
            try {
                h.onSparklineUpdated(subscription.getSparkline());
            }
            catch (Exception ex) {
                Log.e(TAG, "onUpdated(), Callback raised as unhandled expcetion.", ex);
            }
        }
    }
}

