/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.minichart;

import com.t4login.api.minichart.MiniChartDataPoint;
import com.t4login.application.chart.BarInterval;
import com.t4login.collections.ImmutableLinkedList;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.priceconversion.Price;
import java.util.List;

public final class MiniChartDataSeries {
    public final NDateTime tradeDate;
    public final ImmutableLinkedList<MiniChartDataPoint> data;

    public MiniChartDataSeries(NDateTime tradeDate, ImmutableLinkedList<MiniChartDataPoint> data) {
        this.tradeDate = tradeDate;
        this.data = data;
    }

    public MiniChartDataSeries addBars(List<MiniChartDataPoint> bars) {
        ImmutableLinkedList<MiniChartDataPoint> updatedData = this.data;
        for (MiniChartDataPoint b : bars) {
            updatedData = updatedData.add(b);
        }
        return new MiniChartDataSeries(this.tradeDate, updatedData);
    }

    public MiniChartDataSeries addBar(MiniChartDataPoint bar) {
        return new MiniChartDataSeries(this.tradeDate, this.data.add(bar));
    }

    public MiniChartDataSeries aggregateTrade(NDateTime time, Price price) {
        NDateTime barTime = BarInterval.Bar1Minute.roundDownToInterval(time, NTimeSpan.Zero);
        if (this.data.isEmpty()) {
            return new MiniChartDataSeries(this.tradeDate, this.data.add(new MiniChartDataPoint(barTime, price)));
        }
        if (time.equals(this.data.getValue().time)) {
            return new MiniChartDataSeries(this.tradeDate, this.data.getTail().add(new MiniChartDataPoint(barTime, price)));
        }
        return new MiniChartDataSeries(this.tradeDate, this.data.add(new MiniChartDataPoint(barTime, price)));
    }
}

