/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.minichart;

import com.t4login.api.Market;
import com.t4login.api.minichart.MiniChartDataPoint;
import com.t4login.api.minichart.MiniChartDataSeries;
import com.t4login.api.minichart.MiniChartState;
import com.t4login.api.minichart.PriceIndicator;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Range;
import java.util.List;

public final class MiniChartDataModel {
    public final Market market;
    public final MiniChartState state;
    public final MiniChartDataSeries dataSeries;
    public final MarketMode marketMode;
    public final List<PriceIndicator> priceIndicators;
    public final Boolean isEmpty;
    public final Range<Price> minPriceRange;

    public MiniChartDataModel(Market market, MiniChartState state, MiniChartDataSeries dataSeries, MarketMode marketMode, List<PriceIndicator> priceIndicators, Range<Price> minPriceRange) {
        this(market, state, dataSeries, marketMode, priceIndicators, false, minPriceRange);
    }

    private MiniChartDataModel(Market market, MiniChartState state, MiniChartDataSeries dataSeries, MarketMode marketMode, List<PriceIndicator> priceIndicators, Boolean isEmpty, Range<Price> minPriceRange) {
        this.market = market;
        this.state = state;
        this.dataSeries = dataSeries;
        this.marketMode = marketMode;
        this.priceIndicators = priceIndicators;
        this.isEmpty = isEmpty;
        this.minPriceRange = minPriceRange;
    }

    public MiniChartDataModel addbar(MiniChartDataPoint bar) {
        if (this.isEmpty.booleanValue()) {
            throw new IllegalStateException("Cannot udpate an empty data model.");
        }
        return new MiniChartDataModel(this.market, this.state, this.dataSeries.addBar(bar), this.marketMode, this.priceIndicators, false, this.minPriceRange);
    }

    public MiniChartDataModel aggregateTrade(NDateTime time, Price price) {
        if (this.isEmpty.booleanValue()) {
            throw new IllegalStateException("Can't update any empty data model.");
        }
        return new MiniChartDataModel(this.market, this.state, this.dataSeries.aggregateTrade(time, price), this.marketMode, this.priceIndicators, false, this.minPriceRange);
    }

    public MiniChartDataModel updateMode(MarketMode mode) {
        if (this.isEmpty.booleanValue()) {
            throw new IllegalStateException("Cannot update an empty data model.");
        }
        return new MiniChartDataModel(this.market, this.state, this.dataSeries, mode, this.priceIndicators, false, this.minPriceRange);
    }

    public MiniChartDataModel updateState(MiniChartState state) {
        if (this.isEmpty.booleanValue()) {
            throw new IllegalStateException("Cannot update an empty data model.");
        }
        return new MiniChartDataModel(this.market, state, this.dataSeries, this.marketMode, this.priceIndicators, false, this.minPriceRange);
    }

    public MiniChartDataModel updatePriceIndicators(List<PriceIndicator> indicators) {
        if (this.isEmpty.booleanValue()) {
            throw new IllegalStateException("Cannot update an empty data model.");
        }
        return new MiniChartDataModel(this.market, this.state, this.dataSeries, this.marketMode, indicators, false, this.minPriceRange);
    }

    public MiniChartDataModel updateMinPriceRange(Range<Price> range) {
        if (this.isEmpty.booleanValue()) {
            throw new IllegalStateException("Can't update any empty data model.");
        }
        return new MiniChartDataModel(this.market, this.state, this.dataSeries, this.marketMode, this.priceIndicators, false, range);
    }
}

