/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.marketbyorder;

import com.t4login.collections.CollectorsUtil;
import com.t4login.collections.ImmutableLinkedList;
import com.t4login.collections.ImmutableMap;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgMarketByOrderSnapshot;
import com.t4login.messages.MsgMarketByOrderUpdate;
import java.math.BigInteger;
import java.util.Iterator;

public class MarketByOrder {
    private final NDateTime _lastUpdateTime;
    private final MarketMode _mode;
    private final ImmutableMap<BigInteger, Order> _orders;
    private final ImmutableMap<Price, PriceLevel> _bids;
    private final ImmutableMap<Price, PriceLevel> _offers;

    public MarketByOrder() {
        this._lastUpdateTime = NDateTime.MinValue;
        this._mode = MarketMode.Undefined;
        this._orders = ImmutableMap.empty();
        this._bids = ImmutableMap.empty();
        this._offers = ImmutableMap.empty();
    }

    private MarketByOrder(NDateTime lastUpdateTime, MarketMode mode, ImmutableMap<BigInteger, Order> orders, ImmutableMap<Price, PriceLevel> bids, ImmutableMap<Price, PriceLevel> offers) {
        this._lastUpdateTime = lastUpdateTime;
        this._mode = mode;
        this._orders = orders;
        this._bids = bids;
        this._offers = offers;
    }

    public MarketByOrder processSnapshot(MsgMarketByOrderSnapshot msg) {
        ImmutableMap<BigInteger, Order> orders = ImmutableMap.empty();
        ImmutableMap<Price, PriceLevel> bids = ImmutableMap.empty();
        ImmutableMap<Price, PriceLevel> offers = ImmutableMap.empty();
        for (MsgMarketByOrderSnapshot.Order snapOrder : msg.Orders) {
            PriceLevel level;
            Order order = new Order(snapOrder);
            orders = orders.add(order.getOrderID(), order);
            if (order.getBidOffer().equals(BidOffer.Bid)) {
                level = bids.get(order.getPrice());
                level = level != null ? level : new PriceLevel(order.getPrice());
                level = level.addOrder(order);
                bids = bids.add(order.getPrice(), level);
                continue;
            }
            if (!order.getBidOffer().equals(BidOffer.Offer)) continue;
            level = offers.get(order.getPrice());
            level = level != null ? level : new PriceLevel(order.getPrice());
            level = level.addOrder(order);
            offers = offers.add(order.getPrice(), level);
        }
        return new MarketByOrder(msg.Time, msg.Mode, orders, bids, offers);
    }

    public MarketByOrder processUpdate(MsgMarketByOrderUpdate msg) {
        ImmutableMap<BigInteger, Order> orders = this._orders;
        ImmutableMap<Price, PriceLevel> bids = this._bids;
        ImmutableMap<Price, PriceLevel> offers = this._offers;
        block5: for (MsgMarketByOrderUpdate.Update msgUpdate : msg.Updates) {
            switch (msgUpdate.Update) {
                case AddOrUpdate: {
                    PriceLevel level;
                    PriceLevel existingLevel;
                    Order existingOrder = orders.get(msgUpdate.OrderID);
                    if (existingOrder != null) {
                        if (existingOrder.getBidOffer().equals(BidOffer.Bid)) {
                            existingLevel = bids.get(existingOrder.getPrice());
                            if (existingLevel != null) {
                                bids = (existingLevel = existingLevel.removeOrder(existingOrder)).getOrderCount() == 0 ? bids.remove(existingOrder.getPrice()) : bids.add(existingOrder.getPrice(), existingLevel);
                            }
                        } else if (existingOrder.getBidOffer().equals(BidOffer.Offer) && (existingLevel = offers.get(existingOrder.getPrice())) != null) {
                            offers = (existingLevel = existingLevel.removeOrder(existingOrder)).getOrderCount() == 0 ? offers.remove(existingOrder.getPrice()) : offers.add(existingOrder.getPrice(), existingLevel);
                        }
                    }
                    Order order = new Order(msgUpdate);
                    orders = orders.add(order.getOrderID(), order);
                    if (order.getBidOffer().equals(BidOffer.Bid)) {
                        level = bids.get(order.getPrice());
                        level = level != null ? level : new PriceLevel(order.getPrice());
                        level = level.addOrder(order);
                        bids = bids.add(order.getPrice(), level);
                        break;
                    }
                    if (!order.getBidOffer().equals(BidOffer.Offer)) continue block5;
                    level = offers.get(order.getPrice());
                    level = level != null ? level : new PriceLevel(order.getPrice());
                    level = level.addOrder(order);
                    offers = offers.add(order.getPrice(), level);
                    break;
                }
                case Delete: {
                    PriceLevel existingLevel;
                    Order existingOrder = orders.get(msgUpdate.OrderID);
                    if (existingOrder == null) continue block5;
                    orders = orders.remove(msgUpdate.OrderID);
                    if (existingOrder.getBidOffer().equals(BidOffer.Bid)) {
                        existingLevel = bids.get(existingOrder.getPrice());
                        if (existingLevel == null) continue block5;
                        if ((existingLevel = existingLevel.removeOrder(existingOrder)).getOrderCount() == 0) {
                            bids = bids.remove(existingLevel.getPrice());
                            break;
                        }
                        bids = bids.add(existingLevel.getPrice(), existingLevel);
                        break;
                    }
                    if (!existingOrder.getBidOffer().equals(BidOffer.Offer) || (existingLevel = offers.get(existingOrder.getPrice())) == null) continue block5;
                    if ((existingLevel = existingLevel.removeOrder(existingOrder)).getOrderCount() == 0) {
                        offers = bids.remove(existingLevel.getPrice());
                        break;
                    }
                    offers = bids.add(existingLevel.getPrice(), existingLevel);
                    break;
                }
                case Clear: {
                    orders = ImmutableMap.empty();
                    bids = ImmutableMap.empty();
                    offers = ImmutableMap.empty();
                }
            }
        }
        return new MarketByOrder(msg.Time, msg.Mode, orders, bids, offers);
    }

    public NDateTime getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public MarketMode getMarketMode() {
        return this._mode;
    }

    public int getOrderCount() {
        return this._orders.count();
    }

    public ImmutableMap<Price, PriceLevel> getBids() {
        return this._bids;
    }

    public ImmutableMap<Price, PriceLevel> getOffers() {
        return this._offers;
    }

    public static class Order {
        private final MsgMarketByOrderSnapshot.Order _order;

        Order(MsgMarketByOrderSnapshot.Order order) {
            this._order = order;
        }

        Order(MsgMarketByOrderUpdate.Update update) {
            this._order = new MsgMarketByOrderSnapshot.Order();
            this._order.OrderID = update.OrderID;
            this._order.BidOffer = update.BidOffer;
            this._order.Price = update.Price;
            this._order.Volume = update.Volume;
            this._order.Priority = update.Priority;
        }

        public BigInteger getOrderID() {
            return this._order.OrderID;
        }

        public BidOffer getBidOffer() {
            return this._order.BidOffer;
        }

        public Price getPrice() {
            return this._order.Price;
        }

        public int getVolume() {
            return this._order.Volume;
        }

        public BigInteger getPriority() {
            return this._order.Priority;
        }
    }

    public static class PriceLevel
    implements Iterable<Order> {
        private final Price _price;
        private final ImmutableLinkedList<Order> _orders;
        private final int _volume;

        PriceLevel(Price price) {
            this._price = price;
            this._orders = ImmutableLinkedList.empty();
            this._volume = 0;
        }

        private PriceLevel(Price price, ImmutableLinkedList<Order> orders) {
            this._price = price;
            this._orders = orders;
            this._volume = orders.stream().mapToInt(Order::getVolume).sum();
        }

        @Override
        public Iterator<Order> iterator() {
            return this._orders.iterator();
        }

        public Price getPrice() {
            return this._price;
        }

        public int getVolume() {
            return this._volume;
        }

        public int getOrderCount() {
            return this._orders.size();
        }

        public PriceLevel addOrder(Order order) {
            ImmutableLinkedList<Order> orders = this._orders.add(order);
            return new PriceLevel(this._price, orders);
        }

        public PriceLevel removeOrder(Order order) {
            ImmutableLinkedList<Order> orders = this._orders.stream().filter(o -> !o.getOrderID().equals(order.getOrderID())).collect(CollectorsUtil.toImmutableLinkedList());
            return new PriceLevel(this._price, orders);
        }
    }
}

