/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.currencies;

import com.t4login.Log;
import com.t4login.messages.MsgAccountCurrency;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;

public class Currency {
    public static final String TAG = "Currency";
    private final MsgAccountCurrency mDetails;

    public Currency(MsgAccountCurrency msg) {
        this.mDetails = msg;
    }

    public Currency(String curr) {
        this.mDetails = new MsgAccountCurrency();
        this.mDetails.Currency = curr.toUpperCase(Locale.US);
        this.mDetails.Rate = 1.0;
        this.mDetails.ImportFactor = 1.0;
    }

    public String getCurrency() {
        return this.mDetails.Currency;
    }

    public double getRate() {
        return this.mDetails.Rate;
    }

    @Deprecated
    public double toUSD(double value) {
        if (this.mDetails.Currency.equals("USD")) {
            return value;
        }
        try {
            return value * this.mDetails.Rate;
        }
        catch (Exception ex) {
            Log.e(TAG, "toUSD(), Error converting " + this.mDetails.Currency + " " + value + " using rate " + this.mDetails.Rate, ex);
            return value;
        }
    }

    public BigDecimal toUSD(BigDecimal value) {
        if (this.mDetails.Currency.equals("USD")) {
            return value;
        }
        try {
            return value.multiply(new BigDecimal(this.mDetails.Rate));
        }
        catch (Exception ex) {
            Log.e(TAG, "toUSD(), Error converting " + this.mDetails.Currency + " " + String.valueOf(value) + " using rate " + this.mDetails.Rate, ex);
            return value;
        }
    }

    @Deprecated
    public double fromUSD(double value) {
        if (this.mDetails.Currency.equals("USD")) {
            return value;
        }
        try {
            return value / this.mDetails.Rate;
        }
        catch (Exception ex) {
            Log.e(TAG, "fromUSD(), Error converting " + this.mDetails.Currency + " " + value + " using rate " + this.mDetails.Rate, ex);
            return value;
        }
    }

    public BigDecimal fromUSD(BigDecimal value) {
        if (this.mDetails.Currency.equals("USD")) {
            return value;
        }
        try {
            return value.divide(new BigDecimal(this.mDetails.Rate), RoundingMode.HALF_EVEN);
        }
        catch (Exception ex) {
            Log.e(TAG, "fromUSD(), Error converting " + this.mDetails.Currency + " " + String.valueOf(value) + " using rate " + this.mDetails.Rate, ex);
            return value;
        }
    }
}

