/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata.request;

import com.t4login.Log;
import com.t4login.api.MarketData;
import com.t4login.api.T4HostService;
import com.t4login.api.UserData;
import com.t4login.api.chartdata.ChartDataHandler;
import com.t4login.api.chartdata.request.ChartDataRequestStatus;
import com.t4login.api.chartdata.request.IChartDataRequest;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartDataRequestApplication;
import com.t4login.definitions.ChartRequestStatus;
import com.t4login.messages.Message;
import com.t4login.messages.MsgChartAggregatedData;
import com.t4login.util.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ChartDataRequest
implements IChartDataRequest {
    private static final String TAG = "ChartDataRequest";
    private static final int MAX_RESPONSE_WAIT_TIME_MS = 30000;
    private final DataLoadArgs mArgs;
    private final Range<NDateTime> mRequestedDates;
    private final String mRequestID;
    private final String mRequestDescr;
    private NDateTime mTradeDate;
    private ChartDataRequestStatus mStatus = ChartDataRequestStatus.Pending;
    private String mFailMessage;
    private boolean mNotPermissioned = false;
    private final Lock mLock = new ReentrantLock();
    private final Condition mDataReady = this.mLock.newCondition();
    private final Map<String, ServerRequest> mPendingServerRequests = new HashMap<String, ServerRequest>();
    private final Queue<MsgChartAggregatedData> mResponseQueue = new LinkedList<MsgChartAggregatedData>();
    private List<MsgChartAggregatedData> mData = new ArrayList<MsgChartAggregatedData>();
    private NDateTime mLastHistoricalTradeTime = NDateTime.MinValue;
    private Range<NDateTime> mProcessedDates = Range.empty();

    public ChartDataRequest(DataLoadArgs args, Range<NDateTime> requestDates) {
        this.mArgs = args;
        this.mRequestedDates = requestDates;
        this.mRequestID = UUID.randomUUID().toString();
        this.mRequestDescr = String.format("%s / %s", this.mArgs, this.mRequestedDates);
    }

    @Override
    public ChartDataRequestStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public String getFailMessage() {
        return this.mFailMessage;
    }

    @Override
    public boolean getIsNotPermissioned() {
        return this.mNotPermissioned;
    }

    @Override
    public Range<NDateTime> getRequestedDates() {
        return this.mRequestedDates;
    }

    @Override
    public Range<NDateTime> getProcessedDates() {
        return this.mProcessedDates;
    }

    @Override
    public NDateTime getLastTradeTime() {
        return this.mLastHistoricalTradeTime;
    }

    public List<MsgChartAggregatedData> getChartData() {
        if (this.mStatus != ChartDataRequestStatus.Complete) {
            return null;
        }
        return this.mData;
    }

    @Override
    public synchronized void processesRequest(T4HostService service, IChartDataRequest.OnRequestCompleteHandler callback) {
        if (this.mStatus != ChartDataRequestStatus.Pending) {
            Log.e(TAG, "processesRequest(), processesRequest() called more than once. Ignoring this call.");
            return;
        }
        this.mStatus = ChartDataRequestStatus.Processing;
        Thread thread = new Thread(() -> this.doProcessRequest(service, callback));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessRequest(final T4HostService service, final IChartDataRequest.OnRequestCompleteHandler callback) {
        if (!this.mArgs.Market.isReady(new IChartMarket.OnMarketReadyHandler(){

            @Override
            public void onMarketReady(IChartMarket market) {
                Thread thread = new Thread(() -> ChartDataRequest.this.doProcessRequest(service, callback));
                thread.start();
            }
        })) {
            return;
        }
        MarketData marketData = service.getMarketData();
        UserData userData = service.getUserData();
        NDateTime now = service.getRemoteTime();
        this.mTradeDate = this.mArgs.Market.getTradeDate(now);
        if (marketData != null && userData != null) {
            ChartDataHandler chartDataHandler = new ChartDataHandler(){

                @Override
                public void onChartDataResponse(Message msg) {
                    if (msg instanceof MsgChartAggregatedData) {
                        MsgChartAggregatedData responseMsg = (MsgChartAggregatedData)msg;
                        ChartDataRequest.this.mLock.lock();
                        try {
                            if (ChartDataRequest.this.mPendingServerRequests.containsKey(responseMsg.RequestID)) {
                                ChartDataRequest.this.mResponseQueue.add(responseMsg);
                                ChartDataRequest.this.mDataReady.signal();
                            }
                        }
                        finally {
                            ChartDataRequest.this.mLock.unlock();
                        }
                    }
                }
            };
            service.getMarketData().registerForChartData(chartDataHandler);
            this.mLock.lock();
            try {
                ArrayList cacheRanges = new ArrayList();
                String requestID = marketData.requestChartData(this.mArgs, this.mRequestedDates, ChartDataRequestApplication.Chart);
                this.mPendingServerRequests.put(requestID, new ServerRequest(requestID, this.mRequestedDates));
                Log.d(TAG, "doProcessRequest(), [" + this.mRequestDescr + "], Requested data from server. Dates: " + String.valueOf(this.mRequestedDates));
                while (this.mStatus == ChartDataRequestStatus.Processing) {
                    Log.d(TAG, "doProcessRequest(), Waiting for " + this.mPendingServerRequests.size() + " pending server requests.");
                    if (!this.mDataReady.await(30000L, TimeUnit.MILLISECONDS) && this.mResponseQueue.size() == 0) {
                        this.onRequestComplete(ChartDataRequestStatus.Failed, "Timed out waiting for server response.", callback);
                        return;
                    }
                    while (this.mResponseQueue.size() > 0) {
                        MsgChartAggregatedData responseMsg = this.mResponseQueue.poll();
                        if (responseMsg == null) continue;
                        this.processResponseMessage(responseMsg, marketData, callback);
                        if (this.mStatus != ChartDataRequestStatus.Failed) continue;
                        return;
                    }
                    if (this.mPendingServerRequests.size() != 0) continue;
                    this.onRequestComplete(ChartDataRequestStatus.Complete, "", callback);
                }
            }
            catch (Exception ex) {
                Log.d(TAG, "processesRequest(), Error.", ex);
                this.onRequestComplete(ChartDataRequestStatus.Failed, "Error", callback);
            }
            finally {
                marketData.unregisterForChartData(chartDataHandler);
                this.mLock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processResponseMessage(MsgChartAggregatedData msg, MarketData marketData, IChartDataRequest.OnRequestCompleteHandler callback) {
        if (msg.Status == ChartRequestStatus.Failed) {
            this.onRequestComplete(ChartDataRequestStatus.Failed, "Server request failed: " + msg.toString(), callback);
            return;
        }
        if (msg.Status == ChartRequestStatus.NoPermission) {
            this.onRequestComplete(ChartDataRequestStatus.Failed, "Server request failed. No permission: " + msg.toString(), callback);
            this.mNotPermissioned = true;
            return;
        }
        ServerRequest serverReq = this.mPendingServerRequests.get(msg.RequestID);
        if (serverReq == null) {
            this.onRequestComplete(ChartDataRequestStatus.Failed, "Unable to locate server request object for this response. (This must be a programming error.): " + msg.toString(), callback);
            return;
        }
        if (msg.Status != ChartRequestStatus.ExceedsLimits && !serverReq.RequestDates.equals(Range.of(msg.TradeDateStart, msg.TradeDateEnd)) && serverReq.RequestDates.start().compareTo(msg.TradeDateStart) < 0) {
            Log.d(TAG, String.format("processResponseMessage(), requested: %s, received: %s, requesting the deficit from the server.", serverReq.RequestDates, Range.of(msg.TradeDateStart, msg.TradeDateEnd)));
            Range<NDateTime> reqRange = Range.of(serverReq.RequestDates.start(), msg.TradeDateStart.AddDays(-1.0));
            if (!reqRange.isNormal()) {
                this.onRequestComplete(ChartDataRequestStatus.Failed, "Invalid date range requesting additional chart data. (This must be a programming error.): " + String.valueOf(reqRange), callback);
                return;
            }
            String requestID = marketData.requestChartData(this.mArgs, reqRange, ChartDataRequestApplication.Chart);
            this.mPendingServerRequests.put(requestID, new ServerRequest(requestID, reqRange));
        } else {
            Log.d(TAG, "processResponseMessage(), [" + this.mRequestDescr + "], Chart data received: " + String.valueOf(serverReq.RequestDates));
        }
        this.mPendingServerRequests.remove(serverReq.RequestID);
        if (msg.Status == ChartRequestStatus.ExceedsLimits) {
            if (this.mPendingServerRequests.size() == 0) {
                this.onRequestComplete(ChartDataRequestStatus.Complete, "", callback);
            }
            return;
        }
        this.mProcessedDates = this.mProcessedDates.expanded(Range.of(msg.TradeDateStart, msg.TradeDateEnd));
        this.mLastHistoricalTradeTime = msg.LastTradeTime.compareTo(this.mLastHistoricalTradeTime) > 0 ? msg.LastTradeTime : this.mLastHistoricalTradeTime;
        this.mData.add(msg);
    }

    private void onRequestComplete(ChartDataRequestStatus status, String failMsg, IChartDataRequest.OnRequestCompleteHandler callback) {
        this.mFailMessage = failMsg;
        this.mStatus = status;
        this.mPendingServerRequests.clear();
        if (this.mStatus == ChartDataRequestStatus.Failed) {
            Log.e(TAG, "processesRequest(), [" + this.mRequestDescr + "], Request failed: " + this.mFailMessage);
        }
        try {
            callback.onRequestComplete(this);
        }
        catch (Exception ex) {
            Log.e(TAG, "onRequestComplete(), OnRequestCompleteHandler callback raised an unhandled exception.", ex);
        }
    }

    public static class ServerRequest {
        public final String RequestID;
        public final Range<NDateTime> RequestDates;

        public ServerRequest(String id, Range<NDateTime> rng) {
            this.RequestID = id;
            this.RequestDates = rng;
        }
    }
}

