/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata.request;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.T4HostService;
import com.t4login.api.UserData;
import com.t4login.api.chartdata.ChartDataHandler;
import com.t4login.api.chartdata.request.ChartDataRequestStatus;
import com.t4login.api.chartdata.request.IChartDataCacheManager;
import com.t4login.api.chartdata.request.IChartDataRequest;
import com.t4login.api.chartdata.request.MarketMapping;
import com.t4login.application.ContextSettings;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.chart.markets.ExpiryMarket;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.application.chart.markets.VolumeContinuationMarket;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartDataRequestApplication;
import com.t4login.definitions.ChartRequestStatus;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.messages.Message;
import com.t4login.messages.MsgChartDataBatch;
import com.t4login.util.Range;
import com.t4login.util.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ChartDataBatchRequest
implements IChartDataRequest {
    private static final String TAG = "ChartDataBatchRequest";
    private static final int MAX_RESPONSE_WAIT_TIME_MS = 30000;
    private final IChartMarket mMarket;
    private final ChartDataType mDataType;
    private final Range<NDateTime> mRequestedDates;
    private final SessionTimeRange mSession;
    private final String mRequestID;
    private final String mRequestDescr;
    private NDateTime mTradeDate;
    private ChartDataRequestStatus mStatus = ChartDataRequestStatus.Pending;
    private String mFailMessage;
    private boolean mNotPermissioned = false;
    private final Lock mLock = new ReentrantLock();
    private final Condition mDataReady = this.mLock.newCondition();
    private final Map<String, ServerRequest> mPendingServerRequests = new HashMap<String, ServerRequest>();
    private final Queue<MsgChartDataBatch> mResponseQueue = new LinkedList<MsgChartDataBatch>();
    private TreeMap<NDateTime, MsgChartDataBatch.MarketData> mData = new TreeMap();
    private NDateTime mLastHistoricalTradeTime = NDateTime.MinValue;
    private Range<NDateTime> mProcessedDates = Range.empty();

    public ChartDataBatchRequest(IChartMarket market, ChartDataType dataType, Range<NDateTime> requestDates, SessionTimeRange session) {
        this.mMarket = market;
        this.mDataType = dataType;
        this.mRequestedDates = requestDates;
        this.mSession = session;
        this.mRequestID = UUID.randomUUID().toString();
        this.mRequestDescr = this.mSession.isEmpty() ? String.format("%s / %s / %s", this.mMarket.getMarketID(), this.mDataType, this.mRequestedDates) : String.format("%s / %s / %s (%s)", this.mMarket.getMarketID(), this.mDataType, this.mRequestedDates, this.mSession);
    }

    public ChartDataBatchRequest(Contract contract, ChartDataType dataType, Range<NDateTime> requestDates, SessionTimeRange session) {
        this(new VolumeContinuationMarket(contract), dataType, requestDates, session);
    }

    public ChartDataBatchRequest(Market market, ChartDataType dataType, Range<NDateTime> requestDates, SessionTimeRange session) {
        this(new ExpiryMarket(market), dataType, requestDates, session);
    }

    @Override
    public ChartDataRequestStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public String getFailMessage() {
        return this.mFailMessage;
    }

    @Override
    public boolean getIsNotPermissioned() {
        return this.mNotPermissioned;
    }

    @Override
    public Range<NDateTime> getRequestedDates() {
        return this.mRequestedDates;
    }

    @Override
    public Range<NDateTime> getProcessedDates() {
        return this.mProcessedDates;
    }

    @Override
    public NDateTime getLastTradeTime() {
        return this.mLastHistoricalTradeTime;
    }

    public Collection<MsgChartDataBatch.MarketData> getChartData() {
        if (this.mStatus != ChartDataRequestStatus.Complete) {
            return null;
        }
        return this.mData.values();
    }

    @Override
    public synchronized void processesRequest(final T4HostService service, final IChartDataRequest.OnRequestCompleteHandler callback) {
        if (this.mStatus != ChartDataRequestStatus.Pending) {
            Log.e(TAG, "processesRequest(), processesRequest() called more than once. Ignoring this call.");
            return;
        }
        this.mStatus = ChartDataRequestStatus.Processing;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ChartDataBatchRequest.this.doProcessRequest(service, callback);
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessRequest(final T4HostService service, final IChartDataRequest.OnRequestCompleteHandler callback) {
        if (!this.mMarket.isReady(new IChartMarket.OnMarketReadyHandler(){

            @Override
            public void onMarketReady(IChartMarket market) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ChartDataBatchRequest.this.doProcessRequest(service, callback);
                    }
                });
                thread.start();
            }
        })) {
            return;
        }
        MarketData marketData = service.getMarketData();
        UserData userData = service.getUserData();
        NDateTime now = service.getRemoteTime();
        this.mTradeDate = this.mMarket.getTradeDate(now);
        if (service != null && marketData != null && userData != null) {
            List<MarketMapping> marketMappings = this.mMarket.createChartDataMarketMapping(this.mRequestedDates);
            boolean cacheEnabled = ContextSettings.persistent.getBoolean("chart_data_cache_enabled", true);
            IChartDataCacheManager chartDataCache = null;
            if (cacheEnabled) {
                chartDataCache = Host.createChartDataCacheManager(userData.getServerType());
            }
            ChartDataHandler chartDataHandler = new ChartDataHandler(){

                @Override
                public void onChartDataResponse(Message msg) {
                    if (msg instanceof MsgChartDataBatch) {
                        MsgChartDataBatch responseMsg = (MsgChartDataBatch)msg;
                        ChartDataBatchRequest.this.mLock.lock();
                        try {
                            if (ChartDataBatchRequest.this.mPendingServerRequests.containsKey(responseMsg.RequestID)) {
                                ChartDataBatchRequest.this.mResponseQueue.add(responseMsg);
                                ChartDataBatchRequest.this.mDataReady.signal();
                            }
                        }
                        finally {
                            ChartDataBatchRequest.this.mLock.unlock();
                        }
                    }
                }
            };
            service.getMarketData().registerForChartData(chartDataHandler);
            this.mLock.lock();
            try {
                ArrayList<Range<NDateTime>> cacheRanges = new ArrayList<Range<NDateTime>>();
                for (MarketMapping marketMapping : marketMappings) {
                    if (chartDataCache != null) {
                        chartDataCache.getBatchDataRanges(marketMapping.ExchangeID, marketMapping.ContractID, marketMapping.MarketID, this.mDataType, this.mSession, this.mRequestedDates, cacheRanges);
                    }
                    List<Range<NDateTime>> requestRanges = this.computeServerRequestDateRanges(cacheRanges, marketMapping.ActiveDates, this.mRequestedDates);
                    for (Range<NDateTime> reqRange : requestRanges) {
                        String batchReqID = marketData.requestChartDataBatch(marketMapping.ExchangeID, marketMapping.ContractID, marketMapping.MarketID, this.mDataType, reqRange, this.mSession, ChartDataRequestApplication.Chart);
                        this.mPendingServerRequests.put(batchReqID, new ServerRequest(batchReqID, reqRange));
                        Log.d(TAG, "doProcessRequest(), [" + this.mRequestDescr + "], Requested data from server. Dates: " + String.valueOf(reqRange));
                    }
                }
                if (chartDataCache != null) {
                    for (MarketMapping marketMapping : marketMappings) {
                        Log.d(TAG, String.format("doProcessRequest(), Retrieving from cache, E: %s, C: %s, M: [%s], Dt: %s, Dates: %s", marketMapping.ExchangeID, marketMapping.ContractID, marketMapping.MarketID, this.mDataType, this.mRequestedDates));
                        List<MsgChartDataBatch.MarketData> cacheData = chartDataCache.retrieveBatchData(marketMapping.ExchangeID, marketMapping.ContractID, marketMapping.MarketID, this.mDataType, this.mRequestedDates, this.mSession);
                        for (MsgChartDataBatch.MarketData mktData : cacheData) {
                            MsgChartDataBatch.MarketData existingData = this.mData.get(mktData.TradeDate);
                            if (existingData != null) {
                                if (existingData.TTV < mktData.TTV) {
                                    this.mData.put(mktData.TradeDate, mktData);
                                }
                            } else {
                                this.mData.put(mktData.TradeDate, mktData);
                            }
                            Log.d(TAG, String.format("doProcessRequest(), [%s], Chart data loaded from local cache, MarketID: [%s], TradeDate: %s, DataType: %s", this.mRequestDescr, mktData.MarketID, mktData.TradeDate, this.mDataType));
                        }
                    }
                    for (Range range : cacheRanges) {
                        this.mProcessedDates = this.mProcessedDates.expanded(TimeRange.intersection(this.mRequestedDates, range));
                    }
                }
                if (this.mPendingServerRequests.size() == 0) {
                    Log.d(TAG, "doProcessRequest(), 0 pending server requests. Request complete.");
                    this.mStatus = ChartDataRequestStatus.Complete;
                    this.onRequestComplete(ChartDataRequestStatus.Complete, "", callback);
                    return;
                }
                Log.d(TAG, "doProcessRequest(), " + this.mPendingServerRequests.size() + " pending server requests.");
                while (this.mStatus == ChartDataRequestStatus.Processing) {
                    Log.d(TAG, "doProcessRequest(), Waiting for " + this.mPendingServerRequests.size() + " pending server requests.");
                    if (!this.mDataReady.await(30000L, TimeUnit.MILLISECONDS) && this.mResponseQueue.size() == 0) {
                        this.onRequestComplete(ChartDataRequestStatus.Failed, "Timed out waiting for server response.", callback);
                        return;
                    }
                    while (this.mResponseQueue.size() > 0) {
                        MsgChartDataBatch responseMsg = this.mResponseQueue.poll();
                        if (responseMsg == null) continue;
                        this.processResponseMessage(responseMsg, marketData, chartDataCache, callback);
                        if (this.mStatus != ChartDataRequestStatus.Failed) continue;
                        return;
                    }
                    if (this.mPendingServerRequests.size() != 0) continue;
                    this.onRequestComplete(ChartDataRequestStatus.Complete, "", callback);
                }
            }
            catch (Exception ex) {
                Log.d(TAG, "processesRequest(), Error.", ex);
                this.onRequestComplete(ChartDataRequestStatus.Failed, "Error", callback);
            }
            finally {
                marketData.unregisterForChartData(chartDataHandler);
                this.mLock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processResponseMessage(MsgChartDataBatch msg, MarketData marketData, IChartDataCacheManager chartDataCache, IChartDataRequest.OnRequestCompleteHandler callback) {
        if (msg.Status == ChartRequestStatus.Failed) {
            this.onRequestComplete(ChartDataRequestStatus.Failed, "Server request failed: " + msg.toString(), callback);
            return;
        }
        if (msg.Status == ChartRequestStatus.NoPermission) {
            this.onRequestComplete(ChartDataRequestStatus.Failed, "Server request failed. No permission: " + msg.toString(), callback);
            this.mNotPermissioned = true;
            return;
        }
        ServerRequest serverReq = this.mPendingServerRequests.get(msg.RequestID);
        if (serverReq == null) {
            this.onRequestComplete(ChartDataRequestStatus.Failed, "Unable to locate server request object for this response. (This must be a programming error.): " + msg.toString(), callback);
            return;
        }
        if (msg.Status != ChartRequestStatus.ExceedsLimits && !serverReq.RequestDates.equals(Range.of(msg.TradeDateStart, msg.TradeDateEnd)) && serverReq.RequestDates.start().compareTo(msg.TradeDateStart) < 0) {
            Log.d(TAG, String.format("processResponseMessage(), requested: %s, received: %s, requesting the deficit from the server.", serverReq.RequestDates, Range.of(msg.TradeDateStart, msg.TradeDateEnd)));
            Range<NDateTime> reqRange = Range.of(serverReq.RequestDates.start(), msg.TradeDateStart.AddDays(-1.0));
            if (!reqRange.isNormal()) {
                this.onRequestComplete(ChartDataRequestStatus.Failed, "Invalid date range requesting additional chart data. (This must be a programming error.): " + String.valueOf(reqRange), callback);
                return;
            }
            String batchReqID = marketData.requestChartDataBatch(msg.ExchangeID, msg.ContractID, msg.MarketID, msg.DataType, reqRange, this.mSession, ChartDataRequestApplication.Chart);
            this.mPendingServerRequests.put(batchReqID, new ServerRequest(batchReqID, reqRange));
        } else {
            Log.d(TAG, "processResponseMessage(), [" + this.mRequestDescr + "], Chart data received: " + String.valueOf(serverReq.RequestDates) + ", NoCache: " + msg.NoCache);
        }
        this.mPendingServerRequests.remove(serverReq.RequestID);
        if (msg.Status == ChartRequestStatus.ExceedsLimits) {
            if (this.mPendingServerRequests.size() == 0) {
                this.onRequestComplete(ChartDataRequestStatus.Complete, "", callback);
            }
            return;
        }
        this.mProcessedDates = this.mProcessedDates.expanded(Range.of(msg.TradeDateStart, msg.TradeDateEnd));
        NDateTime nDateTime = this.mLastHistoricalTradeTime = msg.LastTradeTime.compareTo(this.mLastHistoricalTradeTime) > 0 ? msg.LastTradeTime : this.mLastHistoricalTradeTime;
        if (!msg.NoCache && chartDataCache != null) {
            Range<NDateTime> cacheDateRange = Range.empty();
            ArrayList<MsgChartDataBatch.MarketData> cacheData = new ArrayList<MsgChartDataBatch.MarketData>();
            for (MsgChartDataBatch.MarketData md : msg.BatchData) {
                if (this.mTradeDate.compareTo(md.TradeDate) <= 0) continue;
                cacheData.add(md);
                cacheDateRange = cacheDateRange.expanded(md.TradeDate);
            }
            if (!cacheDateRange.isEmpty() && msg.TradeDateStart.compareTo((NDateTime)cacheDateRange.start()) < 0) {
                cacheDateRange = cacheDateRange.expanded(msg.TradeDateStart);
            }
            if (!cacheDateRange.isEmpty() && cacheData.size() > 0) {
                chartDataCache.cacheChartBatchData(msg.ExchangeID, msg.ContractID, msg.MarketID, msg.DataType, this.mSession, cacheDateRange, cacheData, msg.CacheGenerationDate);
            }
        }
        Iterator<MsgChartDataBatch.MarketData> iterator = msg.BatchData.iterator();
        while (iterator.hasNext()) {
            MsgChartDataBatch.MarketData md = iterator.next();
            MsgChartDataBatch.MarketData existingData = this.mData.get(md.TradeDate);
            if (existingData != null && existingData.TTV < md.TTV) {
                this.mData.put(md.TradeDate, md);
                continue;
            }
            this.mData.put(md.TradeDate, md);
        }
        return;
    }

    private List<Range<NDateTime>> computeServerRequestDateRanges(List<Range<NDateTime>> cacheRanges, Range<NDateTime> relationActiveDates, Range<NDateTime> requestDates) {
        ArrayList<Range<NDateTime>> serverRanges = new ArrayList<Range<NDateTime>>();
        if ((requestDates = requestDates.condensed(relationActiveDates)).isEmpty()) {
            return serverRanges;
        }
        serverRanges.add(requestDates);
        for (Range<NDateTime> cacheRange : cacheRanges) {
            ArrayList<Range<NDateTime>> tmpRanges = new ArrayList<Range<NDateTime>>();
            for (Range range : serverRanges) {
                tmpRanges.addAll(TimeRange.remove(range, cacheRange));
            }
            serverRanges = tmpRanges;
        }
        return serverRanges;
    }

    private void onRequestComplete(ChartDataRequestStatus status, String failMsg, IChartDataRequest.OnRequestCompleteHandler callback) {
        this.mFailMessage = failMsg;
        this.mStatus = status;
        this.mPendingServerRequests.clear();
        if (this.mStatus == ChartDataRequestStatus.Failed) {
            Log.e(TAG, "processesRequest(), [" + this.mRequestDescr + "], Request failed: " + this.mFailMessage);
        }
        try {
            callback.onRequestComplete(this);
        }
        catch (Exception ex) {
            Log.e(TAG, "onRequestComplete(), OnRequestCompleteHandler callback raised an unhandled exception.", ex);
        }
    }

    public static class ServerRequest {
        public final String RequestID;
        public final Range<NDateTime> RequestDates;

        public ServerRequest(String id, Range<NDateTime> rng) {
            this.RequestID = id;
            this.RequestDates = rng;
        }
    }
}

