/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata.request;

import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.Market;
import com.t4login.api.MarketPickerGroup;
import com.t4login.api.MarketPickerListHandler;
import com.t4login.api.MarketPickerMarket;
import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.ChartDataHandler;
import com.t4login.api.chartdata.request.ChartDataRequestStatus;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartRequestStatus;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.StrategyType;
import com.t4login.messages.Message;
import com.t4login.messages.MsgChartContractData;
import com.t4login.messages.MsgChartContractDataRequest;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ActiveMarketRequest {
    private static final String TAG = "ActiveMarketRequest";
    private static final int MAX_RESPONSE_WAIT_TIME_MS = 30000;
    private static final int MAX_DAYS_BACK = 15;
    private final Contract mContract;
    private final String mRequestDescr;
    private NDateTime mTradeDate;
    private ChartDataRequestStatus mStatus = ChartDataRequestStatus.Pending;
    private String mFailMessage;
    private String mPendingRequestID = "";
    private MsgChartContractData mContractData = null;
    private String mActiveMarketID = "";
    private Market mActiveMarket = null;
    private int mActiveMarketTTV = 0;
    private CountDownLatch marketsLatch = null;
    private CountDownLatch serverRequestLatch = null;

    public ActiveMarketRequest(Contract contract) {
        this.mContract = contract;
        String mRequestID = UUID.randomUUID().toString();
        this.mRequestDescr = String.format("%s.%s / %s", contract.getExchangeID(), contract.getContractID(), mRequestID);
    }

    public ChartDataRequestStatus getStatus() {
        return this.mStatus;
    }

    public Market getActiveMarket() {
        return this.mActiveMarket;
    }

    public String getActiveMarketID() {
        return this.mActiveMarketID;
    }

    public synchronized void processesRequest(final T4HostService service, final OnRequestCompleteHandler callback) {
        if (this.mStatus != ChartDataRequestStatus.Pending) {
            Log.e(TAG, "processesRequest(), processesRequest() called more than once. Ignoring this call.");
            return;
        }
        this.mStatus = ChartDataRequestStatus.Processing;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ActiveMarketRequest.this.doProcessRequest(service, callback);
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessRequest(T4HostService service, OnRequestCompleteHandler callback) {
        Log.d(TAG, "doProcessRequest(), [" + this.mRequestDescr + "], Begin Processing.");
        this.marketsLatch = new CountDownLatch(1);
        this.serverRequestLatch = new CountDownLatch(1);
        if (service != null && service.getMarketData() != null) {
            final HashSet eligibleMarkets = new HashSet();
            ChartDataHandler chartDataHandler = new ChartDataHandler(){

                @Override
                public void onChartDataResponse(Message msg) {
                    if (msg instanceof MsgChartContractData && ((MsgChartContractData)msg).getRequestID().equals(ActiveMarketRequest.this.mPendingRequestID)) {
                        ActiveMarketRequest.this.mContractData = (MsgChartContractData)msg;
                        if (ActiveMarketRequest.this.serverRequestLatch != null) {
                            ActiveMarketRequest.this.serverRequestLatch.countDown();
                        }
                    }
                }
            };
            service.getMarketData().registerForChartData(chartDataHandler);
            try {
                MsgChartContractDataRequest msg;
                block27: {
                    service.getMarketData().requestMarketPickerList(this.mContract.getExchangeID(), this.mContract.getContractID(), new MarketPickerGroup(StrategyType.None, 0, 0), new MarketPickerListHandler(){

                        @Override
                        public void onMarketGroupsComplete(String exchangeid, String contractid, List<MarketPickerGroup> groups) {
                        }

                        @Override
                        public void onMarketPickerListComplete(String exchangeid, String contractid, MarketPickerGroup group, List<MarketPickerMarket> markets) {
                            for (MarketPickerMarket m : markets) {
                                eligibleMarkets.add(m.MarketID);
                            }
                            ActiveMarketRequest.this.marketsLatch.countDown();
                        }
                    });
                    NDateTime now = service.getRemoteTime();
                    this.mTradeDate = this.mContract.getTradeDate(now);
                    Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Contract trade date is: " + String.valueOf(this.mTradeDate));
                    msg = new MsgChartContractDataRequest();
                    this.mPendingRequestID = msg.RequestID = UUID.randomUUID().toString();
                    msg.ExchangeID = this.mContract.getExchangeID();
                    msg.ContractID = this.mContract.getContractID();
                    msg.TradeDate = this.mTradeDate.getDate();
                    service.sendChartDataRequest(msg);
                    try {
                        this.marketsLatch.await();
                        Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Market load complete, count: " + eligibleMarkets.size());
                        if (eligibleMarkets.size() != 0) break block27;
                        this.onRequestComplete(ChartDataRequestStatus.Failed, "No markets for contract.", callback);
                        return;
                    }
                    catch (InterruptedException e) {
                        this.onRequestComplete(ChartDataRequestStatus.Failed, "Interrupted", callback);
                        return;
                    }
                }
                if (!this.serverRequestLatch.await(30000L, TimeUnit.MILLISECONDS)) {
                    this.onRequestComplete(ChartDataRequestStatus.Failed, "Timed out waiting for server response.", callback);
                    return;
                }
                Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Server response recieved: status: " + String.valueOf(this.mContractData.Status) + ", markets: " + this.mContractData.Markets.size());
                if (this.mContractData.Status == ChartRequestStatus.Success) {
                    for (MsgChartContractData.MarketData md : this.mContractData.Markets) {
                        if (md.TTV <= 0 || this.mActiveMarketTTV != 0 && md.TTV <= this.mActiveMarketTTV || !eligibleMarkets.contains(md.MarketID)) continue;
                        this.mActiveMarketID = md.MarketID;
                        this.mActiveMarketTTV = md.TTV;
                    }
                }
                for (int daysBack = 0; this.mActiveMarketTTV == 0 && daysBack < 15; ++daysBack) {
                    NDateTime reqTradeDate = msg.TradeDate.AddDays(-1.0);
                    while (this.mContract.getTradeDate(reqTradeDate).compareTo(this.mTradeDate) >= 0) {
                        reqTradeDate = reqTradeDate.AddDays(-1.0);
                    }
                    Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Active market not determined. Trying trade date: " + String.valueOf(reqTradeDate) + ", days back: " + daysBack);
                    this.mPendingRequestID = msg.RequestID = UUID.randomUUID().toString();
                    msg.TradeDate = reqTradeDate.getDate();
                    this.serverRequestLatch = new CountDownLatch(1);
                    service.sendChartDataRequest(msg);
                    if (!this.serverRequestLatch.await(30000L, TimeUnit.MILLISECONDS)) {
                        this.onRequestComplete(ChartDataRequestStatus.Failed, "Timed out waiting for server response.", callback);
                        return;
                    }
                    if (this.mContractData.Status != ChartRequestStatus.Success) {
                        this.onRequestComplete(ChartDataRequestStatus.Failed, "Server request failed: " + String.valueOf(this.mContractData.Status), callback);
                        return;
                    }
                    for (MsgChartContractData.MarketData md : this.mContractData.Markets) {
                        if (md.TTV <= 0 || this.mActiveMarketTTV != 0 && md.TTV <= this.mActiveMarketTTV || !eligibleMarkets.contains(md.MarketID)) continue;
                        this.mActiveMarketID = md.MarketID;
                        this.mActiveMarketTTV = md.TTV;
                    }
                }
                if (this.mActiveMarketTTV == 0) {
                    this.mActiveMarket = service.getMarketData().getFirstMarket(this.mContract.getExchangeID(), this.mContract.getContractID(), ContractType.Future, StrategyType.None);
                    if (this.mActiveMarket != null) {
                        Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Active market not determined. Using first expiry: " + this.mActiveMarket.getMarketID());
                    } else {
                        Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Active market not determined. Unable to determine first expiry to use as default.");
                    }
                } else {
                    this.mActiveMarket = service.getMarketData().getMarket(this.mContract.getExchangeID(), this.mContract.getContractID(), this.mActiveMarketID, true);
                    Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Active market determined: " + this.mActiveMarketID);
                }
                if (this.mActiveMarket != null) {
                    this.onRequestComplete(ChartDataRequestStatus.Complete, "", callback);
                    return;
                }
                this.onRequestComplete(ChartDataRequestStatus.Failed, "Unknown", callback);
                return;
            }
            catch (Exception ex) {
                Log.d(TAG, "processesRequest(), Error.", ex);
                this.onRequestComplete(ChartDataRequestStatus.Failed, "Error", callback);
            }
            finally {
                service.getMarketData().unregisterForChartData(chartDataHandler);
            }
        }
        this.onRequestComplete(ChartDataRequestStatus.Failed, "Service shut down.", callback);
        return;
    }

    private void onRequestComplete(ChartDataRequestStatus status, String failMsg, OnRequestCompleteHandler callback) {
        this.mFailMessage = failMsg;
        this.mStatus = status;
        this.mPendingRequestID = "";
        if (this.mStatus == ChartDataRequestStatus.Failed) {
            Log.e(TAG, "processesRequest(), [" + this.mRequestDescr + "], Request failed: " + this.mFailMessage);
        } else {
            Log.d(TAG, "processesRequest(), [" + this.mRequestDescr + "], Request completed. Active market: " + this.mActiveMarket.getMarketID());
        }
        try {
            callback.onRequestComplete(this);
        }
        catch (Exception ex) {
            Log.e(TAG, "onRequestComplete(), OnRequestCompleteHandler callback raised an unhandled exception.", ex);
        }
    }

    public static interface OnRequestCompleteHandler {
        public void onRequestComplete(ActiveMarketRequest var1);
    }
}

