/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata;

import com.t4login.application.chart.ChartInterval;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.MarketModeDataPoint;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.chartdata.TickDataPoint;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.messages.MsgChartAggregatedData;
import com.t4login.messages.MsgChartDataBatch;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class SubscriptionServerData {
    private final DataLoadArgs mArgs;
    private final TreeMap<NDateTime, MsgChartDataBatch.MarketData> mHistoricalData;
    private final TreeMap<NDateTime, MsgChartAggregatedData> mHistoricalDataAggr;
    private NDateTime mLastTradeDate = NDateTime.MaxValue;
    private final DataLoadArgs mLiveArgs;
    private BarDataSeries mAggregatedLiveUpdates;
    private NDateTime mLastHistoricalTradeTime = NDateTime.MinValue;

    public SubscriptionServerData(DataLoadArgs args) {
        this.mArgs = args;
        this.mHistoricalData = new TreeMap();
        this.mHistoricalDataAggr = new TreeMap();
        this.mLiveArgs = args;
        this.mAggregatedLiveUpdates = new BarDataSeries(this.mLiveArgs);
    }

    public void clear() {
        this.mHistoricalData.clear();
        this.mHistoricalDataAggr.clear();
        this.mLastTradeDate = NDateTime.MaxValue;
        this.mAggregatedLiveUpdates = new BarDataSeries(this.mLiveArgs);
        this.mLastHistoricalTradeTime = NDateTime.MinValue;
    }

    public void setLastHistoricalTradeTime(NDateTime time) {
        if (time.compareTo(this.mLastHistoricalTradeTime) > 0) {
            this.mLastHistoricalTradeTime = time;
        }
    }

    public BarDataSeries getLiveDataSeries() {
        return this.mAggregatedLiveUpdates;
    }

    public List<MsgChartDataBatch.MarketData> getHistoricalData() {
        ArrayList<MsgChartDataBatch.MarketData> data = new ArrayList<MsgChartDataBatch.MarketData>(this.mHistoricalData.values());
        return data;
    }

    public List<MsgChartAggregatedData> getHistoricalDataAggr() {
        ArrayList<MsgChartAggregatedData> data = new ArrayList<MsgChartAggregatedData>(this.mHistoricalDataAggr.values());
        return data;
    }

    public NDateTime getLastTradeDate() {
        return this.mLastTradeDate;
    }

    public void addHistoricalData(MsgChartDataBatch.MarketData data) {
        this.mHistoricalData.put(data.TradeDate.getDate(), data);
        if (data.TradeDate.getDate().isBefore(this.mLastTradeDate)) {
            this.mLastTradeDate = data.TradeDate.getDate();
        }
    }

    public void addHistoricalDataAggr(MsgChartAggregatedData data) {
        this.mHistoricalDataAggr.put(data.TradeDateStart.getDate(), data);
        if (data.TradeDateStart.getDate().isBefore(this.mLastTradeDate)) {
            this.mLastTradeDate = data.TradeDateStart.getDate();
        }
    }

    public void addLiveTrade(TickDataPoint tick) {
        if (tick.getTime().compareTo(this.mLastHistoricalTradeTime) >= 0) {
            this.mAggregatedLiveUpdates.addLiveTrade(tick);
        }
    }

    public void addLiveMode(MarketModeDataPoint mode) {
        this.mAggregatedLiveUpdates.addModeChange(mode);
    }

    public void addLiveSettlement(SettlementDataPoint settl) {
        this.mAggregatedLiveUpdates.addSettlement(settl);
    }

    private static ChartInterval getChartIntervalForDataType(ChartDataType dataType) {
        if (dataType == ChartDataType.Tick) {
            return ChartInterval.Tick;
        }
        if (dataType == ChartDataType.Second) {
            return ChartInterval.Second;
        }
        if (dataType == ChartDataType.Minute) {
            return ChartInterval.Minute;
        }
        if (dataType == ChartDataType.Hour) {
            return ChartInterval.Hour;
        }
        if (dataType == ChartDataType.Day) {
            return ChartInterval.Day;
        }
        return ChartInterval.Tick;
    }
}

