/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.api.MarketDataHandler;
import com.t4login.api.SubscriptionLevel;
import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.ChartDataReader;
import com.t4login.api.chartdata.DataSeriesSubscription;
import com.t4login.api.chartdata.SubscriptionServerData;
import com.t4login.api.chartdata.request.ChartDataBatchRequest;
import com.t4login.api.chartdata.request.ChartDataRequest;
import com.t4login.api.chartdata.request.ChartDataRequestStatus;
import com.t4login.api.chartdata.request.IChartDataRequest;
import com.t4login.application.chart.chartdata.BarDataPoint;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.FlushResult;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.MarketModeDataPoint;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.chartdata.TickDataPoint;
import com.t4login.application.chart.chartdata.aggregators.Aggregator;
import com.t4login.application.chart.chartdata.aggregators.IAggregator;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.chartdata.ChartDataChange;
import com.t4login.definitions.chartdata.ChartDataState;
import com.t4login.definitions.chartdata.ChartDataStreamReaderAggr;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.definitions.chartdata.ChartFormatAggr;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MsgChartAggregatedData;
import com.t4login.messages.MsgChartDataBatch;
import com.t4login.messages.MsgMarketDepthD;
import com.t4login.messages.MsgMarketDepthTradeD;
import com.t4login.messages.MsgMarketSettlementD;
import com.t4login.util.DoubleRange;
import com.t4login.util.Range;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ChartDataSubscription {
    private static final String TAG = "ChartDataSubscription";
    private static final long MAX_INACTIVE_SUBSCRIPTION_SECONDS = 60L;
    private static final int STALL_DAYS = 20;
    private final T4HostService mService;
    private final DataLoadArgs mArgs;
    private final SubscriptionHandler mHandler;
    private final SubscriptionServerData mServerData;
    private final ConcurrentMap<DataLoadArgs, BarDataSeries> mGeneratedSeries = new ConcurrentHashMap<DataLoadArgs, BarDataSeries>(50, 0.9f, 1);
    private String mSubscribedMarketID = "";
    private NDateTime mLastRequestedTradeDate = NDateTime.MaxValue;
    private NDateTime mLastTradeDateLoaded = NDateTime.MaxValue;
    private NDateTime mLastTradeDateFlushed = NDateTime.MaxValue;
    private IChartDataRequest mPendingRequest = null;
    private boolean mIsStalled = false;
    private boolean mNoPermission = false;
    private volatile boolean mNeedsFlush = false;
    private final Lock mLock = new ReentrantLock();
    private volatile boolean mShutdown = false;
    private Thread mLoaderThread;
    private List<TickDataPoint> mTradeQueue = new ArrayList<TickDataPoint>();
    private List<MarketModeDataPoint> mModeQueue = new ArrayList<MarketModeDataPoint>();
    private List<SettlementDataPoint> mSettlementQueue = new ArrayList<SettlementDataPoint>();
    private MarketMode mLastMarketMode = MarketMode.Expired;
    private static final int GUIPriority = 0;
    private static final int BufferPriority = 1;
    private final Lock mQueueSyncLock = new ReentrantLock();
    IChartDataRequest.OnRequestCompleteHandler mChartDataCompleteHandler = new IChartDataRequest.OnRequestCompleteHandler(){

        @Override
        public void onRequestComplete(IChartDataRequest request) {
            ChartDataSubscription.this.onChartDataComplete(request);
        }
    };
    private MarketMode mLastDepthMode = MarketMode.Expired;
    private MarketDataHandler mMarketDataHandler = new MarketDataHandler(){

        @Override
        public String getDescription() {
            return ChartDataSubscription.TAG;
        }

        @Override
        public void onCheckSubscriptions(Map<String, SubscriptionLevel> subscriptions) {
            SubscriptionLevel sublevel;
            if (!ChartDataSubscription.this.mShutdown && (sublevel = subscriptions.get(ChartDataSubscription.this.mSubscribedMarketID)) != null) {
                sublevel.update(DepthBuffer.SlowTrade, DepthLevels.BestOnly, false);
            }
        }
    };

    public ChartDataSubscription(T4HostService service, DataLoadArgs args, SubscriptionHandler handler) {
        this.mService = service;
        this.mArgs = args;
        this.mHandler = handler;
        this.mServerData = new SubscriptionServerData(this.mArgs);
        this.mLastTradeDateLoaded = this.mArgs.Market.getTradeDate(NDateTime.now()).AddDays(1.0);
        if (this.mArgs.Market.isReady(new IChartMarket.OnMarketReadyHandler(){

            @Override
            public void onMarketReady(IChartMarket market) {
                ChartDataSubscription.this.onMarketReady();
            }
        })) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ChartDataSubscription.this.onMarketReady();
                }
            });
            t.start();
        }
    }

    public void shutdown() {
        if (!this.mShutdown) {
            this.mShutdown = true;
            this.mSubscribedMarketID = "";
            this.mService.getMarketData().unregisterForMarketData(this.mMarketDataHandler);
            this.mService.getMarketData().subscribeForMarketDepth(this.mArgs.Market.getAPIMarket(), DepthBuffer.NoSubscription, DepthLevels.Undefined, false);
            this.mGeneratedSeries.clear();
            Log.d(TAG, "shutdown(), [" + String.valueOf(this.mArgs) + "], Subscription shut down.");
        }
    }

    public NDateTime getLastRequestedTradeDate() {
        return this.mLastRequestedTradeDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateDataSeriesSubscriptions(List<DataSeriesSubscription> subs) {
        this.mLock.lock();
        try {
            for (DataSeriesSubscription sub : subs) {
                NTimeSpan timeSinceSubscribed;
                if (!this.mGeneratedSeries.containsKey(sub.Args) || !((timeSinceSubscribed = NDateTime.now().Subtract(sub.getLastMarkedTime())).getTotalSeconds() > 60.0)) continue;
                Log.d(TAG, "updateDataSeriesSubscriptions(), Removing Subscription: " + String.valueOf(sub.Args) + ", Time Since Used: " + timeSinceSubscribed.getTotalSeconds() + " seconds.");
                this.mGeneratedSeries.remove(sub.Args);
            }
            if (this.mGeneratedSeries.size() == 0 && !this.mSubscribedMarketID.isEmpty()) {
                this.mSubscribedMarketID = "";
                this.mService.getMarketData().unregisterForMarketData(this.mMarketDataHandler);
                this.mService.getMarketData().subscribeForMarketDepth(this.mArgs.Market.getAPIMarket(), DepthBuffer.NoSubscription, DepthLevels.Undefined, false);
                this.mServerData.clear();
            }
            int n = this.mGeneratedSeries.size();
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.mGeneratedSeries.isEmpty();
    }

    public DataLoadArgs getArgs() {
        return this.mArgs;
    }

    public BarDataSeries getBarDataSeries(DataLoadArgs args) {
        BarDataSeries ser = (BarDataSeries)this.mGeneratedSeries.get(args);
        if (ser == null) {
            ser = new BarDataSeries(args);
            Thread t = new Thread(() -> this.createAndPublishNewSeries(args));
            t.start();
        }
        return ser;
    }

    public List<DataLoadArgs> getCurrentSubscriptions() {
        this.mLock.lock();
        try {
            ArrayList<DataLoadArgs> arrayList = new ArrayList<DataLoadArgs>(this.mGeneratedSeries.keySet());
            return arrayList;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void createAndPublishNewSeries(DataLoadArgs args) {
        if (this.mShutdown) {
            return;
        }
        this.mLock.lock();
        try {
            if (!this.mIsStalled) {
                if (this.mGeneratedSeries.containsKey(args)) {
                    this.mGeneratedSeries.put(args, new BarDataSeries(args));
                }
                if (this.mArgs.Market.isReady(null)) {
                    if (this.mSubscribedMarketID.isEmpty()) {
                        this.mSubscribedMarketID = this.mArgs.Market.getAPIMarket().getMarketID();
                        this.mService.getMarketData().registerForMarketData(this.mMarketDataHandler);
                        this.mService.getMarketData().subscribeForMarketDepth(this.mArgs.Market.getAPIMarket(), DepthBuffer.SlowTrade, DepthLevels.BestOnly, false);
                    }
                    BarDataSeries ser = this.createBarDataSeries(args);
                    this.mGeneratedSeries.put(args, ser);
                }
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsDataPending() {
        this.mLock.lock();
        try {
            boolean seriesfull = this.mGeneratedSeries.size() > 0;
            for (BarDataSeries series : this.mGeneratedSeries.values()) {
                if (series.isAtCapacity()) continue;
                seriesfull = false;
                break;
            }
            if (this.mLastRequestedTradeDate.compareTo(this.mLastTradeDateLoaded) < 0 && !this.mIsStalled && !seriesfull) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean getIsStalled() {
        this.mLock.lock();
        try {
            boolean bl = this.mIsStalled;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean IsNotPermissioned() {
        this.mLock.lock();
        try {
            boolean bl = this.mNoPermission;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueDataLoadRequest(NDateTime requestLoadTime, DataLoadArgs args) {
        requestLoadTime = this.mArgs.Market.getTradeDate(requestLoadTime);
        boolean willLoad = false;
        this.mLock.lock();
        try {
            if (!this.mGeneratedSeries.containsKey(args)) {
                this.mGeneratedSeries.put(args, new BarDataSeries(args));
            }
            if (requestLoadTime.compareTo(this.mLastRequestedTradeDate) < 0) {
                this.mLastRequestedTradeDate = requestLoadTime;
                Log.d(TAG, "queueDataLoadRequest(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                willLoad = true;
            }
            if (this.getIsDataPending()) {
                this.beginLoadData();
            }
        }
        finally {
            this.mLock.unlock();
        }
        Log.d(TAG, String.format("queueDataRequest(), [%s], Stalled: %s, will load: %s, LastDateLoaded: %s, LastRequested: %s, Requested: %s (which is trade date: %s)", this.mArgs, this.mIsStalled, willLoad, this.mLastTradeDateLoaded, this.mLastRequestedTradeDate, requestLoadTime, this.mArgs.Market.getTradeDate(requestLoadTime)));
        return willLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNextTradeDate() {
        this.mLock.lock();
        try {
            if (this.mLastRequestedTradeDate.equals(NDateTime.MaxValue)) {
                Log.d(TAG, String.format("loadNextTradeDate(), [%s], Ignoring, as no data requested yet.", this.mArgs));
                return;
            }
            if (!this.getIsDataPending() && !this.mIsStalled) {
                NDateTime tradedate = this.mLastRequestedTradeDate.AddDays(-1.0);
                if (this.mArgs.isInterDay()) {
                    tradedate = tradedate.AddDays(-60.0);
                    tradedate = new NDateTime(tradedate.getYear(), tradedate.getMonth(), 1);
                }
                while (tradedate.compareTo(this.mLastRequestedTradeDate) >= 0) {
                    tradedate = tradedate.AddDays(-1.0);
                }
                NDateTime prevlrdate = this.mLastRequestedTradeDate;
                if (!tradedate.equals(NDateTime.MinValue) && tradedate.compareTo(this.mLastRequestedTradeDate) < 0) {
                    this.mLastRequestedTradeDate = tradedate;
                    Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                } else {
                    NDateTime currentTradeDate = this.mArgs.Market.getTradeDate(NDateTime.now());
                    if (this.mArgs.isInterDay()) {
                        if (this.mLastRequestedTradeDate.compareTo(currentTradeDate) > 0 || this.mLastRequestedTradeDate.equals(NDateTime.MaxValue)) {
                            this.mLastRequestedTradeDate = currentTradeDate.AddDays(-45.0);
                            Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                        } else {
                            this.mLastRequestedTradeDate = this.mLastRequestedTradeDate.AddDays(-45.0);
                            Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                        }
                    } else if (this.mLastRequestedTradeDate.compareTo(currentTradeDate) > 0 || this.mLastRequestedTradeDate.equals(NDateTime.MaxValue)) {
                        this.mLastRequestedTradeDate = currentTradeDate;
                        Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                    } else {
                        this.mLastRequestedTradeDate = this.mLastRequestedTradeDate.AddDays(-1.0);
                        Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                    }
                }
                Log.d(TAG, String.format("loadNextTradeDate(), [%s], LastRequestedDate changed from: %s to %s, LastTradeDateLoaded: %s", this.mArgs, prevlrdate, this.mLastRequestedTradeDate, this.mLastTradeDateLoaded));
                this.beginLoadData();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNextTradeDate(NDateTime tradedate) {
        this.mLock.lock();
        try {
            if (!this.getIsDataPending() && !this.mIsStalled) {
                NDateTime prevlrdate = this.mLastRequestedTradeDate;
                if (!tradedate.equals(NDateTime.MinValue) && tradedate.compareTo(this.mLastRequestedTradeDate) < 0) {
                    this.mLastRequestedTradeDate = tradedate;
                    Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                } else {
                    NDateTime currentTradeDate = this.mArgs.Market.getTradeDate(NDateTime.now());
                    if (this.mArgs.isInterDay()) {
                        if (this.mLastRequestedTradeDate.compareTo(currentTradeDate) > 0 || this.mLastRequestedTradeDate.equals(NDateTime.MaxValue)) {
                            this.mLastRequestedTradeDate = currentTradeDate.AddDays(-45.0);
                            Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                        } else {
                            this.mLastRequestedTradeDate = this.mLastRequestedTradeDate.AddDays(-45.0);
                            Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                        }
                    } else if (this.mLastRequestedTradeDate.compareTo(currentTradeDate) > 0 || this.mLastRequestedTradeDate.equals(NDateTime.MaxValue)) {
                        this.mLastRequestedTradeDate = currentTradeDate;
                        Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                    } else {
                        this.mLastRequestedTradeDate = this.mLastRequestedTradeDate.AddDays(-1.0);
                        Log.d(TAG, "loadNextTradeDate(), mLastRequestedTradeDate set to: " + String.valueOf(this.mLastRequestedTradeDate));
                    }
                }
                Log.d(TAG, String.format("loadNextTradeDate(), [%s], LastRequestedDate changed from: %s to %s, LastTradeDateLoaded: %s", this.mArgs, prevlrdate, this.mLastRequestedTradeDate, this.mLastTradeDateLoaded));
                this.beginLoadData();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean getNeedsFlush() {
        return this.mNeedsFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushResult flushTrades() {
        NDateTime dtfwd = NDateTime.MaxValue;
        DoubleRange tickrng = new DoubleRange();
        HashSet<DataLoadArgs> updatedSer = new HashSet<DataLoadArgs>();
        this.mQueueSyncLock.lock();
        try {
            this.mLock.lock();
            try {
                boolean flushTrades = true;
                for (TickDataPoint tick : this.mTradeQueue) {
                    NDateTime tickTradeDate = this.mArgs.Market.getTradeDate(tick.getTime());
                    if (tickTradeDate.compareTo(this.mLastTradeDateLoaded) < 0) {
                        flushTrades = false;
                        break;
                    }
                    tickrng.expand(tick.TradePrice.getDoubleValue());
                    NDateTime svrLiveTime = this.mServerData.getLiveDataSeries().getLiveDataPointTime();
                    if (svrLiveTime != null && svrLiveTime.compareTo(dtfwd) < 0) {
                        dtfwd = svrLiveTime;
                    }
                    this.mServerData.addLiveTrade(tick);
                    for (BarDataSeries genSeries : this.mGeneratedSeries.values()) {
                        NDateTime liveTime = genSeries.getLiveDataPointTime();
                        dtfwd = liveTime != null && liveTime.compareTo(dtfwd) < 0 ? liveTime : (liveTime = tick.Time);
                        if (tick.Time.compareTo(liveTime) < 0) continue;
                        genSeries.addLiveTrade(tick);
                        updatedSer.add(genSeries.getArgs());
                    }
                }
                if (flushTrades) {
                    this.mTradeQueue.clear();
                }
                boolean flushModes = true;
                for (MarketModeDataPoint mode : this.mModeQueue) {
                    NDateTime modeTradeDate = mode.TradeDate;
                    if (modeTradeDate.compareTo(this.mLastTradeDateLoaded) < 0) {
                        flushModes = false;
                        break;
                    }
                    this.mServerData.addLiveMode(mode);
                    for (BarDataSeries genSeries : this.mGeneratedSeries.values()) {
                        genSeries.addLiveModeChange(mode);
                        updatedSer.add(genSeries.getArgs());
                    }
                    if (mode.getTime().compareTo(dtfwd) >= 0) continue;
                    dtfwd = mode.Time;
                }
                if (flushModes) {
                    this.mModeQueue.clear();
                }
                for (SettlementDataPoint settl : this.mSettlementQueue) {
                    NDateTime settlTradeDate = settl.TradeDate;
                    if (settlTradeDate.compareTo(this.mLastTradeDateLoaded) < 0) break;
                    this.mServerData.addLiveSettlement(settl);
                    for (BarDataSeries genSeries : this.mGeneratedSeries.values()) {
                        genSeries.addLiveSettlement(settl);
                        updatedSer.add(genSeries.getArgs());
                    }
                    if (settl.getTime().compareTo(dtfwd) >= 0) continue;
                    dtfwd = settl.Time;
                }
                for (BarDataSeries genSeries : this.mGeneratedSeries.values()) {
                    genSeries.checkCapacity();
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "flushTrades(), [" + String.valueOf(this.mArgs) + "], Error flushing trades.", ex);
        }
        finally {
            this.mQueueSyncLock.unlock();
        }
        this.mNeedsFlush = false;
        return new FlushResult(dtfwd, Range.of(tickrng.start(), tickrng.end()), updatedSer);
    }

    private void beginLoadData() {
        if (this.mShutdown) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mIsStalled) {
                Log.v(TAG, "beginLoadData(), [" + String.valueOf(this.mArgs) + "], Loader stalled. Exiting.");
                return;
            }
            if (!this.mArgs.Market.isReady(null)) {
                Log.v(TAG, "beginLoadData(), [" + String.valueOf(this.mArgs) + "], Market not ready. Exiting.");
                return;
            }
            if (this.mLastTradeDateLoaded.equals(NDateTime.MaxValue)) {
                Log.v(TAG, "beginLoadData(), [" + String.valueOf(this.mArgs) + "], mLastTradeDateLoaded not initialized. Exiting.");
                return;
            }
            Market market = this.mArgs.Market.getAPIMarket();
            if (market == null) {
                Log.e(TAG, "beginLoadData(), [" + String.valueOf(this.mArgs) + "], Loader disposed. Exiting.");
                return;
            }
            if (this.mPendingRequest != null) {
                Log.v(TAG, "beginLoadData(), [" + String.valueOf(this.mArgs) + "], Waiting for pending data request to complete.");
            } else if (this.getIsDataPending()) {
                if (Host.useAggregatedChartData()) {
                    Log.v(TAG, String.format("beginLoadData(), [" + String.valueOf(this.mArgs) + "], Requesting chart data from %S for trade dates %s", this.mArgs.Market.getMarketID(), Range.of(this.mLastRequestedTradeDate, this.mLastTradeDateLoaded.AddDays(-1.0))));
                    this.mPendingRequest = new ChartDataRequest(this.mArgs, Range.of(this.mLastRequestedTradeDate, this.mLastTradeDateLoaded.AddDays(-1.0)));
                    this.mPendingRequest.processesRequest(this.mService, this.mChartDataCompleteHandler);
                } else if (this.mArgs.getDataType() == ChartDataType.Tick) {
                    Log.v(TAG, String.format("beginLoadData(), [" + String.valueOf(this.mArgs) + "], Requesting %s bars from %S for trade date %s", this.mArgs.getDataType(), this.mArgs.Market.getMarketID(), this.mLastTradeDateLoaded.AddDays(-1.0)));
                    this.mPendingRequest = new ChartDataBatchRequest(this.mArgs.Market, this.mArgs.getDataType(), Range.of(this.mLastTradeDateLoaded.AddDays(-1.0), this.mLastTradeDateLoaded.AddDays(-1.0)), this.mArgs.Session);
                    this.mPendingRequest.processesRequest(this.mService, this.mChartDataCompleteHandler);
                } else {
                    Log.v(TAG, String.format("beginLoadData(), [" + String.valueOf(this.mArgs) + "], Requesting %s bars from %S for trade dates %s", this.mArgs.getDataType(), this.mArgs.Market.getMarketID(), Range.of(this.mLastRequestedTradeDate, this.mLastTradeDateLoaded.AddDays(-1.0))));
                    this.mPendingRequest = new ChartDataBatchRequest(this.mArgs.Market, this.mArgs.getDataType(), Range.of(this.mLastRequestedTradeDate, this.mLastTradeDateLoaded.AddDays(-1.0)), this.mArgs.Session);
                    this.mPendingRequest.processesRequest(this.mService, this.mChartDataCompleteHandler);
                }
            } else {
                Log.v(TAG, String.format("beginLoadData(), [" + String.valueOf(this.mArgs) + "], All pending requests complete, LastTradeDateLoaded: %s, LastTradeDateRequested: %s", this.mLastTradeDateLoaded, this.mLastRequestedTradeDate));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "beginLoadData(), [" + String.valueOf(this.mArgs) + "], Error.", ex);
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void onChartDataComplete(IChartDataRequest request) {
        if (this.mShutdown) {
            return;
        }
        this.mLock.lock();
        try {
            if (request == this.mPendingRequest) {
                if (request.getStatus() != ChartDataRequestStatus.Complete) {
                    this.mIsStalled = true;
                    Log.e(TAG, "onChartDataComplete(), The chart data request failed. Status: " + String.valueOf((Object)request.getStatus()) + ", Reason: " + request.getFailMessage());
                    if (!request.getIsNotPermissioned()) {
                        this.mLastTradeDateLoaded = this.mArgs.Market.getTradeDate(NDateTime.now());
                    }
                } else {
                    this.loadBarData(request);
                    if (!request.getProcessedDates().isEmpty()) {
                        this.mLastTradeDateLoaded = request.getProcessedDates().start();
                    } else {
                        Log.e(TAG, "onChartDataComplete(), Processed dates is empty.");
                    }
                }
                Log.v(TAG, "onChartDataComplete(), [" + String.valueOf(this.mArgs) + "], LastTradeDateLoaded: " + String.valueOf(this.mLastTradeDateLoaded));
                this.mPendingRequest = null;
                this.mHandler.onDataUpdated(this, new ArrayList<DataLoadArgs>(this.mGeneratedSeries.keySet()));
                this.beginLoadData();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void loadBarData(IChartDataRequest request) {
        if (request instanceof ChartDataRequest) {
            this.loadBarDataAggr((ChartDataRequest)request);
        } else if (request instanceof ChartDataBatchRequest) {
            this.loadBarData((ChartDataBatchRequest)request);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadBarDataAggr(ChartDataRequest request) {
        void var5_9;
        NTimeSpan loadGap;
        this.mServerData.setLastHistoricalTradeTime(request.getLastTradeTime());
        List<MsgChartAggregatedData> data = request.getChartData();
        Range<NDateTime> dateRange = request.getProcessedDates();
        if (data != null) {
            for (MsgChartAggregatedData msgChartAggregatedData : data) {
                this.mServerData.addHistoricalDataAggr(msgChartAggregatedData);
                dateRange = dateRange.expanded(msgChartAggregatedData.TradeDateStart);
                dateRange = dateRange.expanded(msgChartAggregatedData.TradeDateEnd);
            }
        }
        ArrayList genSeries = new ArrayList(this.mGeneratedSeries.values());
        for (BarDataSeries ser : genSeries) {
            if (ser.isAtCapacity() && dateRange.start().compareTo(ser.getFirst().getTradeDate()) < 0) continue;
            BarDataSeries regenSeries = this.createBarDataSeriesAggr(ser.getArgs());
            this.mGeneratedSeries.put(regenSeries.getArgs(), regenSeries);
        }
        NDateTime nDateTime = this.mServerData.getLastTradeDate();
        if (nDateTime.equals(NDateTime.MaxValue)) {
            NDateTime nDateTime2 = NDateTime.now().getDate();
        }
        if ((loadGap = var5_9.Subtract(request.getRequestedDates().start())).getTotalDays() > 20.0) {
            this.mIsStalled = true;
            Log.e(TAG, "loadBarData(), Stalling data load. " + loadGap.getTotalDays() + " days without any chart data.");
        }
    }

    private BarDataSeries createBarDataSeriesAggr(DataLoadArgs args) {
        final BarDataSeries ser = new BarDataSeries(args);
        IAggregator agg = Aggregator.createAggregator(ser);
        BarDataSeries liveSer = this.mServerData.getLiveDataSeries();
        for (MsgChartAggregatedData msg : this.mServerData.getHistoricalDataAggr()) {
            ChartDataStreamReaderAggr.read(msg.Data, new ChartDataStreamReaderAggr.ChartDataHandler(){

                @Override
                public void onMarketDefinition(ChartFormatAggr.MarketDefinition marketDefinition) {
                }

                @Override
                public void onBar(ChartFormatAggr.Bar bar) {
                    ser.AddDataPoint(BarDataPoint.CreateBar(bar.TradeDate, bar.Time, bar.CloseTime, bar.OpenPrice, bar.HighPrice, bar.LowPrice, bar.ClosePrice, bar.Volume, bar.VolumeAtBid, bar.VolumeAtOffer, bar.Trades, bar.TradesAtBid, bar.TradesAtOffer, false));
                }

                @Override
                public void onModeChange(String marketID, NDateTime tradeDate, NDateTime time, MarketMode mode) {
                }

                @Override
                public void onSettlement(String marketID, NDateTime tradeDate, NDateTime time, Price settlmentPrice, boolean held) {
                }

                @Override
                public void onOpenInterest(String marketID, NDateTime tradeDate, NDateTime time, int openInterest) {
                }
            });
        }
        return ser;
    }

    /*
     * WARNING - void declaration
     */
    private void loadBarData(ChartDataBatchRequest request) {
        void var5_9;
        NTimeSpan loadGap;
        this.mServerData.setLastHistoricalTradeTime(request.getLastTradeTime());
        Collection<MsgChartDataBatch.MarketData> data = request.getChartData();
        Range<Object> dateRange = Range.empty();
        if (data != null) {
            for (MsgChartDataBatch.MarketData marketData : data) {
                this.mServerData.addHistoricalData(marketData);
                dateRange = dateRange.expanded(marketData.TradeDate);
            }
        }
        ArrayList genSeries = new ArrayList(this.mGeneratedSeries.values());
        for (BarDataSeries ser : genSeries) {
            if (ser.isAtCapacity() && ((NDateTime)dateRange.start()).compareTo(ser.getFirst().getTradeDate()) < 0) continue;
            BarDataSeries regenSeries = this.createBarDataSeries(ser.getArgs());
            this.mGeneratedSeries.put(regenSeries.getArgs(), regenSeries);
        }
        NDateTime nDateTime = this.mServerData.getLastTradeDate();
        if (nDateTime.equals(NDateTime.MaxValue)) {
            NDateTime nDateTime2 = NDateTime.now().getDate();
        }
        if ((loadGap = var5_9.Subtract(request.getRequestedDates().start())).getTotalDays() > 20.0) {
            this.mIsStalled = true;
            Log.e(TAG, "loadBarData(), Stalling data load. " + loadGap.getTotalDays() + " days without any chart data.");
        }
    }

    private BarDataSeries createBarDataSeries(DataLoadArgs args) {
        SettlementDataPoint settl;
        BigDecimal settlementCash;
        Price settlementPrice;
        NDateTime tradeDate;
        NDateTime tradeDateTmp;
        NDateTime time;
        Object state;
        BarDataSeries ser = new BarDataSeries(args);
        IAggregator agg = Aggregator.createAggregator(ser);
        BarDataSeries liveSer = this.mServerData.getLiveDataSeries();
        if (args.CloseWithSettlement) {
            ChartDataReader settlRdr = new ChartDataReader(this.mServerData.getHistoricalData(), this.mArgs.getDataType(), AppSettings.instance.MarketData.TradeSummary);
            while (settlRdr.read()) {
                state = settlRdr.getState();
                if (((ChartDataState)state).Change != ChartDataChange.Settlement) continue;
                time = new NDateTime(((ChartDataState)state).LastTimeTicks);
                tradeDate = tradeDateTmp = args.Market.getTradeDate(time);
                while (tradeDate.compareTo(((ChartDataState)state).TradeDate) >= 0) {
                    tradeDateTmp = tradeDateTmp.AddDays(-1.0);
                    tradeDate = args.Market.getTradeDate(tradeDateTmp);
                }
                settlementPrice = ((ChartDataState)state).SettlementPrice;
                if (!((ChartDataState)state).getMinPriceIncrement().equals(args.Market.getMinPriceIncrement())) {
                    settlementCash = settlementPrice.toCash((IMarketConversion)state);
                    settlementPrice = Price.fromCash(args.Market.getAPIMarket(), settlementCash);
                }
                settl = new SettlementDataPoint(tradeDate, time, settlementPrice);
                agg.addSettlement(settl);
            }
            for (SettlementDataPoint settl2 : liveSer.getSettlementData()) {
                agg.addSettlement(settl2);
            }
        }
        ChartDataReader rdr = new ChartDataReader(this.mServerData.getHistoricalData(), this.mArgs.getDataType(), AppSettings.instance.MarketData.TradeSummary);
        while (rdr.read()) {
            NDateTime tradeDate2;
            state = rdr.getState();
            if (((ChartDataState)state).Change == ChartDataChange.TradeBar) {
                NDateTime barStartTime = new NDateTime(((ChartDataState)state).BarStartTime);
                NDateTime barCloseTime = new NDateTime(((ChartDataState)state).BarCloseTime);
                tradeDate = ((ChartDataState)state).TradeDate;
                Price openPrice = ((ChartDataState)state).BarOpenPrice;
                Price highPrice = ((ChartDataState)state).BarHighPrice;
                Price lowPrice = ((ChartDataState)state).BarLowPrice;
                Price closePrice = ((ChartDataState)state).BarClosePrice;
                if (!((ChartDataState)state).getMinPriceIncrement().equals(args.Market.getMinPriceIncrement())) {
                    BigDecimal openValue = openPrice.toCash((IMarketConversion)state);
                    BigDecimal highValue = highPrice.toCash((IMarketConversion)state);
                    BigDecimal lowValue = lowPrice.toCash((IMarketConversion)state);
                    BigDecimal closeValue = closePrice.toCash((IMarketConversion)state);
                    openPrice = Price.fromCash(args.Market, openValue);
                    highPrice = Price.fromCash(args.Market, highValue);
                    lowPrice = Price.fromCash(args.Market, lowValue);
                    closePrice = Price.fromCash(args.Market, closeValue);
                }
                agg.addBar(barStartTime, barCloseTime, openPrice, highPrice, lowPrice, closePrice, ((ChartDataState)state).BarVolume, ((ChartDataState)state).BarBidVolume, ((ChartDataState)state).BarOfferVolume, ((ChartDataState)state).BarTrades, ((ChartDataState)state).BarTradesAtBid, ((ChartDataState)state).BarTradesAtOffer, tradeDate, false);
                continue;
            }
            if (((ChartDataState)state).Change == ChartDataChange.Trade) {
                if (((ChartDataState)state).DueToSpread || ((ChartDataState)state).TradeVolume <= 0) continue;
                NDateTime tradeTime = new NDateTime(((ChartDataState)state).LastTimeTicks);
                tradeDate2 = ((ChartDataState)state).TradeDate;
                Price tradePrice = ((ChartDataState)state).LastTradePrice;
                BidOffer tradeSide = ((ChartDataState)state).AtBidOrOffer;
                if (!((ChartDataState)state).getMinPriceIncrement().equals(args.Market.getMinPriceIncrement())) {
                    BigDecimal tradeValue = tradePrice.toCash((IMarketConversion)state);
                    tradePrice = Price.fromCash(args.Market, tradeValue);
                }
                agg.addTrade(tradeTime, tradePrice, ((ChartDataState)state).TradeVolume, tradeSide, tradeDate2, false);
                continue;
            }
            if (((ChartDataState)state).Change == ChartDataChange.MarketMode) {
                time = new NDateTime(((ChartDataState)state).LastTimeTicks);
                tradeDate2 = args.Market.getTradeDate(time);
                MarketModeDataPoint mode = new MarketModeDataPoint(tradeDate2, time, ((ChartDataState)state).Mode);
                agg.addModeChange(mode);
                continue;
            }
            if (((ChartDataState)state).Change != ChartDataChange.Settlement || args.CloseWithSettlement) continue;
            time = new NDateTime(((ChartDataState)state).LastTimeTicks);
            tradeDate = tradeDateTmp = args.Market.getTradeDate(time);
            while (tradeDate.compareTo(((ChartDataState)state).TradeDate) >= 0) {
                tradeDateTmp = tradeDateTmp.AddDays(-1.0);
                tradeDate = args.Market.getTradeDate(tradeDateTmp);
            }
            settlementPrice = ((ChartDataState)state).SettlementPrice;
            if (!((ChartDataState)state).getMinPriceIncrement().equals(args.Market.getMinPriceIncrement())) {
                settlementCash = settlementPrice.toCash((IMarketConversion)state);
                settlementPrice = Price.fromCash(args.Market, settlementCash);
            }
            settl = new SettlementDataPoint(tradeDate, time, settlementPrice);
            agg.addSettlement(settl);
        }
        if (!args.CloseWithSettlement) {
            for (SettlementDataPoint settl2 : liveSer.getSettlementData()) {
                agg.addSettlement(settl2);
            }
        }
        for (MarketModeDataPoint mode : liveSer.getModeData()) {
            agg.addModeChange(mode);
        }
        for (IBarDataPoint bar : liveSer) {
            agg.addBar(bar.getTime(), bar.getCloseTime(), bar.getOpen(), bar.getHigh(), bar.getLow(), bar.getClose(), bar.getVolume(), bar.getVolumeAtBid(), bar.getVolumeAtOffer(), bar.getTradeCount(), bar.getTradesAtBid(), bar.getTradesAtOffer(), bar.getTradeDate(), false);
        }
        return ser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case MarketDepthD: {
                MsgMarketDepthD depthmsg = (MsgMarketDepthD)msg;
                if (!this.mSubscribedMarketID.equals(((MsgMarketDepthD)msg).MarketID) || this.mLastMarketMode != MarketMode.Expired && this.mLastMarketMode == depthmsg.DepthMode.Mode) break;
                this.mLastMarketMode = depthmsg.DepthMode.Mode;
                NDateTime depthDt = depthmsg.Time;
                NDateTime tradeDate = this.mArgs.Market.getTradeDate(depthDt);
                MarketModeDataPoint mode = new MarketModeDataPoint(tradeDate, depthDt, depthmsg.DepthMode.Mode);
                this.mLock.lock();
                try {
                    this.mModeQueue.add(mode);
                    break;
                }
                finally {
                    this.mLock.unlock();
                }
            }
            case MarketDepthTradeD: {
                MsgMarketDepthTradeD trademsg = (MsgMarketDepthTradeD)msg;
                if (!this.mSubscribedMarketID.equals(((MsgMarketDepthTradeD)msg).MarketID) || trademsg.DueToSpread || trademsg.LastTradeVolume <= 0) break;
                NDateTime tradeTime = trademsg.Time;
                NDateTime tradeDate = this.mArgs.Market.getTradeDate(tradeTime);
                TickDataPoint trade = new TickDataPoint(tradeDate, tradeTime, trademsg.LastTradePrice, trademsg.LastTradeVolume, trademsg.AtBidOrOffer, true);
                this.mLock.lock();
                try {
                    this.mTradeQueue.add(trade);
                    break;
                }
                finally {
                    this.mLock.unlock();
                }
            }
            case MarketSettlementD: {
                NDateTime tradeDateTmp;
                MsgMarketSettlementD settlmsg = (MsgMarketSettlementD)msg;
                if (!this.mSubscribedMarketID.equals(settlmsg.MarketID)) break;
                NDateTime settlTime = settlmsg.SettlementTime;
                NDateTime settlTradeDate = settlmsg.SettlementTradeDate.getDate();
                NDateTime tradeDate = tradeDateTmp = this.mArgs.Market.getTradeDate(settlTime);
                while (tradeDate.compareTo(settlTradeDate) >= 0) {
                    tradeDateTmp = tradeDateTmp.AddDays(-1.0);
                    tradeDate = this.mArgs.Market.getTradeDate(tradeDateTmp);
                }
                Price settlementPrice = settlmsg.SettlementPrice;
                SettlementDataPoint settl = new SettlementDataPoint(tradeDate, settlTime, settlementPrice);
                this.mLock.lock();
                try {
                    this.mSettlementQueue.add(settl);
                    break;
                }
                finally {
                    this.mLock.unlock();
                }
            }
        }
    }

    private void onMarketReady() {
        if (this.mShutdown) {
            return;
        }
        Log.d(TAG, "onMarketReady(), [" + String.valueOf(this.mArgs) + "], Ready: " + this.mArgs.Market.isReady(null));
        this.mLock.lock();
        Log.d(TAG, "onMarketReady(), [" + String.valueOf(this.mArgs) + "], Lock Acquired.");
        try {
            if (!this.mArgs.Market.isReady(null) || this.mArgs.Market.getAPIMarket() == null) {
                Log.d(TAG, "onMarketReady(), [" + String.valueOf(this.mArgs) + "], Stalling loader because the market isn't really ready.");
                this.mIsStalled = true;
                this.mHandler.onDataUpdated(this, null);
            } else {
                if (this.mGeneratedSeries.size() > 0) {
                    this.mSubscribedMarketID = this.mArgs.Market.getAPIMarket().getMarketID();
                    this.mService.getMarketData().registerForMarketData(this.mMarketDataHandler);
                    this.mService.getMarketData().subscribeForMarketDepth(this.mArgs.Market.getAPIMarket(), DepthBuffer.SlowTrade, DepthLevels.BestOnly, false);
                }
                if (this.getIsDataPending()) {
                    Log.d(TAG, "onMarketReady(), [" + String.valueOf(this.mArgs) + "], Starting pending data load.");
                    this.beginLoadData();
                } else {
                    Log.d(TAG, "onMarketReady(), [" + String.valueOf(this.mArgs) + "], No pending data load.");
                }
            }
        }
        finally {
            this.mLock.unlock();
        }
        Log.d(TAG, "onMarketReady(), [" + String.valueOf(this.mArgs) + "], Checking out.");
    }

    public static interface SubscriptionHandler {
        public void onDataUpdated(ChartDataSubscription var1, List<DataLoadArgs> var2);
    }
}

