/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata;

import com.t4login.Log;
import com.t4login.definitions.chartdata.ChartDataChange;
import com.t4login.definitions.chartdata.ChartDataState;
import com.t4login.definitions.chartdata.ChartDataStreamReader;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.messages.MsgChartDataBatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;

public class ChartDataReader {
    private static final String TAG = "ChartDataReader";
    private final List<MsgChartDataBatch.MarketData> mBatchData;
    private final ChartDataType mDataType;
    private final boolean mTradeSummary;
    private int mCurrBatch = 0;
    private ChartDataStreamReader mReader = null;

    public ChartDataReader(MsgChartDataBatch msg, boolean tradeSummary) {
        this(msg.BatchData, msg.DataType, tradeSummary);
    }

    public ChartDataReader(List<MsgChartDataBatch.MarketData> data, ChartDataType dataType, boolean tradeSummary) {
        this.mBatchData = data;
        this.mDataType = dataType;
        this.mTradeSummary = tradeSummary;
        if (this.mBatchData.size() > 0) {
            this.mCurrBatch = 0;
            MsgChartDataBatch.MarketData batch = this.mBatchData.get(this.mCurrBatch);
            this.mReader = new ChartDataStreamReader(new ByteArrayInputStream(batch.BinData), batch.TradeDate, batch.MarketID, this.mDataType);
        }
    }

    public ChartDataState getState() {
        if (this.mReader != null) {
            return this.mReader.getState();
        }
        return ChartDataState.empty;
    }

    public boolean read() {
        if (this.mReader == null) {
            return false;
        }
        try {
            ChartDataState state;
            if (this.mReader.getState().Change == ChartDataChange.Trade && !this.mTradeSummary && this.mReader.getState().OrderVolumes != null && this.mReader.getState().OrderVolumes.length > 1) {
                state = this.mReader.getState();
                ++state.OrderVolumeIndex;
                if (state.OrderVolumeIndex < state.OrderVolumes.length) {
                    state.TradeVolume = state.OrderVolumes[state.OrderVolumeIndex];
                    state.LastTTV += state.TradeVolume;
                }
            }
            while (!this.mReader.read()) {
                this.mReader.close();
                this.mReader = null;
                ++this.mCurrBatch;
                if (this.mCurrBatch < this.mBatchData.size()) {
                    MsgChartDataBatch.MarketData batch = this.mBatchData.get(this.mCurrBatch);
                    this.mReader = new ChartDataStreamReader(new ByteArrayInputStream(batch.BinData), batch.TradeDate, batch.MarketID, this.mDataType);
                    continue;
                }
                return false;
            }
            if (this.mReader.getState().Change == ChartDataChange.Trade) {
                state = this.mReader.getState();
                if (!this.mTradeSummary && state.OrderVolumes != null && state.OrderVolumes.length > 1) {
                    state.OrderVolumeIndex = 0;
                    state.LastTTV = state.LastTTV - state.TradeVolume + state.OrderVolumes[state.OrderVolumeIndex];
                    state.TradeVolume = state.OrderVolumes[state.OrderVolumeIndex];
                }
            }
        }
        catch (IOException ioex) {
            Log.e(TAG, "read(), Error: ", ioex);
            this.mReader = null;
            return false;
        }
        return true;
    }
}

