/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.chartdata;

import com.t4login.Log;
import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.ChartDataSubscription;
import com.t4login.api.chartdata.ChartDataSubscriptionHandler;
import com.t4login.api.chartdata.DataSeriesSubscription;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.FlushResult;
import com.t4login.connection.IMessageHandler;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.messages.Message;
import com.t4login.messages.MsgApplicationSignal;
import com.t4login.messages.MsgMarketSnapshotD;
import com.t4login.messages.application.MsgServiceStateChange;
import com.t4login.util.ReturnFlag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChartData {
    private static final String TAG = "ChartData";
    private static final double MAX_NO_FLUSH_SECONDS = 60.0;
    NDateTime mLastChartFlushTime = NDateTime.now();
    private final T4HostService mService;
    private final List<ChartDataSubscriptionHandler> mChartDataHandlers = new CopyOnWriteArrayList<ChartDataSubscriptionHandler>();
    private final ConcurrentMap<DataLoadArgs, ChartDataSubscription> mChartDataSubscriptions = new ConcurrentHashMap<DataLoadArgs, ChartDataSubscription>(50, 0.9f, 1);
    private final Map<DataLoadArgs, DataSeriesSubscription> mDataSeriesSubscriptions = new HashMap<DataLoadArgs, DataSeriesSubscription>();
    private ChartDataSubscription.SubscriptionHandler mSubscriptionHandler = new ChartDataSubscription.SubscriptionHandler(){

        @Override
        public void onDataUpdated(ChartDataSubscription subscription, List<DataLoadArgs> updatedSeries) {
            if (updatedSeries != null && updatedSeries.size() > 0) {
                for (ChartDataSubscriptionHandler cb : ChartData.this.mChartDataHandlers) {
                    try {
                        Log.d(ChartData.TAG, "onDataUpdated(), Notifying: " + String.valueOf(cb));
                        cb.onDataSeriesUpdated(updatedSeries);
                    }
                    catch (Exception ex) {
                        Log.e(ChartData.TAG, "onDataUpdated(), ChartDataSubscriptionHandler raised an unhandled exception.", ex);
                    }
                }
            } else {
                Log.e(ChartData.TAG, "onDataUpdated(), Stalled?");
            }
        }
    };

    public ChartData(T4HostService s) {
        this.mService = s;
        this.mService.registerMessageHandler(new IMessageHandler(){

            @Override
            public void onMessage(Message msg) {
                ChartData.this.onMessage(msg);
            }
        });
    }

    public T4HostService getService() {
        return this.mService;
    }

    public void registerForSubscriptionUpdates(ChartDataSubscriptionHandler handler) {
        if (!this.mChartDataHandlers.contains(handler)) {
            this.mChartDataHandlers.add(handler);
        }
    }

    public void unregisterForSubscriptionUpdates(ChartDataSubscriptionHandler handler) {
        if (this.mChartDataHandlers.contains(handler)) {
            this.mChartDataHandlers.remove(handler);
        }
    }

    public BarDataSeries getBarDataSeries(DataLoadArgs args) {
        ChartDataSubscription subscr = this.getSubscription(args);
        return subscr.getBarDataSeries(args);
    }

    public void loadBarData(DataLoadArgs args, NDateTime tradeDate) {
        Log.d(TAG, "loadBarData(), args: " + String.valueOf(args) + ", tradeDate: " + String.valueOf(tradeDate));
        ChartDataSubscription subscr = this.getSubscription(args);
        subscr.queueDataLoadRequest(tradeDate, args);
    }

    public void loadNextTradeDate(DataLoadArgs args) {
        ChartDataSubscription subscr = this.getSubscription(args);
        if (!subscr.getIsDataPending()) {
            subscr.loadNextTradeDate();
        }
    }

    public boolean isLoading(DataLoadArgs args) {
        ChartDataSubscription subscr = this.getSubscription(args);
        return subscr.getIsDataPending();
    }

    public synchronized void clearChartData(DataLoadArgs args) {
        ChartDataSubscription subscr = (ChartDataSubscription)this.mChartDataSubscriptions.get(args);
        if (subscr != null) {
            this.mChartDataSubscriptions.remove(args);
            List<DataLoadArgs> activeArgs = subscr.getCurrentSubscriptions();
            for (DataLoadArgs subargs : activeArgs) {
                this.mDataSeriesSubscriptions.remove(subargs);
            }
            this.mDataSeriesSubscriptions.remove(args);
            subscr.shutdown();
            for (ChartDataSubscriptionHandler cb : this.mChartDataHandlers) {
                try {
                    cb.onDataSeriesReset(activeArgs);
                }
                catch (Exception ex) {
                    Log.e(TAG, "flushLiveTrades(), ChartDataSubscriptionHandler raised an unhandled exception.", ex);
                }
            }
        }
    }

    private void clearAllSubscriptions() {
        this.mDataSeriesSubscriptions.clear();
        ArrayList subscriptions = new ArrayList(this.mChartDataSubscriptions.values());
        this.mChartDataSubscriptions.clear();
        for (ChartDataSubscription sub : subscriptions) {
            sub.shutdown();
        }
    }

    private synchronized ChartDataSubscription getSubscription(DataLoadArgs args) {
        ChartDataSubscription subscr = (ChartDataSubscription)this.mChartDataSubscriptions.get(args);
        if (subscr == null) {
            subscr = new ChartDataSubscription(this.mService, args, this.mSubscriptionHandler);
            this.mChartDataSubscriptions.put(args, subscr);
            Log.d(TAG, "getSubscription(), created new chart data subscription: " + String.valueOf(args));
        }
        return subscr;
    }

    private void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case SignalMessage: {
                this.processApplicationSignal((MsgApplicationSignal)msg);
                break;
            }
            case MarketSnapshotD: {
                MsgMarketSnapshotD snapmsg = (MsgMarketSnapshotD)msg;
                for (Message cmsg : snapmsg.Messages) {
                    switch (cmsg.getMessageType()) {
                        case MarketDepthD: 
                        case MarketDepthTradeD: 
                        case MarketSettlementD: {
                            this.processMessage(msg);
                        }
                    }
                }
                break;
            }
            case MarketDepthD: 
            case MarketDepthTradeD: 
            case MarketSettlementD: {
                this.processMessage(msg);
                break;
            }
        }
    }

    private void processMessage(Message msg) {
        for (ChartDataSubscription subscr : this.mChartDataSubscriptions.values()) {
            try {
                subscr.onMessage(msg);
            }
            catch (Exception ex) {
                Log.e(TAG, "processMessage(), ChartDataSubscription raised an unhandled exception while processing a market message. Subscroption: " + String.valueOf(subscr.getArgs()), ex);
            }
        }
    }

    private void processApplicationSignal(MsgApplicationSignal msg) {
        block0 : switch (msg.getSignal()) {
            case CheckSubscriptions: {
                this.onCheckSubscriptions();
                break;
            }
            case ServiceStateChange: {
                MsgServiceStateChange ssmsg = (MsgServiceStateChange)msg;
                switch (ssmsg.getNewState()) {
                    case Disconnected: 
                    case Connected: 
                    case Stopped: {
                        this.clearAllSubscriptions();
                        break block0;
                    }
                }
                break;
            }
            case ChartDataFlush: {
                this.onChartDataFlushTimer();
            }
        }
    }

    private void onCheckSubscriptions() {
        HashSet<DataLoadArgs> inactiveDataSubscriptions = new HashSet<DataLoadArgs>(this.mDataSeriesSubscriptions.keySet());
        for (ChartDataSubscription chartDataSubscription : this.mChartDataSubscriptions.values()) {
            List<DataLoadArgs> subs = chartDataSubscription.getCurrentSubscriptions();
            for (DataLoadArgs args : subs) {
                if (!this.mDataSeriesSubscriptions.containsKey(args)) {
                    this.mDataSeriesSubscriptions.put(args, new DataSeriesSubscription(args));
                    continue;
                }
                inactiveDataSubscriptions.remove(args);
            }
        }
        for (DataLoadArgs dataLoadArgs : inactiveDataSubscriptions) {
            this.mDataSeriesSubscriptions.remove(dataLoadArgs);
        }
        ArrayList<DataSeriesSubscription> subscriptions = new ArrayList<DataSeriesSubscription>(this.mDataSeriesSubscriptions.values());
        for (ChartDataSubscriptionHandler cb : this.mChartDataHandlers) {
            try {
                cb.onCheckSubscriptions(subscriptions);
            }
            catch (Exception ex) {
                Log.e(TAG, "onCheckSubscriptions(), ChartDataSubscriptionHandler raised an unhandled exception.", ex);
            }
        }
        for (DataSeriesSubscription sub : subscriptions) {
            NTimeSpan timeSinceSubscribed = NDateTime.now().Subtract(sub.getLastMarkedTime());
            Log.d(TAG, "onCheckSubscriptions(), [" + String.valueOf(sub.Args) + "], Unused: " + timeSinceSubscribed.getTotalSeconds() + "sec (" + String.valueOf(sub.getLastMarkedTime()) + ")");
        }
        ArrayList arrayList = new ArrayList(this.mChartDataSubscriptions.keySet());
        for (DataLoadArgs args : arrayList) {
            ChartDataSubscription cdSub = (ChartDataSubscription)this.mChartDataSubscriptions.get(args);
            int n = cdSub.updateDataSeriesSubscriptions(subscriptions);
            if (n != 0) continue;
            cdSub.shutdown();
            this.mChartDataSubscriptions.remove(args);
        }
    }

    private void onChartDataFlushTimer() {
        ReturnFlag flg = new ReturnFlag();
        for (ChartDataSubscriptionHandler cb : this.mChartDataHandlers) {
            try {
                cb.onDataSeriesFlushTimer(flg);
            }
            catch (Exception ex) {
                Log.e(TAG, "onChartDataFlushTimer(), ChartDataSubscriptionHandler raised an unhandled exception.", ex);
            }
        }
        if (!flg.isSet() && this.mChartDataSubscriptions.size() > 0) {
            double secondsSinceFlush = NDateTime.now().Subtract(this.mLastChartFlushTime).getTotalSeconds();
            if (secondsSinceFlush > 60.0) {
                Log.d(TAG, "onChartDataFlushTimer(), No flush handlers responded after " + secondsSinceFlush + "sec (max 60.0sec. Purging all chart data subscriptions.");
                this.clearAllSubscriptions();
            }
        } else {
            this.mLastChartFlushTime = NDateTime.now();
        }
    }

    public void flushLiveTrades() {
        ArrayList<DataLoadArgs> updatedSeries = new ArrayList<DataLoadArgs>();
        for (ChartDataSubscription subscr : this.mChartDataSubscriptions.values()) {
            try {
                FlushResult res = subscr.flushTrades();
                updatedSeries.addAll(res.UpdatedSeries);
            }
            catch (Exception ex) {
                Log.e(TAG, "flushLiveTrades(), Error. ", ex);
            }
        }
        if (updatedSeries.size() > 0) {
            for (ChartDataSubscriptionHandler cb : this.mChartDataHandlers) {
                try {
                    cb.onDataSeriesFlushed(updatedSeries);
                }
                catch (Exception ex) {
                    Log.e(TAG, "flushLiveTrades(), ChartDataSubscriptionHandler raised an unhandled exception.", ex);
                }
            }
        }
    }
}

