/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.alerts.inputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.t4login.api.MarketID;
import com.t4login.api.alerts.inputs.Input;
import com.t4login.definitions.ContinuationType;
import com.t4login.definitions.ContractMonths;
import java.util.ArrayList;

public class MarketInput
extends Input {
    public static MarketInput newMarketInput(MarketID marketID, String as) {
        MarketInput i = new MarketInput(as);
        i.mJson.addProperty("exchangeid", marketID.ExchangeID);
        i.mJson.addProperty("contractid", marketID.ContractID);
        if (marketID.MarketID != null && marketID.MarketID.length() > 0) {
            i.mJson.addProperty("marketid", marketID.MarketID);
        } else {
            i.mJson.addProperty("continuationtype", marketID.ContinuationType.name());
            i.mJson.addProperty("rolloverdays", (Number)marketID.RolloverDays);
            i.mJson.addProperty("forwardmonths", (Number)marketID.ForwardMonths);
            if (marketID.ExpiryMonths.length != 0 && marketID.ExpiryMonths.length != 12) {
                JsonArray exp = new JsonArray();
                for (ContractMonths m : marketID.ExpiryMonths) {
                    exp.add(m.name());
                }
                i.mJson.add("expirymonths", (JsonElement)exp);
            }
        }
        return i;
    }

    public static MarketInput newFromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonObject o = parser.parse(json).getAsJsonObject();
        return new MarketInput(o);
    }

    public static MarketInput newFromJson(JsonObject obj) {
        return new MarketInput(obj);
    }

    private MarketInput(String as) {
        super(as);
    }

    private MarketInput(JsonObject obj) {
        super(obj);
    }

    public MarketID getMarketID() {
        String exchangeID = MarketInput.getStringProperty(this.mJson, "exchangeid");
        String contractID = MarketInput.getStringProperty(this.mJson, "contractid");
        String marketID = MarketInput.getStringProperty(this.mJson, "marketid");
        if (exchangeID == null || contractID == null) {
            return null;
        }
        if (marketID != null) {
            return new MarketID(exchangeID, contractID, marketID);
        }
        String continuationTypeName = MarketInput.getStringProperty(this.mJson, "continuationtype");
        int rolloverDays = MarketInput.getIntProperty(this.mJson, "rolloverdays", 0);
        int forwardMonths = MarketInput.getIntProperty(this.mJson, "forwardmonths", 0);
        JsonElement expElem = this.mJson.get("expirymonths");
        if (continuationTypeName != null) {
            ArrayList<ContractMonths> exp = new ArrayList<ContractMonths>();
            if (expElem instanceof JsonArray) {
                JsonArray expArr = (JsonArray)expElem;
                for (int i = 0; i < expArr.size(); ++i) {
                    JsonElement e = expArr.get(i);
                    if (!(e instanceof JsonPrimitive)) continue;
                    exp.add(ContractMonths.valueOf(e.getAsString()));
                }
            }
            ContractMonths[] expMos = exp.toArray(new ContractMonths[0]);
            return new MarketID(exchangeID, contractID, ContinuationType.valueOf(continuationTypeName), rolloverDays, forwardMonths, expMos);
        }
        return null;
    }
}

