/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.alerts.inputs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public abstract class Input {
    protected final JsonObject mJson;

    protected Input(String as) {
        this.mJson = new JsonObject();
        this.mJson.addProperty("as", as);
    }

    protected Input(JsonObject obj) {
        this.mJson = obj.deepCopy();
    }

    public JsonObject getJsonObject() {
        return this.mJson.deepCopy();
    }

    public String getJson() {
        return this.mJson.toString();
    }

    public String as() {
        return Input.getStringProperty(this.mJson, "as");
    }

    protected static String getStringProperty(JsonObject object, String key) {
        JsonElement elem = object.get(key);
        if (elem != null) {
            return elem.getAsString();
        }
        return null;
    }

    protected static String getStringProperty(JsonObject object, String key, String defaultValue) {
        JsonElement elem = object.get(key);
        if (elem != null) {
            return elem.getAsString();
        }
        return defaultValue;
    }

    protected static Integer getIntProperty(JsonObject object, String key) {
        JsonElement elem = object.get(key);
        if (elem != null) {
            return elem.getAsInt();
        }
        return null;
    }

    protected static int getIntProperty(JsonObject object, String key, int defaultValue) {
        JsonElement elem = object.get(key);
        if (elem != null) {
            return elem.getAsInt();
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input that = (Input)o;
        return this.mJson.equals((Object)that.mJson);
    }

    public int hashCode() {
        return this.mJson.hashCode();
    }
}

