/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.alerts.inputs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.t4login.api.alerts.inputs.Input;
import com.t4login.api.alerts.inputs.MarketInput;
import com.t4login.application.chart.SessionTime;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.definitions.BarIntervalBreak;
import com.t4login.definitions.ChartResetInterval;
import com.t4login.definitions.ChartType;
import com.t4login.definitions.ContinuationType;
import java.util.LinkedHashMap;

public class ChartInput
extends Input {
    public static ChartInput newChartInput(MarketInput market, String as) {
        ChartInput i = new ChartInput(as);
        i.mJson.add("market", (JsonElement)market.getJsonObject());
        return i;
    }

    public static ChartInput newFromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonObject o = parser.parse(json).getAsJsonObject();
        return new ChartInput(o);
    }

    private ChartInput(String as) {
        super(as);
    }

    private ChartInput(JsonObject obj) {
        super(obj);
    }

    public MarketInput getMarket() {
        JsonElement e = this.mJson.get("market");
        if (e instanceof JsonObject) {
            return MarketInput.newFromJson((JsonObject)e);
        }
        return null;
    }

    public ChartType getChartType() {
        String val = ChartInput.getStringProperty(this.mJson, "charttype", "Bar");
        return ChartType.valueOf(val);
    }

    public void setChartType(ChartType chartType) {
        this.mJson.addProperty("charttype", chartType.name());
    }

    public BarIntervalBreak getBarInterval() {
        String val = ChartInput.getStringProperty(this.mJson, "barinterval", "Day");
        return BarIntervalBreak.valueOf(val);
    }

    public void setBarInterval(BarIntervalBreak interval) {
        this.mJson.addProperty("barinterval", interval.name());
    }

    public int getBarIntervalSize() {
        return ChartInput.getIntProperty(this.mJson, "period", 1);
    }

    public void setBarIntervalSize(int period) {
        this.mJson.addProperty("period", (Number)period);
    }

    public SessionTimeRange getSessionFilter() {
        JsonElement e = this.mJson.get("sessionfilter");
        if (e instanceof JsonObject) {
            SessionTime startTime = SessionTime.valueOf(ChartInput.getStringProperty((JsonObject)e, "starttime", "00:00"));
            SessionTime endTime = SessionTime.valueOf(ChartInput.getStringProperty((JsonObject)e, "endtime", "00:00"));
            return new SessionTimeRange(startTime, endTime);
        }
        return null;
    }

    public void setSessionFilter(SessionTimeRange session) {
        this.mJson.remove("sessionfilter");
        if (session != null) {
            JsonObject s = new JsonObject();
            this.mJson.add("sessionfilter", (JsonElement)s);
            s.addProperty("starttime", session.startTime().toString());
            s.addProperty("endtime", session.endTime().toString());
        }
    }

    public ChartResetInterval getChartResetInterval() {
        String val = ChartInput.getStringProperty(this.mJson, "resetinterval", "Bar");
        return ChartResetInterval.valueOf(val);
    }

    public void setChartResetInterval(ChartResetInterval resetInterval) {
        this.mJson.addProperty("resetinterval", resetInterval.name());
    }

    public Continuation getContinuation() {
        JsonElement e = this.mJson.get("continuation");
        if (e instanceof JsonObject) {
            return new Continuation((JsonObject)e);
        }
        return null;
    }

    public void setContinuation(Continuation continuation) {
        this.mJson.remove("continuation");
        if (continuation != null) {
            this.mJson.add("continuation", (JsonElement)continuation.mJson);
        }
    }

    public LinkedHashMap<String, String> getExConfig() {
        JsonElement e = this.mJson.get("exconfig");
        if (e instanceof JsonObject) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            JsonObject o = (JsonObject)e;
            for (String key : o.keySet()) {
                map.put(key, ChartInput.getStringProperty(o, key));
            }
            return map;
        }
        return null;
    }

    public void setExConfig(LinkedHashMap<String, String> map) {
        this.mJson.remove("exconfig");
        JsonObject o = new JsonObject();
        for (String key : map.keySet()) {
            o.addProperty(key, map.get(key));
        }
    }

    public void addExConfig(String key, String value) {
        JsonElement e = this.mJson.get("exconfig");
        if (!(e instanceof JsonObject)) {
            JsonObject o = new JsonObject();
            e = o;
            this.mJson.add("exconfig", (JsonElement)o);
        }
        ((JsonObject)e).remove(key);
        ((JsonObject)e).addProperty(key, value);
    }

    public static class Continuation {
        private final JsonObject mJson;

        public static Continuation newContinuation(ContinuationType continuationType, int rolloverDays, int forwardMonths) {
            Continuation c = new Continuation();
            c.mJson.addProperty("continuationtype", continuationType.name());
            c.mJson.addProperty("rolloverdays", (Number)rolloverDays);
            c.mJson.addProperty("forwardmonths", (Number)forwardMonths);
            return c;
        }

        private Continuation() {
            this.mJson = new JsonObject();
        }

        private Continuation(JsonObject o) {
            this.mJson = o;
        }

        public ContinuationType getContinuationType() {
            String val = Input.getStringProperty(this.mJson, "continuationtype", "Volume");
            return ContinuationType.valueOf(val);
        }

        public int getRolloverDays() {
            return Input.getIntProperty(this.mJson, "rolloverdays", 0);
        }

        public int getForwardMonths() {
            return Input.getIntProperty(this.mJson, "forwardmonths", 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Continuation that = (Continuation)o;
            return this.mJson.equals((Object)that.mJson);
        }

        public int hashCode() {
            return this.mJson.hashCode();
        }
    }
}

