/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.alerts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.t4login.definitions.AlertActionType;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.Map;

public class AlertAction {
    private final JsonObject mJson;

    public static AlertAction newFlashAction() {
        AlertAction a = new AlertAction();
        a.mJson.addProperty("actiontype", AlertActionType.Flash.name());
        return a;
    }

    public static AlertAction newEmailAction(String emailAddress) {
        AlertAction a = new AlertAction();
        a.mJson.addProperty("actiontype", AlertActionType.Email.name());
        a.mJson.addProperty("emailaddress", emailAddress);
        return a;
    }

    public static AlertAction newTxtSMSAction(String countryCode, String mobileNumber, String formatted) {
        AlertAction a = new AlertAction();
        a.mJson.addProperty("actiontype", AlertActionType.TextSMS.name());
        a.mJson.addProperty("countrycode", countryCode);
        a.mJson.addProperty("mobilenumber", mobileNumber);
        a.mJson.addProperty("formatted", formatted);
        return a;
    }

    public static AlertAction newNotificationAction() {
        AlertAction a = new AlertAction();
        a.mJson.addProperty("actiontype", AlertActionType.Notification.name());
        return a;
    }

    public static AlertAction newNotificationAction(Device[] devices) {
        AlertAction a = new AlertAction();
        a.mJson.addProperty("actiontype", AlertActionType.Notification.name());
        if (devices.length > 0) {
            JsonArray devs = new JsonArray();
            a.mJson.add("devices", (JsonElement)devs);
            for (Device d : devices) {
                devs.add((JsonElement)d.mJson);
            }
        }
        return a;
    }

    public static AlertAction newFromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonObject o = parser.parse(json).getAsJsonObject();
        return new AlertAction(o);
    }

    private AlertAction() {
        this.mJson = new JsonObject();
    }

    public AlertAction(JsonObject obj) {
        this.mJson = obj.deepCopy();
    }

    public AlertActionType getActionType() {
        JsonElement elem = this.mJson.get("actiontype");
        return AlertActionType.valueOf(elem.getAsString());
    }

    public JsonObject getJsonObject() {
        return this.mJson.deepCopy();
    }

    public String getJson() {
        return this.mJson.toString();
    }

    public String getEmailAddress() {
        if (this.getActionType().equals(AlertActionType.Email)) {
            return AlertAction.getStringProperty(this.mJson, "emailaddress");
        }
        return null;
    }

    public String getCountryCode() {
        if (this.getActionType().equals(AlertActionType.TextSMS)) {
            return AlertAction.getStringProperty(this.mJson, "countrycode");
        }
        return null;
    }

    public String getMobileNumber() {
        if (this.getActionType().equals(AlertActionType.TextSMS)) {
            return AlertAction.getStringProperty(this.mJson, "mobilenumber");
        }
        return null;
    }

    public String getFormattedMobileNumber() {
        if (this.getActionType().equals(AlertActionType.TextSMS)) {
            return AlertAction.getStringProperty(this.mJson, "formatted");
        }
        return null;
    }

    public Device[] getDevices() {
        JsonArray arr;
        if (this.getActionType().equals(AlertActionType.Notification) && (arr = this.mJson.getAsJsonArray("devices")) != null) {
            ArrayList<Device> devices = new ArrayList<Device>();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement e = arr.get(i);
                if (!(e instanceof JsonObject)) continue;
                Device device = new Device((JsonObject)e);
                devices.add(device);
            }
            return devices.toArray(new Device[0]);
        }
        return null;
    }

    public int getDeviceCount() {
        JsonArray arr;
        if (this.getActionType().equals(AlertActionType.Notification) && (arr = this.mJson.getAsJsonArray("devices")) != null) {
            return arr.size();
        }
        return 0;
    }

    public Device getDevice(int i) {
        JsonElement e;
        JsonArray arr;
        if (this.getActionType().equals(AlertActionType.Notification) && (arr = this.mJson.getAsJsonArray("devices")) != null && (e = arr.get(i)) instanceof JsonObject) {
            return new Device((JsonObject)e);
        }
        return null;
    }

    private static String getStringProperty(JsonObject object, String key) {
        JsonElement elem = object.get(key);
        if (elem != null) {
            return elem.getAsString();
        }
        return null;
    }

    public String toString() {
        return this.getActionType().getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AlertAction other = (AlertAction)obj;
        if (other.mJson.size() != this.mJson.size()) {
            return false;
        }
        for (Map.Entry en : this.mJson.entrySet()) {
            String key = (String)en.getKey();
            JsonElement value = (JsonElement)en.getValue();
            JsonElement otherValue = other.mJson.get(key);
            if (otherValue != null && otherValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public String getDetailDescription() {
        if (this.getActionType().equals(AlertActionType.Email)) {
            return this.getEmailAddress();
        }
        if (this.getActionType().equals(AlertActionType.TextSMS)) {
            return this.getFormattedMobileNumber();
        }
        if (this.getActionType().equals(AlertActionType.Notification)) {
            Device[] devices = this.getDevices();
            if (devices == null) {
                return "All Devices";
            }
            ArrayList<String> deviceNames = new ArrayList<String>();
            for (Device device : devices) {
                deviceNames.add(device.getDeviceName());
            }
            return TextUtils.join((CharSequence)", ", deviceNames);
        }
        return this.getActionType().getDescription();
    }

    public static class Device {
        private final JsonObject mJson;

        public static Device newDevice(String deviceID, String deviceName) {
            Device d = new Device();
            d.mJson.addProperty("deviceid", deviceID);
            d.mJson.addProperty("devicename", deviceName);
            return d;
        }

        private Device() {
            this.mJson = new JsonObject();
        }

        private Device(JsonObject o) {
            this.mJson = o;
        }

        public String getDeviceID() {
            return AlertAction.getStringProperty(this.mJson, "deviceid");
        }

        public String getDeviceName() {
            return AlertAction.getStringProperty(this.mJson, "devicename");
        }
    }
}

