/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.alerts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.t4login.api.alerts.AlertAction;
import com.t4login.util.TextUtils;
import java.util.ArrayList;

public class ActionSet {
    private final JsonObject mJson;
    private final JsonArray mActions;

    public static ActionSet newFromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonObject o = parser.parse(json).getAsJsonObject();
        return new ActionSet(o);
    }

    public ActionSet(String name) {
        this.mJson = new JsonObject();
        this.mJson.addProperty("name", name);
        this.mActions = new JsonArray();
        this.mJson.add("actions", (JsonElement)this.mActions);
    }

    public ActionSet(JsonObject obj) {
        this.mJson = obj.deepCopy();
        this.mActions = this.mJson.getAsJsonArray("actions");
    }

    public JsonObject getJsonObject() {
        return this.mJson.deepCopy();
    }

    public String getJson() {
        return this.mJson.toString();
    }

    public String getName() {
        return ActionSet.getStringProperty(this.mJson, "name");
    }

    public void addAction(AlertAction action) {
        int dupAction = -1;
        for (int i = 0; i < this.mActions.size(); ++i) {
            if (!this.mActions.get(i).equals(action)) continue;
            dupAction = i;
            break;
        }
        if (dupAction >= 0) {
            this.mActions.remove(dupAction);
        }
        this.mActions.add((JsonElement)action.getJsonObject());
    }

    public AlertAction[] getActions() {
        ArrayList<AlertAction> actions = new ArrayList<AlertAction>();
        for (JsonElement e : this.mActions) {
            actions.add(new AlertAction((JsonObject)e));
        }
        return actions.toArray(new AlertAction[0]);
    }

    public int getActionCount() {
        return this.mActions.size();
    }

    public AlertAction getAction(int i) {
        JsonObject actionObj = (JsonObject)this.mActions.get(i);
        return new AlertAction(actionObj);
    }

    public String getDetailDescription() {
        ArrayList<String> details = new ArrayList<String>();
        for (AlertAction a : this.getActions()) {
            details.add(a.getDetailDescription());
        }
        return TextUtils.join((CharSequence)", ", details);
    }

    private static String getStringProperty(JsonObject object, String key) {
        JsonElement elem = object.get(key);
        if (elem != null) {
            return elem.getAsString();
        }
        return null;
    }
}

