/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.api.Market;
import com.t4login.api.accounts.Account;
import com.t4login.api.accounts.MatchedTrade;
import com.t4login.api.accounts.Position;
import com.t4login.api.accounts.Trade;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.StreamSupport;

public class TradeMatching {
    public static List<MatchedTrade> computePositionMatchedTrades(Position position, Market market, Account account) {
        List<WorkingTrade> sortedTrades = StreamSupport.stream(position.getOrders().spliterator(), false).flatMap(order -> StreamSupport.stream(order.getTrades().spliterator(), false)).sorted(Comparator.comparing(Trade::getTime)).map(trade -> new WorkingTrade(trade.getMarketID(), account.getAccountID(), trade.getSide(), trade.getPrice(), trade.getTime(), trade.getVolume())).toList();
        List<MatchedTrade> matchedTrades = TradeMatching.matchTrades(account.getAccountID(), market, sortedTrades);
        return matchedTrades;
    }

    public static List<MatchedTrade> matchTrades(String accountID, IMarketConversion market, List<WorkingTrade> sortedTrades) {
        ArrayList<MatchedTrade> matchedTrades = new ArrayList<MatchedTrade>();
        LinkedList<WorkingTrade> openShort = new LinkedList<WorkingTrade>();
        LinkedList<WorkingTrade> openLong = new LinkedList<WorkingTrade>();
        for (WorkingTrade trade : sortedTrades) {
            MatchedTrade matchedTrade;
            BigDecimal rpl;
            int closedVolume;
            WorkingTrade openTrade;
            if (trade.RemainingVolume > 0 && trade.Side.equals(BuySell.Buy)) {
                while (trade.RemainingVolume > 0 && !openShort.isEmpty()) {
                    openTrade = (WorkingTrade)openShort.poll();
                    closedVolume = Math.min(trade.RemainingVolume, openTrade.RemainingVolume);
                    rpl = TradeMatching.calculateRPL(trade, openTrade, closedVolume, market);
                    matchedTrade = new MatchedTrade(trade.MarketID, trade.AccountID, rpl, -1 * closedVolume, openTrade.Price, trade.Price, openTrade.TradeTime, trade.TradeTime);
                    matchedTrades.add(matchedTrade);
                    trade.RemainingVolume -= closedVolume;
                    openTrade.RemainingVolume -= closedVolume;
                    if (openTrade.RemainingVolume <= 0) continue;
                    openShort.addFirst(openTrade);
                }
                if (trade.RemainingVolume <= 0) continue;
                openLong.add(trade);
                continue;
            }
            if (trade.RemainingVolume <= 0 || !trade.Side.equals(BuySell.Sell)) continue;
            while (trade.RemainingVolume > 0 && !openLong.isEmpty()) {
                openTrade = (WorkingTrade)openLong.poll();
                closedVolume = Math.min(trade.RemainingVolume, openTrade.RemainingVolume);
                rpl = TradeMatching.calculateRPL(openTrade, trade, closedVolume, market);
                matchedTrade = new MatchedTrade(trade.MarketID, trade.AccountID, rpl, closedVolume, openTrade.Price, trade.Price, openTrade.TradeTime, trade.TradeTime);
                matchedTrades.add(matchedTrade);
                trade.RemainingVolume -= closedVolume;
                openTrade.RemainingVolume -= closedVolume;
                if (openTrade.RemainingVolume <= 0) continue;
                openLong.addFirst(openTrade);
            }
            if (trade.RemainingVolume <= 0) continue;
            openShort.add(trade);
        }
        return matchedTrades;
    }

    private static BigDecimal calculateRPL(WorkingTrade longTrade, WorkingTrade shortTrade, int volume, IMarketConversion market) {
        return shortTrade.Price.subtract(longTrade.Price).toCash(market).multiply(BigDecimal.valueOf(volume));
    }

    public static class WorkingTrade {
        public final String MarketID;
        public final String AccountID;
        public final BuySell Side;
        public final Price Price;
        public final NDateTime TradeTime;
        public int RemainingVolume;

        public WorkingTrade(String marketID, String accountID, BuySell side, Price price, NDateTime tradeTime, int volume) {
            this.MarketID = marketID;
            this.AccountID = accountID;
            this.Side = side;
            this.Price = price;
            this.TradeTime = tradeTime;
            this.RemainingVolume = volume;
        }
    }
}

