/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.api.accounts.Order;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgOrderUpdateD;

public class Trade {
    private Order mOrder;
    private MsgOrderUpdateD.Trade mTrade;

    public Trade(Order order, MsgOrderUpdateD.Trade trade) {
        this.mOrder = order;
        this.mTrade = trade;
    }

    public MsgOrderUpdateD.Trade getDetails() {
        return this.mTrade;
    }

    public Order getOrder() {
        return this.mOrder;
    }

    public String getMarketID() {
        return this.mOrder.getMarketID();
    }

    public NDateTime getTime() {
        return this.mTrade.Time;
    }

    public NDateTime getTimeBucket() {
        NDateTime t = this.getTime();
        return new NDateTime(t.getYear(), t.getMonth(), t.getDay(), t.getHour(), t.getMinute(), 0);
    }

    public BuySell getSide() {
        return this.mOrder.getSide();
    }

    public Price getPrice() {
        return this.mTrade.Price;
    }

    public int getVolume() {
        return this.mTrade.Volume;
    }

    public String getOrderID() {
        return this.mOrder.getUniqueID();
    }

    public long getUniqueOrderID() {
        return this.mOrder.UniqueOrderID;
    }

    public int getTradeSeq() {
        return this.mTrade.SequenceOrder;
    }
}

