/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Host;
import com.t4login.IHandler;
import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.MarketPriceFormatter;
import com.t4login.api.T4HostService;
import com.t4login.api.accounts.Account;
import com.t4login.api.accounts.AccountData;
import com.t4login.api.accounts.AccountDataHandler;
import com.t4login.api.accounts.IAccountDataHandler;
import com.t4login.api.accounts.Order;
import com.t4login.api.accounts.Position;
import com.t4login.api.accounts.PositionWorkingOrders;
import com.t4login.api.accounts.Trade;
import com.t4login.application.chart.chartdata.FillDataPoint;
import com.t4login.application.chart.chartdata.FillDataSeries;
import com.t4login.application.settings.AppSettings;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PositionWorkingOrdersUpdater {
    public static final String TAG = "PosWkingOrdersUpdater";
    private final IHandler mHandler = Host.createHandler();
    public final String MarketID;
    public MarketPriceFormatter mPriceFormatter = null;
    public final String mFixedAccountID;
    private String mAccountID;
    private volatile PositionWorkingOrders mWorkingOrders;
    private volatile FillDataSeries mFills;
    private AccountData mAccountData;
    private List<UpdateHandler> mUpdateHandlers = new CopyOnWriteArrayList<UpdateHandler>();
    IAccountDataHandler accountDataHandler = new AccountDataHandler(){

        @Override
        public String getDescription() {
            return "PosWkingOrdersUpdater: AccountID: " + PositionWorkingOrdersUpdater.this.mAccountID + ", MarketID: " + PositionWorkingOrdersUpdater.this.MarketID;
        }

        @Override
        public void onAccountComplete(final Account acct) {
            if (acct.getAccountID().equals(PositionWorkingOrdersUpdater.this.mAccountID)) {
                PositionWorkingOrdersUpdater.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PositionWorkingOrdersUpdater.this.initialize(acct);
                    }
                });
            }
        }

        @Override
        public void onOrderAdded(Account acct, Position position, final List<Order> updates) {
            if (acct.getAccountID().equals(PositionWorkingOrdersUpdater.this.mAccountID) && position.MarketID.equals(PositionWorkingOrdersUpdater.this.MarketID)) {
                PositionWorkingOrdersUpdater.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PositionWorkingOrdersUpdater.this.updateOrders(updates);
                    }
                });
            }
        }

        @Override
        public void onOrderUpdate(Account acct, Position position, final List<Order> updates) {
            if (acct.getAccountID().equals(PositionWorkingOrdersUpdater.this.mAccountID) && position.MarketID.equals(PositionWorkingOrdersUpdater.this.MarketID)) {
                PositionWorkingOrdersUpdater.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PositionWorkingOrdersUpdater.this.updateOrders(updates);
                    }
                });
            }
        }

        @Override
        public void onTrades(Account acct, Position position, final List<Trade> trades) {
            if (acct.getAccountID().equals(PositionWorkingOrdersUpdater.this.mAccountID) && position.MarketID.equals(PositionWorkingOrdersUpdater.this.MarketID)) {
                PositionWorkingOrdersUpdater.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PositionWorkingOrdersUpdater.this.addTrades(trades);
                    }
                });
            }
        }

        @Override
        public void onOrderRemoved(Account acct, Position position, final List<Order> updates) {
            if (acct.getAccountID().equals(PositionWorkingOrdersUpdater.this.mAccountID) && position.MarketID.equals(PositionWorkingOrdersUpdater.this.MarketID)) {
                PositionWorkingOrdersUpdater.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PositionWorkingOrdersUpdater.this.removeOrders(updates);
                    }
                });
            }
        }
    };

    public PositionWorkingOrdersUpdater(String marketid) {
        this.mFixedAccountID = null;
        this.mAccountID = "";
        this.MarketID = marketid;
        this.mWorkingOrders = new PositionWorkingOrders(this.mAccountID, marketid);
    }

    public PositionWorkingOrdersUpdater(String acctid, String marketid) {
        this.mFixedAccountID = acctid;
        this.mAccountID = acctid;
        this.MarketID = marketid;
        this.mWorkingOrders = new PositionWorkingOrders(this.mAccountID, marketid);
    }

    public String getAccountID() {
        return this.mAccountID;
    }

    public PositionWorkingOrders getWorkingOrders() {
        return this.mWorkingOrders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(T4HostService service, UpdateHandler updateHandler) {
        this.mUpdateHandlers.add(updateHandler);
        if (service != null) {
            Market market;
            MarketData md = service.getMarketData();
            if (md != null && (market = md.getMarket(this.MarketID)) != null) {
                this.mPriceFormatter = new MarketPriceFormatter(){

                    @Override
                    public Market getMarket() {
                        return market;
                    }

                    @Override
                    public String formatPrice(Price price) {
                        return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                };
            }
            if (this.mPriceFormatter == null) {
                Log.e(TAG, "connect(), Price formatter not initialized.");
            }
            if (this.mAccountData != null) {
                this.disconnect(updateHandler);
            }
            this.mAccountData = service.getAccountData();
            if (this.mAccountData != null) {
                this.mAccountData.registerForAccountData(this.accountDataHandler);
                Iterator<Account> iterator = this.mAccountData.getAccounts().iterator();
                while (iterator.hasNext()) {
                    Account acct;
                    Account account = acct = iterator.next();
                    synchronized (account) {
                        if (acct.isComplete()) {
                            this.initialize(acct);
                        }
                    }
                }
            }
        } else {
            this.mAccountData = null;
        }
    }

    public void disconnect(UpdateHandler updateHandler) {
        this.mUpdateHandlers.remove(updateHandler);
        if (this.mAccountData != null) {
            this.mAccountData.unregisterForAccountData(this.accountDataHandler);
        }
        this.mAccountData = null;
    }

    private void initialize(Account acct) {
        if (this.mPriceFormatter == null) {
            Log.e(TAG, "initialize(), Price formatter not initialized.");
            return;
        }
        this.mAccountID = acct.getAccountID();
        this.mWorkingOrders = new PositionWorkingOrders(this.mAccountID, this.MarketID);
        this.mFills = new FillDataSeries();
        Position position = acct.getPosition(this.MarketID, false);
        if (position != null) {
            this.mWorkingOrders.updateOrders(position.getOrders(), this.mPriceFormatter);
            for (Order order : position.getOrders()) {
                for (Trade trade : order.getTrades()) {
                    this.mFills.addFill(new FillDataPoint(trade));
                }
            }
        }
        for (UpdateHandler cb : this.mUpdateHandlers) {
            cb.onPositionWorkingOrdersUpdated(this.mWorkingOrders);
            cb.onFillsUpdated(this.mFills);
        }
    }

    private void addTrades(List<Trade> trades) {
        for (Trade trade : trades) {
            this.mFills.addFill(new FillDataPoint(trade));
        }
        for (UpdateHandler cb : this.mUpdateHandlers) {
            cb.onFillsUpdated(this.mFills);
        }
    }

    private void updateOrders(List<Order> orders) {
        if (this.mPriceFormatter == null) {
            Log.e(TAG, "updateOrders(), Price formatter not initialized.");
            return;
        }
        boolean updated = this.mWorkingOrders.updateOrders(orders, this.mPriceFormatter);
        if (updated) {
            for (UpdateHandler cb : this.mUpdateHandlers) {
                cb.onPositionWorkingOrdersUpdated(this.mWorkingOrders);
            }
        }
    }

    private void removeOrders(List<Order> orders) {
        boolean fillsUpdated;
        boolean updated = this.mWorkingOrders.removeOrders(orders);
        if (updated) {
            for (UpdateHandler cb : this.mUpdateHandlers) {
                cb.onPositionWorkingOrdersUpdated(this.mWorkingOrders);
            }
        }
        if (fillsUpdated = this.removeTrades(orders)) {
            for (UpdateHandler cb : this.mUpdateHandlers) {
                cb.onFillsUpdated(this.mFills);
            }
        }
    }

    private boolean removeTrades(List<Order> orders) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Order order : orders) {
            ids.add(order.UniqueOrderID);
        }
        ArrayList<FillDataPoint> removeFills = new ArrayList<FillDataPoint>();
        for (FillDataPoint fill : this.mFills) {
            long fillOrderId = fill.getTrade().getUniqueOrderID();
            if (!ids.contains(fillOrderId)) continue;
            removeFills.add(fill);
        }
        if (removeFills.size() > 0) {
            for (FillDataPoint removeFill : removeFills) {
                this.mFills.removeFill(removeFill);
            }
            return true;
        }
        return false;
    }

    public static interface UpdateHandler {
        public void onPositionWorkingOrdersUpdated(PositionWorkingOrders var1);

        public void onFillsUpdated(FillDataSeries var1);
    }
}

