/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Log;
import com.t4login.api.MarketPriceFormatter;
import com.t4login.api.PriceVolume;
import com.t4login.api.accounts.Order;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.OrderStatus;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.PriceRange;
import com.t4login.util.Range;
import com.t4login.util.SortUtil;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PositionWorkingOrders {
    public static final String TAG = "PositionWorkingOrders";
    public final String MarketID;
    public final String AccountID;
    private final Hashtable<Price, Integer> mWorkingBidVolume;
    private final Hashtable<Price, Integer> mWorkingOfferVolume;
    private final Hashtable<String, OrderDetail> mOrderDetails;
    private List<PriceDetail> mBuyPriceDetails = null;
    private Map<Price, PriceDetail> mBuyPriceDetailsByPrice = null;
    private List<PriceDetail> mSellPriceDetails = null;
    private Map<Price, PriceDetail> mSellPriceDetailsByPrice = null;
    private Range<Price> mPriceRange = null;
    private List<PriceVolume> mBidVolumes = null;
    private List<PriceVolume> mOfferVolumes = null;

    public PositionWorkingOrders(String acctID, String marketID) {
        this.AccountID = acctID;
        this.MarketID = marketID;
        this.mWorkingBidVolume = new Hashtable();
        this.mWorkingOfferVolume = new Hashtable();
        this.mOrderDetails = new Hashtable();
    }

    private PositionWorkingOrders(String acctID, String marketID, Hashtable<Price, Integer> bids, Hashtable<Price, Integer> offers, Hashtable<String, OrderDetail> orddet) {
        this.AccountID = acctID;
        this.MarketID = marketID;
        this.mWorkingBidVolume = bids;
        this.mWorkingOfferVolume = offers;
        this.mOrderDetails = orddet;
    }

    public int getBidVolume(Price price) {
        Integer bids = this.mWorkingBidVolume.get(price);
        return bids != null ? bids : 0;
    }

    public int getOfferVolume(Price price) {
        Integer offers = this.mWorkingOfferVolume.get(price);
        return offers != null ? offers : 0;
    }

    public List<PriceDetail> getBuyPriceDetails() {
        if (this.mBuyPriceDetails == null) {
            this.initializePriceDetails();
        }
        return this.mBuyPriceDetails;
    }

    public PriceDetail getBuyPriceDetails(double priceTicks) {
        PriceDetail det;
        if (this.mBuyPriceDetails == null) {
            this.initializePriceDetails();
        }
        return (det = this.mBuyPriceDetailsByPrice.get(priceTicks)) != null ? det : PriceDetail.Empty;
    }

    public List<PriceDetail> getSellPriceDetails() {
        if (this.mBuyPriceDetails == null) {
            this.initializePriceDetails();
        }
        return this.mSellPriceDetails;
    }

    public PriceDetail getSellPriceDetails(double priceTicks) {
        PriceDetail det;
        if (this.mBuyPriceDetails == null) {
            this.initializePriceDetails();
        }
        return (det = this.mSellPriceDetailsByPrice.get(priceTicks)) != null ? det : PriceDetail.Empty;
    }

    public PriceDetail getPriceDetails(BuySell side, double priceTicks) {
        if (side.equals(BuySell.Buy)) {
            return this.getBuyPriceDetails(priceTicks);
        }
        if (side.equals(BuySell.Sell)) {
            return this.getSellPriceDetails(priceTicks);
        }
        return PriceDetail.Empty;
    }

    public Range<Price> getPriceRange() {
        if (this.mPriceRange == null) {
            PriceRange rng = new PriceRange();
            for (Price prc : this.mWorkingBidVolume.keySet()) {
                rng.expand(prc);
            }
            for (Price prc : this.mWorkingOfferVolume.keySet()) {
                rng.expand(prc);
            }
            this.mPriceRange = !rng.isEmpty() ? Range.of(rng.start(), rng.end()) : Range.empty();
        }
        return this.mPriceRange;
    }

    private void initializePriceDetails() {
        PriceDetail det;
        this.mBuyPriceDetails = new ArrayList<PriceDetail>();
        this.mSellPriceDetails = new ArrayList<PriceDetail>();
        this.mBuyPriceDetailsByPrice = new HashMap<Price, PriceDetail>();
        this.mSellPriceDetailsByPrice = new HashMap<Price, PriceDetail>();
        HashMap<Price, ArrayList<OrderDetail>> buyOrders = new HashMap<Price, ArrayList<OrderDetail>>();
        HashMap<Price, ArrayList<OrderDetail>> sellOrders = new HashMap<Price, ArrayList<OrderDetail>>();
        for (OrderDetail ord : this.mOrderDetails.values()) {
            if (ord.Side.equals(BuySell.Buy)) {
                ArrayList<OrderDetail> buys = (ArrayList<OrderDetail>)buyOrders.get(ord.Price);
                if (buys == null) {
                    buys = new ArrayList<OrderDetail>();
                    buyOrders.put(ord.Price, buys);
                }
                buys.add(ord);
                continue;
            }
            if (!ord.Side.equals(BuySell.Sell)) continue;
            ArrayList<OrderDetail> sells = (ArrayList<OrderDetail>)sellOrders.get(ord.Price);
            if (sells == null) {
                sells = new ArrayList<OrderDetail>();
                sellOrders.put(ord.Price, sells);
            }
            sells.add(ord);
        }
        for (Price prc : buyOrders.keySet()) {
            det = this.computePriceDetail((List)buyOrders.get(prc));
            if (det == null) continue;
            this.mBuyPriceDetails.add(det);
            this.mBuyPriceDetailsByPrice.put(det.price, det);
        }
        for (Price prc : sellOrders.keySet()) {
            det = this.computePriceDetail((List)sellOrders.get(prc));
            if (det == null) continue;
            this.mSellPriceDetails.add(det);
            this.mSellPriceDetailsByPrice.put(det.price, det);
        }
        Collections.sort(this.mBuyPriceDetails, new Comparator<PriceDetail>(this){

            @Override
            public int compare(PriceDetail lhs, PriceDetail rhs) {
                return lhs.price.compareTo(rhs.price);
            }
        });
        Collections.sort(this.mSellPriceDetails, new Comparator<PriceDetail>(this){

            @Override
            public int compare(PriceDetail lhs, PriceDetail rhs) {
                return rhs.price.compareTo(lhs.price);
            }
        });
    }

    private PriceDetail computePriceDetail(List<OrderDetail> orderDetails) {
        if (orderDetails.size() == 0) {
            return null;
        }
        BuySell side = orderDetails.get((int)0).Side;
        Price tickPrice = orderDetails.get((int)0).Price;
        int workingVolume = 0;
        HashMap<String, Integer> summVols = new HashMap<String, Integer>();
        Collections.sort(orderDetails, new Comparator<OrderDetail>(this){

            @Override
            public int compare(OrderDetail lhs, OrderDetail rhs) {
                return SortUtil.compare(lhs.OrderPriceType.getValue(), rhs.OrderPriceType.getValue());
            }
        });
        for (OrderDetail orderDetail : orderDetails) {
            workingVolume += orderDetail.WorkingVolume;
            if (!summVols.containsKey(orderDetail.OrderTypeSummary)) {
                summVols.put(orderDetail.OrderTypeSummary, orderDetail.WorkingVolume);
                continue;
            }
            summVols.put(orderDetail.OrderTypeSummary, (Integer)summVols.get(orderDetail.OrderTypeSummary) + orderDetail.WorkingVolume);
        }
        ArrayList<String> summaries = new ArrayList<String>();
        for (OrderDetail det : orderDetails) {
            if (!summVols.containsKey(det.OrderTypeSummary)) continue;
            summaries.add(String.format("%s x%s", det.OrderTypeSummary, summVols.get(det.OrderTypeSummary)));
            summVols.remove(det.OrderTypeSummary);
        }
        String string = TextUtils.join((CharSequence)", ", summaries);
        return new PriceDetail(side, tickPrice, workingVolume, string);
    }

    public boolean updateOrders(Iterable<Order> orders, MarketPriceFormatter fmt) {
        boolean updated = false;
        for (Order order : orders) {
            updated |= this.removePrevOrder(order);
            updated |= this.addOrder(order, fmt);
        }
        this.mBuyPriceDetails = null;
        this.mSellPriceDetails = null;
        this.mBuyPriceDetailsByPrice = null;
        this.mSellPriceDetailsByPrice = null;
        this.mBidVolumes = null;
        this.mOfferVolumes = null;
        return updated;
    }

    public boolean removeOrders(Iterable<Order> orders) {
        boolean updated = false;
        for (Order order : orders) {
            updated |= this.removePrevOrder(order);
        }
        this.mBuyPriceDetails = null;
        this.mSellPriceDetails = null;
        this.mBuyPriceDetailsByPrice = null;
        this.mSellPriceDetailsByPrice = null;
        this.mBidVolumes = null;
        this.mOfferVolumes = null;
        return updated;
    }

    private boolean addOrder(Order order, MarketPriceFormatter fmt) {
        boolean added = false;
        if ((order.getOrderStatus() == OrderStatus.Working || order.getOrderStatus() == OrderStatus.None) && order.getWorkingVolume() > 0) {
            OrderDetail orderVol = new OrderDetail(order, fmt);
            if (orderVol.Price != null) {
                if (orderVol.Side.equals(BuySell.Buy)) {
                    Integer bids = this.mWorkingBidVolume.get(orderVol.Price);
                    bids = bids == null ? orderVol.WorkingVolume : bids + orderVol.WorkingVolume;
                    this.mWorkingBidVolume.put(orderVol.Price, bids);
                } else {
                    Integer offers = this.mWorkingOfferVolume.get(orderVol.Price);
                    offers = offers == null ? orderVol.WorkingVolume : offers + orderVol.WorkingVolume;
                    this.mWorkingOfferVolume.put(orderVol.Price, offers);
                }
            }
            this.mOrderDetails.put(order.getUniqueID(), orderVol);
            added = true;
        }
        return added;
    }

    private boolean removePrevOrder(Order order) {
        boolean removed = false;
        OrderDetail prevOrder = this.mOrderDetails.get(order.getUniqueID());
        if (prevOrder != null) {
            if (prevOrder.Price != null) {
                if (prevOrder.Side.equals(BuySell.Buy)) {
                    Integer bids = this.mWorkingBidVolume.get(prevOrder.Price);
                    if (bids == null) {
                        Log.e(TAG, "removePrevOrder(), No bids found at specified price.");
                    } else if ((bids = Integer.valueOf(bids - prevOrder.WorkingVolume)) > 0) {
                        this.mWorkingBidVolume.put(prevOrder.Price, bids);
                    } else {
                        this.mWorkingBidVolume.remove(prevOrder.Price);
                    }
                } else {
                    Integer offers = this.mWorkingOfferVolume.get(prevOrder.Price);
                    if (offers == null) {
                        Log.e(TAG, "removePrevOrder(), No offers found at specified price.");
                    } else if ((offers = Integer.valueOf(offers - prevOrder.WorkingVolume)) > 0) {
                        this.mWorkingOfferVolume.put(prevOrder.Price, offers);
                    } else {
                        this.mWorkingOfferVolume.remove(prevOrder.Price);
                    }
                }
            }
            this.mOrderDetails.remove(order.getUniqueID());
            removed = true;
        }
        return removed;
    }

    public Iterable<PriceVolume> getBidVolumes() {
        if (this.mBidVolumes == null) {
            ArrayList<PriceVolume> bidVols = new ArrayList<PriceVolume>();
            for (Map.Entry<Price, Integer> bidVol : this.mWorkingBidVolume.entrySet()) {
                bidVols.add(new PriceVolume(bidVol.getKey(), bidVol.getValue()));
            }
            this.mBidVolumes = bidVols;
        }
        return this.mBidVolumes;
    }

    public Iterable<PriceVolume> getOfferVolumes() {
        if (this.mOfferVolumes == null) {
            ArrayList<PriceVolume> offerVols = new ArrayList<PriceVolume>();
            for (Map.Entry<Price, Integer> offerVol : this.mWorkingOfferVolume.entrySet()) {
                offerVols.add(new PriceVolume(offerVol.getKey(), offerVol.getValue()));
            }
            this.mOfferVolumes = offerVols;
        }
        return this.mOfferVolumes;
    }

    public static class PriceDetail {
        public static final PriceDetail Empty = new PriceDetail(BuySell.Undefined, Price.Zero, 0, "");
        public final BuySell side;
        public final Price price;
        public final int workingVolume;
        public final String orderTypeSummary;

        public PriceDetail(BuySell side, Price prc, int vol, String summ) {
            this.side = side;
            this.price = prc;
            this.workingVolume = vol;
            this.orderTypeSummary = summ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PriceDetail that = (PriceDetail)o;
            if (that.price.compareTo(this.price) != 0) {
                return false;
            }
            if (this.workingVolume != that.workingVolume) {
                return false;
            }
            return this.side.equals(that.side);
        }

        public int hashCode() {
            int result = this.side.hashCode();
            long temp = this.price.hashCode();
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.workingVolume;
            return result;
        }

        public String toString() {
            return String.format("%s %s@%s (%s)", this.side, this.workingVolume, this.price, this.orderTypeSummary);
        }
    }

    private static class OrderDetail {
        public final String OrderID;
        public final BuySell Side;
        public final PriceType OrderPriceType;
        public final String OrderTypeSummary;
        public final Price Price;
        public final int WorkingVolume;

        public OrderDetail(Order order, MarketPriceFormatter fmt) {
            this.OrderID = order.getUniqueID();
            this.Side = order.getSide();
            this.OrderPriceType = order.getPriceType();
            this.OrderTypeSummary = Order.getOrderTypeDisplay(order.getLastUpdate(), fmt);
            this.Price = order.getWorkingPrice();
            this.WorkingVolume = order.getWorkingVolume();
        }
    }
}

