/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.api.accounts.MatchedTrade;
import com.t4login.api.accounts.NetPosition;
import com.t4login.application.settings.AppSettings;
import com.t4login.application.settings.AveragePriceDisplay;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgAccountPosition2;
import com.t4login.util.TextUtils;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PositionProfit {
    public final MsgAccountPosition2 mPositionUpdate;
    public final String AccountID;
    public final String MarketID;
    public final boolean IsOptions;
    public final boolean HasData;
    private final NetPosition mNet;
    public final BigDecimal UPL;
    public final BigDecimal UPLTrade;
    public final BigDecimal UPLUSD;
    public final BigDecimal UPLTradeUSD;
    public final BigDecimal DayMargin;
    public final BigDecimal FullMargin;
    public final Boolean IsEventBased;
    public final List<MatchedTrade> MatchedTrades;

    public static PositionProfit getEmpty(String accountID, String marketID) {
        MsgAccountPosition2 positionUpdate = new MsgAccountPosition2();
        positionUpdate.AccountID = accountID;
        positionUpdate.MarketID = marketID;
        return new PositionProfit(positionUpdate, accountID, marketID, false, false, NetPosition.Empty, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, Collections.unmodifiableList(new ArrayList()));
    }

    public PositionProfit(MsgAccountPosition2 positionUpdate, String accountID, String marketID, boolean options, boolean hasData, NetPosition net, BigDecimal upl, BigDecimal uplt, BigDecimal uplUSD, BigDecimal upltUSD, BigDecimal dayMarg, BigDecimal fullMarg, Boolean isEventBased, List<MatchedTrade> matchedTrades) {
        this.mPositionUpdate = positionUpdate;
        this.AccountID = accountID;
        this.MarketID = marketID;
        this.IsOptions = options;
        this.HasData = hasData;
        this.mNet = net;
        this.UPL = upl;
        this.UPLTrade = uplt;
        this.UPLUSD = uplUSD;
        this.UPLTradeUSD = upltUSD;
        this.DayMargin = dayMarg;
        this.FullMargin = fullMarg;
        this.IsEventBased = isEventBased;
        this.MatchedTrades = matchedTrades;
    }

    public String toString() {
        if (!this.HasData) {
            return "PositionProfit { <no data> }";
        }
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        parts.add((CallSite)((Object)("AccountID: " + this.AccountID)));
        parts.add((CallSite)((Object)("MarketID: " + this.MarketID)));
        parts.add((CallSite)((Object)("IsOptions: " + this.IsOptions)));
        parts.add((CallSite)((Object)("HasData: " + this.HasData)));
        parts.add((CallSite)((Object)("mNet: " + String.valueOf(this.mNet))));
        parts.add((CallSite)((Object)("UPL: " + this.UPL.stripTrailingZeros().toPlainString())));
        parts.add((CallSite)((Object)("UPLTrade: " + this.UPLTrade.stripTrailingZeros().toPlainString())));
        parts.add((CallSite)((Object)("UPLUSD: " + this.UPLUSD.stripTrailingZeros().toPlainString())));
        parts.add((CallSite)((Object)("UPLTradeUSD: " + this.UPLTradeUSD.stripTrailingZeros().toPlainString())));
        parts.add((CallSite)((Object)("FullMargin: " + this.FullMargin.stripTrailingZeros().toPlainString())));
        return "PositionProfit[" + TextUtils.join((CharSequence)", ", parts) + "]";
    }

    public boolean isImplied() {
        return this.mNet.Implied;
    }

    public int getBuys() {
        return this.mNet.Buys;
    }

    public int getSells() {
        return this.mNet.Sells;
    }

    public int getNet() {
        return this.mNet.Net;
    }

    public String getNetDisplay() {
        return NetPosition.getNetDisplay(this.mNet);
    }

    public int getWorkingBuys() {
        return this.mPositionUpdate.WorkingBuys;
    }

    public int getWorkingSells() {
        return this.mPositionUpdate.WorkingSells;
    }

    public double getRPL() {
        return this.mPositionUpdate.RPL;
    }

    public BigDecimal getPL() {
        return new BigDecimal(this.mPositionUpdate.RPL).add(this.UPL);
    }

    public BigDecimal getPLTrade() {
        return new BigDecimal(this.mPositionUpdate.RPL).add(this.UPLTrade);
    }

    public Price getAverageFillPrice() {
        AveragePriceDisplay display = AppSettings.instance.Contract.AverageFillPriceDisplay;
        if (display.equals(AveragePriceDisplay.AvgOpenFill)) {
            return this.mPositionUpdate.AverageOpenPrice;
        }
        if (display.equals(AveragePriceDisplay.AvgTotalFill)) {
            BigDecimal net = new BigDecimal(this.mPositionUpdate.Buys - this.mPositionUpdate.Sells);
            if (net.equals(BigDecimal.ZERO)) {
                return this.mPositionUpdate.TotalBuyFillPrice.subtract(this.mPositionUpdate.TotalSellFillPrice).divide(net);
            }
            return null;
        }
        if (display.equals(AveragePriceDisplay.AvgOpenUntilClosed)) {
            return this.mPositionUpdate.TotalOpenPrice.divide(new BigDecimal(this.mPositionUpdate.TotalOpenVolume));
        }
        return null;
    }

    public Price getAvgBuyFillPrice() {
        if (this.mPositionUpdate.Buys > 0) {
            return this.mPositionUpdate.TotalBuyFillPrice.divide(new BigDecimal(this.mPositionUpdate.Buys));
        }
        return null;
    }

    public Price getAvgSellFillPrice() {
        if (this.mPositionUpdate.Sells > 0) {
            return this.mPositionUpdate.TotalSellFillPrice.divide(new BigDecimal(this.mPositionUpdate.Sells));
        }
        return null;
    }

    public BigDecimal getMargin() {
        return new BigDecimal(this.mPositionUpdate.Margin);
    }

    public List<MatchedTrade> getMatchedTrades() {
        return this.MatchedTrades;
    }
}

