/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.api.OrderRevise;
import com.t4login.api.OrderSubmit;
import com.t4login.api.OrderSubmitAction;
import com.t4login.api.accounts.Order;
import com.t4login.api.accounts.Trade;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.AccountCode;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.BillingFee;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.CTI;
import com.t4login.definitions.OpenClose;
import com.t4login.definitions.OrderLink;
import com.t4login.definitions.OrderStatus;
import com.t4login.definitions.Origin;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.PrimaryUserType;
import com.t4login.definitions.ResponsePending;
import com.t4login.definitions.RevisionType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgAccountDayChange;
import com.t4login.messages.MsgAccountPosition2;
import com.t4login.messages.MsgOrderHistory2;
import com.t4login.messages.MsgOrderPull2;
import com.t4login.messages.MsgOrderRevision2;
import com.t4login.messages.MsgOrderSubmission2;
import com.t4login.messages.MsgOrderUpdateBaseD;
import com.t4login.messages.MsgOrderUpdateD;
import com.t4login.messages.MsgOrderUpdateFailedD;
import com.t4login.messages.MsgOrderUpdateMultiD;
import com.t4login.messages.MsgOrderUpdateStatusD;
import com.t4login.messages.MsgOrderUpdateTradeD;
import com.t4login.messages.MsgOrderUpdateTradeLegD;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class Position {
    public static final String TAG = "Position";
    static final int MAX_BATCH_ORDERS = 16;
    public final String AccountID;
    public final String MarketID;
    public final String PositionID;
    public MsgAccountPosition2 mPosition = new MsgAccountPosition2();
    public LinkedHashMap<String, Order> mOrders = new LinkedHashMap();

    public Position(String accountID, String marketID) {
        this.AccountID = accountID;
        this.MarketID = marketID;
        this.PositionID = accountID + "." + marketID;
    }

    public int getOrderCount() {
        return this.mOrders.size();
    }

    public Order getOrder(String orderID) {
        return this.mOrders.get(orderID);
    }

    public Iterable<Order> getOrders() {
        return this.mOrders.values();
    }

    public void processAccountPosition(MsgAccountPosition2 msg) {
        this.mPosition = msg;
    }

    public List<Order> processPositionDayChange(MsgAccountDayChange msg) {
        ArrayList<Order> removeOrders = new ArrayList<Order>();
        Iterator<Map.Entry<String, Order>> it = this.mOrders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Order> entry = it.next();
            Order order = entry.getValue();
            if (order.getIsWorking() || !msg.TradeDate.equals(NDateTime.MinValue) && order.getTradeDate().compareTo(msg.TradeDate) >= 0) continue;
            removeOrders.add(order);
            it.remove();
        }
        return removeOrders;
    }

    public long processOrderUpdate(MsgOrderUpdateMultiD msg, List<Order> ordersAdded, List<Order> ordersUpdated, List<Trade> tradesAdded) {
        long lastOrderUpdate = 0L;
        for (MsgOrderUpdateBaseD update : msg.Messages) {
            Order order = this.mOrders.get(update.UniqueID);
            if (order == null) {
                if (update instanceof MsgOrderUpdateD) {
                    order = new Order((MsgOrderUpdateD)update);
                    this.mOrders.put(update.UniqueID, order);
                    ordersAdded.add(order);
                    lastOrderUpdate = Math.max(lastOrderUpdate, update.Time.getTicks());
                    continue;
                }
                Log.w(TAG, "processOrderUpdate(), Order not found and incomplete update: '" + update.UniqueID + "'");
                continue;
            }
            switch (update.getMessageType()) {
                case OrderUpdateD: {
                    order.processOrderUpdate((MsgOrderUpdateD)update);
                    break;
                }
                case OrderUpdateFailedD: {
                    order.processOrderFailed((MsgOrderUpdateFailedD)update);
                    break;
                }
                case OrderUpdateStatusD: {
                    order.processOrderStatus((MsgOrderUpdateStatusD)update);
                    break;
                }
                case OrderUpdateTradeD: {
                    Trade trade = order.processOrderTrade((MsgOrderUpdateTradeD)update);
                    if (trade == null) break;
                    tradesAdded.add(trade);
                    break;
                }
                case OrderUpdateTradeLegD: {
                    order.processOrderTradeLeg((MsgOrderUpdateTradeLegD)update);
                    break;
                }
                default: {
                    Log.e(TAG, "processOrderUpdate(), Message type not implemented: '" + String.valueOf((Object)update.getMessageType()) + "'");
                }
            }
            ordersUpdated.add(order);
            lastOrderUpdate = Math.max(lastOrderUpdate, update.Time.getTicks());
        }
        return lastOrderUpdate;
    }

    public Order processOrderHistory(MsgOrderHistory2 msg) {
        Order order = this.mOrders.get(msg.UniqueID);
        if (order != null) {
            order.processOrderHistory(msg);
        } else {
            Log.e(TAG, "processOrderHistory(), Order not found: " + msg.UniqueID);
        }
        return order;
    }

    public MsgAccountPosition2 getPositionUpdate() {
        return this.mPosition;
    }

    public Price getAverageOpenPrice() {
        return this.mPosition.AverageOpenPrice;
    }

    public MsgOrderSubmission2 createNewOrder(OrderSubmitAction orderSubmitAction) {
        OpenClose openClose = OpenClose.Undefined;
        int trailRevisionInterval = 0;
        int trailRevisionChange = 0;
        ActivationType activationType = ActivationType.Immediate;
        String activationDetails = "";
        Object userRouting = null;
        Object accountRouting = null;
        boolean primaryUser = true;
        MsgOrderUpdateD updateMsg = new MsgOrderUpdateD();
        updateMsg.UniqueID = UUID.randomUUID().toString().toUpperCase(Locale.US);
        updateMsg.MarketID = orderSubmitAction.Market.getMarketID();
        updateMsg.ExchangeID = orderSubmitAction.Market.getExchangeID();
        updateMsg.AccountID = orderSubmitAction.AccountID;
        updateMsg.NewVolume = orderSubmitAction.Volume;
        updateMsg.NewLimitPrice = orderSubmitAction.LimitPrice;
        updateMsg.NewStopPrice = orderSubmitAction.StopPrice;
        updateMsg.BuySell = orderSubmitAction.Side;
        updateMsg.PriceType = orderSubmitAction.PriceType;
        updateMsg.TimeType = orderSubmitAction.TimeType;
        updateMsg.OpenClose = openClose;
        updateMsg.Tag = orderSubmitAction.Tag;
        updateMsg.PendingResponse = ResponsePending.Submission;
        updateMsg.WorkingVolume = orderSubmitAction.Volume;
        updateMsg.TrailPrice = orderSubmitAction.TrailPrice;
        updateMsg.TrailRevisionInterval = trailRevisionInterval;
        updateMsg.TrailRevisionChange = trailRevisionChange;
        updateMsg.ActivationType = activationType;
        updateMsg.ActivationDetails = activationDetails;
        updateMsg.NewMaxShow = orderSubmitAction.MaxShow;
        if (userRouting == null) {
            updateMsg.ExchangeLoginID = "";
            updateMsg.ExchangeLocation = "";
        }
        if (accountRouting == null) {
            updateMsg.AccountNumber = "";
            updateMsg.CTI = CTI.Undefined;
            updateMsg.Origin = Origin.Undefined;
            updateMsg.AccountCode = AccountCode.Undefined;
            updateMsg.BillingFee = BillingFee.Undefined;
            updateMsg.MemberAllocation = "";
            updateMsg.TraderAllocation = "";
            updateMsg.CustomerReference = "";
            updateMsg.OmnibusAccount = "";
        }
        if (!activationType.equals(ActivationType.Immediate)) {
            updateMsg.Status = OrderStatus.Held;
        }
        updateMsg.PrimaryUser = primaryUser ? PrimaryUserType.Primary : PrimaryUserType.Secondary;
        if (userRouting == null) {
            updateMsg.UserID = "";
            updateMsg.UserName = "";
        }
        updateMsg.OrderSource = orderSubmitAction.Source;
        updateMsg.OrderSourceMethod = orderSubmitAction.Method;
        Order order = new Order(updateMsg);
        this.mOrders.put(order.getUniqueID(), order);
        orderSubmitAction.setOrder(order);
        MsgOrderSubmission2 submissionMsg = new MsgOrderSubmission2();
        submissionMsg.AccountID = updateMsg.AccountID;
        submissionMsg.MarketID = updateMsg.MarketID;
        submissionMsg.ExchangeID = updateMsg.ExchangeID;
        submissionMsg.Time = NDateTime.now();
        submissionMsg.OrdersLinked = UUID.randomUUID().toString();
        submissionMsg.OrderLink = OrderLink.None;
        MsgOrderSubmission2.Order submissionOrder = new MsgOrderSubmission2.Order();
        submissionMsg.Orders.add(submissionOrder);
        submissionOrder.ExchangeOrderID = updateMsg.ExchangeOrderID;
        submissionOrder.UniqueID = updateMsg.UniqueID;
        submissionOrder.Tag = updateMsg.Tag;
        submissionOrder.BuySell = updateMsg.BuySell;
        submissionOrder.LimitPrice = updateMsg.NewLimitPrice;
        submissionOrder.PriceType = updateMsg.PriceType;
        submissionOrder.StopPrice = updateMsg.NewStopPrice;
        submissionOrder.TimeType = updateMsg.TimeType;
        submissionOrder.Volume = updateMsg.NewVolume;
        submissionOrder.OpenClose = updateMsg.OpenClose;
        submissionOrder.TrailTicks = updateMsg.TrailTicks;
        submissionOrder.TrailPrice = updateMsg.TrailPrice;
        submissionOrder.TrailRevisionInterval = updateMsg.TrailRevisionInterval;
        submissionOrder.TrailRevisionChange = updateMsg.TrailRevisionChange;
        submissionOrder.ActivationType = updateMsg.ActivationType;
        submissionOrder.ActivationValue = updateMsg.ActivationDetails;
        submissionOrder.MaxShow = updateMsg.NewMaxShow;
        submissionMsg.AccountNumber = updateMsg.AccountNumber;
        submissionMsg.CTI = updateMsg.CTI;
        submissionMsg.Origin = updateMsg.Origin;
        submissionMsg.AccountCode = updateMsg.AccountCode;
        submissionMsg.BillingFee = updateMsg.BillingFee;
        submissionMsg.MemberAllocation = updateMsg.MemberAllocation;
        submissionMsg.TraderAllocation = updateMsg.TraderAllocation;
        submissionMsg.CustomerReference = updateMsg.CustomerReference;
        submissionMsg.OmnibusAccount = updateMsg.OmnibusAccount;
        submissionMsg.ExchangeLoginID = updateMsg.ExchangeLoginID;
        submissionMsg.ExchangeLocation = updateMsg.ExchangeLocation;
        submissionMsg.PrimaryUser = updateMsg.PrimaryUser;
        submissionMsg.UserID = updateMsg.UserID;
        submissionMsg.UserName = updateMsg.UserName;
        submissionMsg.OrderSource = updateMsg.OrderSource;
        submissionMsg.OrderSourceMethod = updateMsg.OrderSourceMethod;
        return submissionMsg;
    }

    public MsgOrderSubmission2 createNewOrder(OrderSubmit orderSubmit) {
        OpenClose openClose = OpenClose.Undefined;
        int trailRevisionInterval = 0;
        int trailRevisionChange = 0;
        ActivationType activationType = ActivationType.Immediate;
        String activationDetails = "";
        Object userRouting = null;
        Object accountRouting = null;
        boolean primaryUser = true;
        MsgOrderSubmission2 submissionMsg = null;
        for (int i = 0; i < orderSubmit.count(); ++i) {
            OrderSubmitAction orderSubmitAction = orderSubmit.get(i);
            activationType = orderSubmit.Link.equals(OrderLink.AutoOCO) || orderSubmit.Link.equals(OrderLink.AutoOCOp) || orderSubmit.Link.equals(OrderLink.AutoOCOm) || orderSubmit.Link.equals(OrderLink.AutoOCOmp) || orderSubmit.Link.equals(OrderLink.Spark) || orderSubmit.Link.equals(OrderLink.Spark2) || orderSubmit.Link.equals(OrderLink.Chain2) ? (i > 0 ? ActivationType.Hold : (orderSubmitAction.Activation.equals(ActivationType.Hold) || orderSubmitAction.Activation.equals(ActivationType.Triggered) ? ActivationType.Immediate : ActivationType.Immediate)) : ActivationType.Immediate;
            MsgOrderUpdateD updateMsg = new MsgOrderUpdateD();
            updateMsg.UniqueID = UUID.randomUUID().toString().toUpperCase(Locale.US);
            updateMsg.MarketID = orderSubmitAction.Market.getMarketID();
            updateMsg.ExchangeID = orderSubmitAction.Market.getExchangeID();
            updateMsg.AccountID = orderSubmitAction.AccountID;
            updateMsg.NewVolume = orderSubmitAction.Volume;
            updateMsg.NewLimitPrice = orderSubmitAction.LimitPrice;
            updateMsg.NewStopPrice = orderSubmitAction.StopPrice;
            updateMsg.BuySell = orderSubmitAction.Side;
            updateMsg.PriceType = orderSubmitAction.PriceType;
            updateMsg.TimeType = orderSubmitAction.TimeType;
            updateMsg.OpenClose = openClose;
            updateMsg.Tag = orderSubmitAction.Tag;
            updateMsg.PendingResponse = ResponsePending.Submission;
            updateMsg.WorkingVolume = orderSubmitAction.Volume;
            updateMsg.TrailPrice = orderSubmitAction.TrailPrice;
            updateMsg.TrailRevisionInterval = trailRevisionInterval;
            updateMsg.TrailRevisionChange = trailRevisionChange;
            if (!activationType.equals(ActivationType.Undefined)) {
                updateMsg.ActivationType = activationType;
            }
            updateMsg.ActivationDetails = activationDetails;
            updateMsg.NewMaxShow = orderSubmitAction.MaxShow;
            if (userRouting == null) {
                updateMsg.ExchangeLoginID = "";
                updateMsg.ExchangeLocation = "";
            }
            if (accountRouting == null) {
                updateMsg.AccountNumber = "";
                updateMsg.CTI = CTI.Undefined;
                updateMsg.Origin = Origin.Undefined;
                updateMsg.AccountCode = AccountCode.Undefined;
                updateMsg.BillingFee = BillingFee.Undefined;
                updateMsg.MemberAllocation = "";
                updateMsg.TraderAllocation = "";
                updateMsg.CustomerReference = "";
                updateMsg.OmnibusAccount = "";
            }
            if (!activationType.equals(ActivationType.Immediate)) {
                updateMsg.Status = OrderStatus.Held;
            }
            updateMsg.PrimaryUser = primaryUser ? PrimaryUserType.Primary : PrimaryUserType.Secondary;
            if (userRouting == null) {
                updateMsg.UserID = "";
                updateMsg.UserName = "";
            }
            updateMsg.OrderSource = orderSubmit.Source;
            updateMsg.OrderSourceMethod = orderSubmit.Method;
            Order order = new Order(updateMsg);
            this.mOrders.put(order.getUniqueID(), order);
            orderSubmitAction.setOrder(order);
            if (submissionMsg == null) {
                submissionMsg = new MsgOrderSubmission2();
                submissionMsg.AccountID = updateMsg.AccountID;
                submissionMsg.MarketID = updateMsg.MarketID;
                submissionMsg.ExchangeID = updateMsg.ExchangeID;
                submissionMsg.Time = NDateTime.now();
                submissionMsg.OrderLink = orderSubmit.Link;
                submissionMsg.OrdersLinked = UUID.randomUUID().toString();
                submissionMsg.OrderSource = updateMsg.OrderSource;
                submissionMsg.OrderSourceMethod = updateMsg.OrderSourceMethod;
            }
            MsgOrderSubmission2.Order submissionOrder = new MsgOrderSubmission2.Order();
            submissionMsg.Orders.add(submissionOrder);
            submissionOrder.ExchangeOrderID = updateMsg.ExchangeOrderID;
            submissionOrder.UniqueID = updateMsg.UniqueID;
            submissionOrder.Tag = updateMsg.Tag;
            submissionOrder.BuySell = updateMsg.BuySell;
            submissionOrder.LimitPrice = updateMsg.NewLimitPrice;
            submissionOrder.PriceType = updateMsg.PriceType;
            submissionOrder.StopPrice = updateMsg.NewStopPrice;
            submissionOrder.TimeType = updateMsg.TimeType;
            submissionOrder.Volume = updateMsg.NewVolume;
            submissionOrder.OpenClose = updateMsg.OpenClose;
            submissionOrder.TrailTicks = updateMsg.TrailTicks;
            submissionOrder.TrailPrice = updateMsg.TrailPrice;
            submissionOrder.TrailRevisionInterval = updateMsg.TrailRevisionInterval;
            submissionOrder.TrailRevisionChange = updateMsg.TrailRevisionChange;
            submissionOrder.ActivationType = updateMsg.ActivationType;
            submissionOrder.ActivationValue = updateMsg.ActivationDetails;
            submissionOrder.MaxShow = updateMsg.NewMaxShow;
            submissionMsg.AccountNumber = updateMsg.AccountNumber;
            submissionMsg.CTI = updateMsg.CTI;
            submissionMsg.Origin = updateMsg.Origin;
            submissionMsg.AccountCode = updateMsg.AccountCode;
            submissionMsg.BillingFee = updateMsg.BillingFee;
            submissionMsg.MemberAllocation = updateMsg.MemberAllocation;
            submissionMsg.TraderAllocation = updateMsg.TraderAllocation;
            submissionMsg.CustomerReference = updateMsg.CustomerReference;
            submissionMsg.OmnibusAccount = updateMsg.OmnibusAccount;
            submissionMsg.ExchangeLoginID = updateMsg.ExchangeLoginID;
            submissionMsg.ExchangeLocation = updateMsg.ExchangeLocation;
            submissionMsg.PrimaryUser = updateMsg.PrimaryUser;
            submissionMsg.UserID = updateMsg.UserID;
            submissionMsg.UserName = updateMsg.UserName;
        }
        return submissionMsg;
    }

    public List<MsgOrderRevision2> reviseOrders(OrderRevise orderRevise) {
        ArrayList<MsgOrderRevision2> revisions = new ArrayList<MsgOrderRevision2>();
        Hashtable<String, MsgOrderRevision2> loginRevisions = new Hashtable<String, MsgOrderRevision2>();
        ArrayList<OrderRevise.Revision> revs = new ArrayList<OrderRevise.Revision>();
        for (OrderRevise.Revision revision : orderRevise.Revisions) {
            revs.add(revision);
            revs.addAll(revision.LinkedOrders);
        }
        for (OrderRevise.Revision revision : revs) {
            if (!this.createRevise(revision)) continue;
            MsgOrderRevision2 revisionMsg = (MsgOrderRevision2)loginRevisions.get(revision.Order.getExecutingLoginID());
            if (revisionMsg == null || revisionMsg.Orders.size() >= 16) {
                revisionMsg = new MsgOrderRevision2();
                loginRevisions.put(revision.Order.getExecutingLoginID(), revisionMsg);
                revisions.add(revisionMsg);
                revisionMsg.AccountID = orderRevise.AccountID;
                revisionMsg.MarketID = orderRevise.Market.getMarketID();
                revisionMsg.ExchangeID = orderRevise.Market.getExchangeID();
                revisionMsg.Time = NDateTime.now();
            }
            MsgOrderRevision2.Order orderRevision = new MsgOrderRevision2.Order();
            revisionMsg.Orders.add(orderRevision);
            MsgOrderUpdateD updateMsg = revision.Order.getLastUpdate();
            orderRevision.ExchangeOrderID = updateMsg.ExchangeOrderID;
            orderRevision.UniqueID = updateMsg.UniqueID;
            orderRevision.Tag = updateMsg.Tag;
            orderRevision.LimitPrice = updateMsg.NewLimitPrice;
            orderRevision.StopPrice = updateMsg.NewStopPrice;
            orderRevision.Volume = updateMsg.NewVolume;
            orderRevision.TrailTicks = updateMsg.TrailTicks;
            orderRevision.TrailPrice = updateMsg.TrailPrice;
            orderRevision.TrailRevisionInterval = updateMsg.TrailRevisionInterval;
            orderRevision.TrailRevisionChange = updateMsg.TrailRevisionChange;
            orderRevision.MaxShow = updateMsg.NewMaxShow;
            orderRevision.RevisionType = RevisionType.None.getValue();
            if (updateMsg.NewVolume != updateMsg.CurrentVolume) {
                orderRevision.RevisionType |= RevisionType.Volume.getValue();
            }
            if (updateMsg.NewLimitPrice != null && !updateMsg.NewLimitPrice.equals(updateMsg.CurrentLimitPrice)) {
                orderRevision.RevisionType |= RevisionType.LimitTicks.getValue();
            }
            if (updateMsg.NewStopPrice != null && !updateMsg.NewStopPrice.equals(updateMsg.CurrentStopPrice)) {
                orderRevision.RevisionType |= RevisionType.StopTicks.getValue();
            }
            orderRevision.ActivationValue = updateMsg.ActivationDetails;
            revisionMsg.ExchangeLoginID = "";
            revisionMsg.ExchangeLocation = "";
            revisionMsg.PrimaryUser = updateMsg.PrimaryUser;
            revisionMsg.UserID = updateMsg.UserID;
            revisionMsg.UserName = updateMsg.UserName;
        }
        return revisions;
    }

    private boolean createRevise(OrderRevise.Revision revision) {
        boolean create = false;
        if (revision.Order.getOrderStatus() == OrderStatus.Working || revision.Order.getOrderStatus() == OrderStatus.Held) {
            MsgOrderUpdateD updateMsg = revision.Order.getLastUpdate();
            if (!updateMsg.PendingResponse.equals(ResponsePending.Revision)) {
                if (revision.NewVolume != null && revision.NewVolume != updateMsg.NewVolume) {
                    updateMsg.NewVolume = revision.NewVolume;
                    create = true;
                }
                if (revision.NewMaxShow != null && revision.NewMaxShow != updateMsg.NewMaxShow) {
                    updateMsg.NewMaxShow = revision.NewMaxShow;
                    create = true;
                }
                if (revision.NewLimitPrice != null && !revision.NewLimitPrice.equals(updateMsg.NewLimitPrice)) {
                    updateMsg.NewLimitPrice = revision.NewLimitPrice;
                    create = true;
                }
                if (revision.NewStopPrice != null && !revision.NewStopPrice.equals(updateMsg.NewStopPrice)) {
                    updateMsg.NewStopPrice = revision.NewStopPrice;
                    create = true;
                }
                if (revision.NewTrailPrice != null && !revision.NewTrailPrice.equals(updateMsg.TrailPrice)) {
                    updateMsg.TrailPrice = revision.NewTrailPrice;
                    create = true;
                }
                if (create) {
                    updateMsg.UserID = "";
                    updateMsg.UserName = "";
                    updateMsg.PendingResponse = ResponsePending.Revision;
                }
            } else {
                Log.e(TAG, "createRevise(), Order is still waiting for a response.");
            }
        } else {
            Log.e(TAG, "createRevise(), Order is not working.");
        }
        return create;
    }

    public boolean doesPullRequireTicket(String accountid, Market market, BuySell buySell, Price price) {
        return false;
    }

    public List<MsgOrderPull2> pullOrders(String accountid, Market market, BuySell buySell, Price price) {
        ArrayList<MsgOrderPull2> pulls = new ArrayList<MsgOrderPull2>();
        Hashtable<String, MsgOrderPull2> loginPulls = new Hashtable<String, MsgOrderPull2>();
        boolean pullAll = buySell.equals(BuySell.Undefined) || price == null;
        for (Order order : this.mOrders.values()) {
            if (order.getOrderStatus() != OrderStatus.Working && order.getOrderStatus() != OrderStatus.None) continue;
            Price orderPrice = Position.getOrderPrice(order);
            if (order.getWorkingVolume() <= 0 || !pullAll && (!order.getSide().equals(buySell) || !orderPrice.equals(price))) continue;
            MsgOrderUpdateD orderUpdate = order.getLastUpdate();
            MsgOrderPull2 pullMsg = (MsgOrderPull2)loginPulls.get(orderUpdate.ExecutingLoginID);
            if (pullMsg == null || pullMsg.Orders.size() >= 16) {
                pullMsg = new MsgOrderPull2();
                loginPulls.put(orderUpdate.ExecutingLoginID, pullMsg);
                pulls.add(pullMsg);
                pullMsg.AccountID = accountid;
                pullMsg.MarketID = market.getMarketID();
                pullMsg.ExchangeID = market.getExchangeID();
            }
            MsgOrderPull2.Order pullOrder = new MsgOrderPull2.Order();
            pullMsg.Orders.add(pullOrder);
            pullOrder.ExchangeOrderID = orderUpdate.ExchangeOrderID;
            pullOrder.UniqueID = orderUpdate.UniqueID;
            pullOrder.Tag = orderUpdate.Tag;
        }
        return pulls;
    }

    public List<MsgOrderPull2> pullOrders(String accountid, Market market) {
        ArrayList<MsgOrderPull2> pulls = new ArrayList<MsgOrderPull2>();
        Hashtable<String, MsgOrderPull2> loginPulls = new Hashtable<String, MsgOrderPull2>();
        for (Order order : this.mOrders.values()) {
            if (order.getOrderStatus() != OrderStatus.Working && order.getOrderStatus() != OrderStatus.None || order.getWorkingVolume() <= 0) continue;
            MsgOrderUpdateD orderUpdate = order.getLastUpdate();
            MsgOrderPull2 pullMsg = (MsgOrderPull2)loginPulls.get(orderUpdate.ExecutingLoginID);
            if (pullMsg == null || pullMsg.Orders.size() >= 16) {
                pullMsg = new MsgOrderPull2();
                loginPulls.put(orderUpdate.ExecutingLoginID, pullMsg);
                pulls.add(pullMsg);
                pullMsg.AccountID = accountid;
                pullMsg.MarketID = market.getMarketID();
                pullMsg.ExchangeID = market.getExchangeID();
            }
            MsgOrderPull2.Order pullOrder = new MsgOrderPull2.Order();
            pullMsg.Orders.add(pullOrder);
            pullOrder.ExchangeOrderID = orderUpdate.ExchangeOrderID;
            pullOrder.UniqueID = orderUpdate.UniqueID;
            pullOrder.Tag = orderUpdate.Tag;
        }
        return pulls;
    }

    public List<MsgOrderPull2> pullOrders(String accountid, Market market, List<String> orderIDs) {
        ArrayList<MsgOrderPull2> pulls = new ArrayList<MsgOrderPull2>();
        Hashtable<String, MsgOrderPull2> loginPulls = new Hashtable<String, MsgOrderPull2>();
        for (String orderID : orderIDs) {
            Order order = this.mOrders.get(orderID);
            if (order.getOrderStatus() != OrderStatus.Working && order.getOrderStatus() != OrderStatus.None || order.getWorkingVolume() <= 0) continue;
            MsgOrderUpdateD orderUpdate = order.getLastUpdate();
            MsgOrderPull2 pullMsg = (MsgOrderPull2)loginPulls.get(orderUpdate.ExecutingLoginID);
            if (pullMsg == null || pullMsg.Orders.size() >= 16) {
                pullMsg = new MsgOrderPull2();
                loginPulls.put(orderUpdate.ExecutingLoginID, pullMsg);
                pulls.add(pullMsg);
                pullMsg.AccountID = accountid;
                pullMsg.MarketID = market.getMarketID();
                pullMsg.ExchangeID = market.getExchangeID();
            }
            MsgOrderPull2.Order pullOrder = new MsgOrderPull2.Order();
            pullMsg.Orders.add(pullOrder);
            pullOrder.ExchangeOrderID = orderUpdate.ExchangeOrderID;
            pullOrder.UniqueID = orderUpdate.UniqueID;
            pullOrder.Tag = orderUpdate.Tag;
        }
        return pulls;
    }

    public MsgOrderPull2 pullOrder(String orderID) {
        MsgOrderPull2 pullMsg = null;
        Order order = this.mOrders.get(orderID);
        if (order != null && (order.getOrderStatus() == OrderStatus.Working || order.getOrderStatus() == OrderStatus.None) && order.getWorkingVolume() > 0) {
            MsgOrderUpdateD orderUpdate = order.getLastUpdate();
            pullMsg = new MsgOrderPull2();
            pullMsg.AccountID = orderUpdate.AccountID;
            pullMsg.MarketID = orderUpdate.MarketID;
            pullMsg.ExchangeID = orderUpdate.ExchangeID;
            MsgOrderPull2.Order pullOrder = new MsgOrderPull2.Order();
            pullMsg.Orders.add(pullOrder);
            pullOrder.ExchangeOrderID = orderUpdate.ExchangeOrderID;
            pullOrder.UniqueID = orderUpdate.UniqueID;
            pullOrder.Tag = orderUpdate.Tag;
        }
        return pullMsg;
    }

    public static Price getOrderPrice(Order order) {
        if (order.getOrderStatus() == OrderStatus.None) {
            if (order.getPriceType().equals(PriceType.StopLimit) || order.getPriceType().equals(PriceType.StopMarket) || order.getPriceType().equals(PriceType.StopSameLimit)) {
                return order.getNewStopPrice();
            }
            return order.getNewLimitPrice();
        }
        if (order.getPriceType().equals(PriceType.StopLimit) || order.getPriceType().equals(PriceType.StopMarket) || order.getPriceType().equals(PriceType.StopSameLimit)) {
            return order.getCurrentStopPrice();
        }
        return order.getCurrentLimitPrice();
    }
}

