/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Resource;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.MarketPriceFormatter;
import com.t4login.api.PriceFormatter;
import com.t4login.api.accounts.Trade;
import com.t4login.application.orderbook.OrderBookFilter;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ATSRegulatoryIDType;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.OrderChange;
import com.t4login.definitions.OrderLink;
import com.t4login.definitions.OrderStatus;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.ResponsePending;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.MsgOrderHistory2;
import com.t4login.messages.MsgOrderSubmission2;
import com.t4login.messages.MsgOrderUpdateD;
import com.t4login.messages.MsgOrderUpdateFailedD;
import com.t4login.messages.MsgOrderUpdateStatusD;
import com.t4login.messages.MsgOrderUpdateTradeD;
import com.t4login.messages.MsgOrderUpdateTradeLegD;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class Order {
    public static final SimpleDateFormat SubmitTimeFormat = NDateTime.createDateFormat("h:mm:ss.SSS a");
    private static final AtomicLong Sequence = new AtomicLong(0L);
    public final long UniqueOrderID;
    private MsgOrderUpdateD mUpdate;
    private MsgOrderHistory2 mHistory;
    private List<Trade> mTrades = new ArrayList<Trade>();
    private NDateTime mLastFillTime = null;

    public Order(MsgOrderUpdateD update) {
        this.UniqueOrderID = Sequence.getAndIncrement();
        this.mUpdate = update;
        this.mTrades.clear();
        for (MsgOrderUpdateD.Trade trade : this.mUpdate.Trades) {
            this.mTrades.add(new Trade(this, trade));
            if (this.mLastFillTime != null && trade.Time.compareTo(this.mLastFillTime) <= 0) continue;
            this.mLastFillTime = trade.Time;
        }
    }

    public String getOrderSummary(MarketData md) {
        final Market market = md.getMarket(this.mUpdate.MarketID);
        Object summary = Order.getOrderTypeDisplay(this.mUpdate, new MarketPriceFormatter(){

            @Override
            public Market getMarket() {
                return market;
            }

            @Override
            public String formatPrice(Price price) {
                return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
            }
        });
        summary = (String)summary + " x" + this.mUpdate.CurrentVolume;
        return summary;
    }

    public String getFullOrderSummary(MarketData md) {
        Market market = md.getMarket(this.mUpdate.MarketID);
        String summary = "";
        if (market != null) {
            summary = this.getChange() == OrderChange.Trade || this.getChange() == OrderChange.TradeCompleted ? Order.getFullOrderTypeSummary(market, this.mUpdate.BuySell, this.mUpdate.PriceType, this.mUpdate.TimeType, this.mUpdate.CurrentVolume, this.mUpdate.CurrentLimitPrice, this.mUpdate.CurrentStopPrice, this.mUpdate.TotalFillVolume) : Order.getFullOrderTypeSummary(market, this.mUpdate.BuySell, this.mUpdate.PriceType, this.mUpdate.TimeType, this.mUpdate.CurrentVolume, this.mUpdate.CurrentLimitPrice, this.mUpdate.CurrentStopPrice, 0);
        }
        return summary;
    }

    public String getTag() {
        return this.mUpdate.Tag;
    }

    public OrderLink getOrderLink() {
        return this.mUpdate.OrderLink;
    }

    public String getOrdersLinked() {
        return this.mUpdate.OrdersLinked;
    }

    public NDateTime getLastFillTime() {
        return this.mLastFillTime;
    }

    public Iterable<Trade> getTrades() {
        return this.mTrades;
    }

    public String getOrderStatusDisplay() {
        return Order.getOrderStatusSummary(this);
    }

    public MsgOrderUpdateD getLastUpdate() {
        return this.mUpdate;
    }

    public MsgOrderHistory2 getOrderHistory() {
        return this.mHistory;
    }

    public String getUserID() {
        return this.mUpdate.UserID;
    }

    public String getMarketID() {
        return this.mUpdate.MarketID;
    }

    public OrderChange getChange() {
        return this.mUpdate.Change;
    }

    public String getExecutingLoginID() {
        return this.mUpdate.ExecutingLoginID;
    }

    public OrderStatus getOrderStatus() {
        return this.mUpdate.Status;
    }

    public PriceType getPriceType() {
        return this.mUpdate.PriceType;
    }

    public TimeType getTimeType() {
        return this.mUpdate.TimeType;
    }

    public boolean hasStopPrice() {
        return this.mUpdate.PriceType.equals(PriceType.StopLimit) || this.mUpdate.PriceType.equals(PriceType.StopMarket) || this.mUpdate.PriceType.equals(PriceType.StopSameLimit);
    }

    public int getNewVolume() {
        return this.mUpdate.NewVolume;
    }

    public Price getNewStopPrice() {
        return this.mUpdate.NewStopPrice;
    }

    public Price getNewLimitPrice() {
        return this.mUpdate.NewLimitPrice;
    }

    public Price getCurrentStopPrice() {
        return this.mUpdate.CurrentStopPrice;
    }

    public Price getCurrentLimitPrice() {
        return this.mUpdate.CurrentLimitPrice;
    }

    public BuySell getSide() {
        return this.mUpdate.BuySell;
    }

    public int getCurrentVolume() {
        return this.mUpdate.CurrentVolume;
    }

    public int getCurrentMaxShow() {
        return this.mUpdate.CurrentMaxShow;
    }

    public Price getWorkingPrice() {
        if (this.mUpdate.PriceType.equals(PriceType.StopLimit) || this.mUpdate.PriceType.equals(PriceType.StopMarket) || this.mUpdate.PriceType.equals(PriceType.StopSameLimit)) {
            if (this.mUpdate.Status == OrderStatus.None) {
                return this.mUpdate.NewStopPrice;
            }
            return this.mUpdate.CurrentStopPrice;
        }
        if (this.mUpdate.Status == OrderStatus.None) {
            return this.mUpdate.NewLimitPrice;
        }
        return this.mUpdate.CurrentLimitPrice;
    }

    public int getWorkingVolume() {
        return this.mUpdate.WorkingVolume;
    }

    public int getTotalFillVolume() {
        return this.mUpdate.TotalFillVolume;
    }

    public int getMaxShow() {
        return this.mUpdate.CurrentMaxShow;
    }

    public Price getTrailPrice() {
        if (this.mUpdate.TrailPrice != null && this.mUpdate.TrailPrice.compareTo(Price.Zero) > 0) {
            return this.mUpdate.TrailPrice;
        }
        return null;
    }

    public ActivationType getActivationType() {
        return this.mUpdate.ActivationType;
    }

    void processOrderUpdate(MsgOrderUpdateD msg) {
        this.mUpdate = msg;
        this.mTrades.clear();
        for (MsgOrderUpdateD.Trade trade : this.mUpdate.Trades) {
            this.mTrades.add(new Trade(this, trade));
            if (this.mLastFillTime != null && trade.Time.compareTo(this.mLastFillTime) <= 0) continue;
            this.mLastFillTime = trade.Time;
        }
    }

    void processOrderFailed(MsgOrderUpdateFailedD msg) {
        this.mUpdate.Change = msg.Change;
        this.mUpdate.ExchangeTime = msg.ExchangeTime;
        if (msg.Change == OrderChange.SubmissionFailed) {
            this.mUpdate.Status = OrderStatus.Rejected;
            this.mUpdate.WorkingVolume = 0;
            this.mUpdate.CurrentVolume = this.mUpdate.NewVolume;
            this.mUpdate.CurrentLimitPrice = this.mUpdate.NewLimitPrice;
            this.mUpdate.CurrentStopPrice = this.mUpdate.NewStopPrice;
            this.mUpdate.CurrentMaxShow = this.mUpdate.NewMaxShow;
            this.mUpdate.SubmitTime = msg.Time;
        } else if (msg.Change == OrderChange.RevisionFailed) {
            this.mUpdate.NewVolume = this.mUpdate.CurrentVolume;
            this.mUpdate.NewLimitPrice = this.mUpdate.CurrentLimitPrice;
            this.mUpdate.NewStopPrice = this.mUpdate.CurrentStopPrice;
            this.mUpdate.NewMaxShow = this.mUpdate.CurrentMaxShow;
        }
        if (msg.PendingResponse != ResponsePending.NoChange) {
            this.mUpdate.PendingResponse = msg.PendingResponse;
        }
        this.mUpdate.StatusDetail = msg.StatusDetail;
        this.mUpdate.Time = msg.Time;
        this.mUpdate.ExchangeSvr = msg.ExchangeSvr;
        this.mUpdate.AccountSvr = msg.AccountSvr;
        this.mUpdate.UserSvr = msg.UserSvr;
        if (msg.SequenceOrder > 0) {
            this.mUpdate.SequenceOrder = msg.SequenceOrder;
        }
    }

    void processOrderStatus(MsgOrderUpdateStatusD msg) {
        this.mUpdate.Change = msg.Change;
        this.mUpdate.ExchangeTime = msg.ExchangeTime;
        this.mUpdate.Status = msg.Status;
        this.mUpdate.PendingResponse = msg.PendingResponse;
        this.mUpdate.StatusDetail = msg.StatusDetail;
        this.mUpdate.Time = msg.Time;
        this.mUpdate.CurrentVolume = msg.CurrentVolume;
        this.mUpdate.CurrentLimitPrice = msg.CurrentLimitPrice;
        this.mUpdate.CurrentStopPrice = msg.CurrentStopPrice;
        this.mUpdate.PriceType = msg.PriceType;
        this.mUpdate.TimeType = msg.TimeType;
        this.mUpdate.ExchangeOrderID = msg.ExchangeOrderID;
        this.mUpdate.WorkingVolume = msg.WorkingVolume;
        this.mUpdate.ExecutingLoginID = msg.ExecutingLoginID;
        this.mUpdate.UserID = msg.UserID;
        this.mUpdate.UserName = msg.UserName;
        this.mUpdate.RoutingUserID = msg.RoutingUserID;
        this.mUpdate.RoutingUserName = msg.RoutingUserName;
        this.mUpdate.UserAddress = msg.UserAddress;
        this.mUpdate.SessionID = msg.SessionID;
        this.mUpdate.AppID = msg.AppID;
        this.mUpdate.AppName = msg.AppName;
        this.mUpdate.ActivationType = msg.ActivationType;
        this.mUpdate.ActivationDetails = msg.ActivationDetails;
        this.mUpdate.TrailTicks = msg.TrailTicks;
        this.mUpdate.TrailPrice = msg.TrailPrice;
        this.mUpdate.FirstExchangeTag = msg.FirstExchangeTag;
        this.mUpdate.LastExchangeTag = msg.LastExchangeTag;
        this.mUpdate.CurrentMaxShow = msg.CurrentMaxShow;
        this.mUpdate.NewVolume = msg.NewVolume;
        this.mUpdate.NewLimitPrice = msg.NewLimitPrice;
        this.mUpdate.NewStopPrice = msg.NewStopPrice;
        this.mUpdate.NewMaxShow = msg.NewMaxShow;
        this.mUpdate.ExchangeSvr = msg.ExchangeSvr;
        this.mUpdate.AccountSvr = msg.AccountSvr;
        this.mUpdate.UserSvr = msg.UserSvr;
        this.mUpdate.Tag = msg.Tag;
        this.mUpdate.SMPID = msg.SMPID;
        this.mUpdate.ExchangeLoginID = msg.ExchangeLoginID;
        this.mUpdate.ExchangeLocation = msg.ExchangeLocation;
        this.mUpdate.ATSRegulatoryID = msg.ATSRegulatoryID;
        if (msg.SequenceOrder > 0) {
            this.mUpdate.SequenceOrder = msg.SequenceOrder;
        }
    }

    public Trade processOrderTrade(MsgOrderUpdateTradeD msg) {
        this.mUpdate.Change = msg.Change;
        this.mUpdate.ExchangeTime = msg.ExchangeTime;
        this.mUpdate.Status = msg.Status;
        this.mUpdate.PendingResponse = msg.PendingResponse;
        this.mUpdate.StatusDetail = msg.StatusDetail;
        this.mUpdate.Time = msg.Time;
        if (this.mUpdate.PriceType.equals(PriceType.StopLimit)) {
            this.mUpdate.PriceType = PriceType.Limit;
        } else if (this.mUpdate.PriceType.equals(PriceType.StopSameLimit)) {
            this.mUpdate.PriceType = PriceType.Limit;
            this.mUpdate.CurrentLimitPrice = this.mUpdate.CurrentStopPrice;
            this.mUpdate.CurrentStopPrice = null;
        } else if (this.mUpdate.PriceType.equals(PriceType.StopMarket)) {
            this.mUpdate.PriceType = PriceType.Market;
        }
        this.mUpdate.WorkingVolume = msg.WorkingVolume;
        this.mUpdate.TotalFillVolume = msg.TotalFillVolume;
        this.mUpdate.ExchangeSvr = msg.ExchangeSvr;
        this.mUpdate.AccountSvr = msg.AccountSvr;
        this.mUpdate.UserSvr = msg.UserSvr;
        MsgOrderUpdateD.Trade msgTrade = new MsgOrderUpdateD.Trade();
        msgTrade.Volume = msg.Volume;
        msgTrade.Price = msg.Price;
        msgTrade.ResidualVolume = msg.ResidualVolume;
        msgTrade.Time = msg.Time;
        msgTrade.ExchangeTradeID = msg.ExchangeTradeID;
        msgTrade.ExchangeTime = msg.ExchangeTime;
        msgTrade.ContraTrader = msg.ContraTrader;
        msgTrade.ContraBroker = msg.ContraBroker;
        msgTrade.TradeDate = msg.TradeDate;
        msgTrade.SequenceOrder = this.mUpdate.Trades.size();
        this.mUpdate.Trades.add(msgTrade);
        if (this.mLastFillTime == null || msgTrade.Time.compareTo(this.mLastFillTime) > 0) {
            this.mLastFillTime = msgTrade.Time;
        }
        Trade trade = new Trade(this, msgTrade);
        this.mTrades.add(trade);
        return trade;
    }

    public void processOrderTradeLeg(MsgOrderUpdateTradeLegD msg) {
        this.mUpdate.ExchangeSvr = msg.ExchangeSvr;
        this.mUpdate.AccountSvr = msg.AccountSvr;
        this.mUpdate.UserSvr = msg.UserSvr;
        MsgOrderUpdateD.TradeLeg leg = new MsgOrderUpdateD.TradeLeg();
        leg.LegIndex = msg.LegIndex;
        leg.Volume = msg.Volume;
        leg.Price = msg.Price;
        leg.Time = msg.Time;
        leg.ExchangeTradeID = msg.ExchangeTradeID;
        leg.ExchangeTime = msg.ExchangeTime;
        leg.ContraTrader = msg.ContraTrader;
        leg.ContraBroker = msg.ContraBroker;
        leg.ResidualVolume = msg.ResidualVolume;
        leg.TradeDate = msg.TradeDate;
        leg.SequenceOrder = this.mUpdate.TradeLegs.size();
        this.mUpdate.TradeLegs.add(leg);
    }

    public void processOrderHistory(MsgOrderHistory2 msg) {
        this.mHistory = msg;
    }

    public String getUniqueID() {
        return this.mUpdate.UniqueID;
    }

    public boolean getIsHeld() {
        return this.mUpdate.Status.equals(OrderStatus.Held);
    }

    public boolean getIsWorking() {
        return this.mUpdate.Status.equals(OrderStatus.Working);
    }

    public NDateTime getTradeDate() {
        return this.mUpdate.TradeDate;
    }

    public static String getOrderTypeDisplay(MsgOrderSubmission2 submitMsg, PriceFormatter prcFmt, Market market) {
        return Order.getOrderTypeDisplay(submitMsg, 0, prcFmt, market);
    }

    public static String getOrderTypeDisplay(MsgOrderSubmission2 submitMsg, int orderIndex, final PriceFormatter prcFmt, final Market market) {
        String disp = "";
        if (submitMsg.Orders.size() > orderIndex) {
            MsgOrderSubmission2.Order order = submitMsg.Orders.get(orderIndex);
            MsgOrderUpdateD updateMsg = new MsgOrderUpdateD();
            updateMsg.PriceType = order.PriceType;
            updateMsg.NewLimitPrice = order.LimitPrice;
            updateMsg.NewStopPrice = order.StopPrice;
            updateMsg.TrailTicks = order.TrailTicks;
            updateMsg.TrailPrice = order.TrailPrice;
            updateMsg.OrderLink = submitMsg.OrderLink;
            updateMsg.TimeType = order.TimeType;
            updateMsg.ActivationType = order.ActivationType;
            updateMsg.CurrentMaxShow = order.MaxShow;
            MarketPriceFormatter mktPrcFmt = new MarketPriceFormatter(){

                @Override
                public Market getMarket() {
                    return market;
                }

                @Override
                public String formatPrice(Price price) {
                    return prcFmt.formatPrice(market, price);
                }
            };
            disp = Order.getOrderTypeDisplay(updateMsg, mktPrcFmt);
        }
        return disp;
    }

    public static String getOrderTypeDisplay(MsgOrderUpdateD updateMsg, MarketPriceFormatter prcFmt) {
        if (updateMsg.Status == OrderStatus.None) {
            return Order.getOrderTypeDisplay(updateMsg.PriceType, updateMsg.TimeType, updateMsg.ActivationType, updateMsg.OrderLink, updateMsg.NewLimitPrice, updateMsg.NewStopPrice, updateMsg.TrailPrice, updateMsg.CurrentMaxShow, ATSRegulatoryIDType.get(updateMsg.ATSRegulatoryID), prcFmt);
        }
        return Order.getOrderTypeDisplay(updateMsg.PriceType, updateMsg.TimeType, updateMsg.ActivationType, updateMsg.OrderLink, updateMsg.CurrentLimitPrice, updateMsg.CurrentStopPrice, updateMsg.TrailPrice, updateMsg.CurrentMaxShow, ATSRegulatoryIDType.get(updateMsg.ATSRegulatoryID), prcFmt);
    }

    public static String getOrderTypeDisplay(PriceType priceType, TimeType timeType, ActivationType activationType, OrderLink orderLink, Price currentLimitPrice, Price currentStopPrice, Price trailDistance, int currentMaxShow, ATSRegulatoryIDType ats, MarketPriceFormatter prcFmt) {
        StringBuilder sb = new StringBuilder();
        if (ats.equals(ATSRegulatoryIDType.AutoLiquidate) && priceType.equals(PriceType.Market)) {
            return Resource.localizeString("ordertype_fmt_pricetype_market_autoliquidate");
        }
        if (priceType.equals(PriceType.Limit)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_limit"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentLimitPrice));
        } else if (priceType.equals(PriceType.Market)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_market"));
        } else if (priceType.equals(PriceType.MarketIfTouched)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_marketiftouched"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentLimitPrice));
        } else if (priceType.equals(PriceType.Pit)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_pit"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentLimitPrice));
        } else if (priceType.equals(PriceType.StopLimit)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_limit"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentLimitPrice));
            sb.append(" ");
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_stopmarket"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentStopPrice));
        } else if (priceType.equals(PriceType.StopMarket)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_stopmarket"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentStopPrice));
        } else if (priceType.equals(PriceType.OvernightPosition)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_overnightposition"));
        } else if (priceType.equals(PriceType.BackOfficePosition)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_backofficeposition"));
        } else if (priceType.equals(PriceType.StopSameLimit)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_stopsamelimit"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(currentStopPrice));
        } else if (priceType.equals(PriceType.Join)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_join"));
        } else if (priceType.equals(PriceType.Hit)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_hit"));
        } else if (priceType.equals(PriceType.RFQ)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_rfq"));
        } else if (priceType.equals(PriceType.Flatten)) {
            sb.append(Resource.localizeString("ordertype_fmt_pricetype_flatten"));
        }
        if (trailDistance != null && !trailDistance.equals(Price.Zero)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(Resource.localizeString("ordertype_fmt_trail"));
            sb.append(":");
            sb.append(prcFmt.formatPrice(trailDistance));
        }
        if (orderLink != OrderLink.None) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(orderLink.getDescription());
        }
        String ttFmt = null;
        if (timeType.equals(TimeType.CompleteVolume)) {
            ttFmt = Resource.localizeString("ordertype_fmt_timetype_completevolume");
        } else if (timeType.equals(TimeType.GoodTillCancelled)) {
            ttFmt = Resource.localizeString("ordertype_fmt_timetype_goodtillcancelled");
        } else if (timeType.equals(TimeType.ImmediateAndCancel)) {
            ttFmt = Resource.localizeString("ordertype_fmt_timetype_immediateandcancel");
        } else if (timeType.equals(TimeType.MarketOnOpen)) {
            ttFmt = Resource.localizeString("ordertype_fmt_timetype_marketonopen");
        }
        if (ttFmt != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ttFmt);
        }
        String actFmt = null;
        if (activationType.equals(ActivationType.AtOrAboveTradeTicks) || activationType.equals(ActivationType.AtOrBelowTradeTicks) || activationType.equals(ActivationType.AtOrAfterTime) || activationType.equals(ActivationType.OnMarketMode)) {
            actFmt = Resource.localizeString("ordertype_fmt_activation");
        }
        if (actFmt != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(actFmt);
        }
        if (currentMaxShow > 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(Resource.localizeString("ordertype_fmt_maxshow"));
            sb.append(":");
            sb.append(Integer.toString(currentMaxShow));
        }
        return sb.toString();
    }

    public static String getFullOrderTypeSummary(Market market, BuySell side, PriceType priceType, TimeType timeType, int volume, Price limitPrice, Price stopPrice, int totalFillVolume) {
        if (market == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Object volDescr = totalFillVolume > 0 ? Integer.toString(totalFillVolume) + "/" + volume : Integer.toString(volume);
        if (priceType.equals(PriceType.Market)) {
            sb.append(side.getDescription());
            sb.append(" ");
            sb.append((String)volDescr);
            sb.append(" @ ");
            sb.append(priceType.getDescription());
        } else if (priceType.equals(PriceType.Limit) || priceType.equals(PriceType.Pit)) {
            sb.append(side.getDescription());
            sb.append(" ");
            sb.append((String)volDescr);
            sb.append(" @ ");
            sb.append(priceType.getDescription());
            sb.append(": ");
            sb.append(PriceFormat.convertPriceToDisplayFormat(limitPrice, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay));
        } else if (priceType.equals(PriceType.MarketIfTouched)) {
            sb.append(side.getDescription());
            sb.append(" ");
            sb.append((String)volDescr);
            sb.append(" @ ");
            sb.append(priceType.getDescription());
            sb.append(": ");
            sb.append(PriceFormat.convertPriceToDisplayFormat(limitPrice, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay));
        } else if (priceType.equals(PriceType.StopMarket)) {
            sb.append(side.getDescription());
            sb.append(" ");
            sb.append((String)volDescr);
            sb.append(" @ ");
            sb.append(priceType.getDescription());
            sb.append(": ");
            sb.append(PriceFormat.convertPriceToDisplayFormat(stopPrice, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay));
        } else if (priceType.equals(PriceType.StopLimit)) {
            sb.append(side.getDescription());
            sb.append(" ");
            sb.append((String)volDescr);
            sb.append(" @ ");
            sb.append(PriceType.Limit.getDescription());
            sb.append(": ");
            sb.append(PriceFormat.convertPriceToDisplayFormat(limitPrice, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay));
            sb.append(", ");
            sb.append(PriceType.StopLimit.getDescription());
            sb.append(": ");
            sb.append(PriceFormat.convertPriceToDisplayFormat(stopPrice, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay));
        } else if (priceType.equals(PriceType.StopSameLimit)) {
            sb.append(side.getDescription());
            sb.append(" ");
            sb.append((String)volDescr);
            sb.append(" @ ");
            sb.append(priceType.getDescription());
            sb.append(": ");
            sb.append(PriceFormat.convertPriceToDisplayFormat(stopPrice, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay));
        } else if (priceType.equals(PriceType.Hit)) {
            sb.append(priceType.getDescription());
            sb.append(" the ");
            sb.append(side.getDescription());
        } else if (priceType.equals(PriceType.Join)) {
            sb.append(priceType.getDescription());
            sb.append(" the ");
            sb.append(side.getDescription());
        } else if (priceType.equals(PriceType.RFQ)) {
            sb.append(priceType.getDescription());
        } else if (priceType.equals(PriceType.Flatten)) {
            sb.append(priceType.getDescription());
        }
        if (timeType.equals(TimeType.CompleteVolume)) {
            sb.append(", ").append(Resource.localizeString("timetype_completevolume_abbr"));
        } else if (timeType.equals(TimeType.GoodTillCancelled)) {
            sb.append(", ").append(Resource.localizeString("timetype_goodtillcancelled_abbr"));
        } else if (timeType.equals(TimeType.ImmediateAndCancel)) {
            sb.append(", ").append(Resource.localizeString("timetype_immediateandcancel_abbr"));
        } else if (timeType.equals(TimeType.MarketOnOpen)) {
            sb.append(", ").append(Resource.localizeString("timetype_marketonopen_abbr"));
        }
        return sb.toString();
    }

    public static String getOrderStatusSummary(Order order) {
        return Order.getOrderStatusSummary(order.getOrderStatus(), order.getLastUpdate().StatusDetail, order.getChange(), order.getPriceType(), order.getCurrentVolume(), order.getTotalFillVolume());
    }

    public static String getOrderStatusSummary(OrderStatus status, String statusDetail, OrderChange change, PriceType priceType, int currentVolume, int totalFillVolume) {
        Object statusSummary = "";
        String detailSummary = "";
        if (status == OrderStatus.Finished) {
            if (change == OrderChange.PullFailed || change == OrderChange.PullRejected || change == OrderChange.PullRiskFailed) {
                statusSummary = Resource.localizeString("orderstatus_fmt_cancelfailed");
                detailSummary = statusDetail;
            } else if (change == OrderChange.PullSuccess || change == OrderChange.PullSent || change == OrderChange.PullRiskSuccess) {
                if (totalFillVolume != 0) {
                    statusSummary = Resource.localizeString("orderstatus_fmt_completed") + ", " + Resource.localizeString("orderstatus_fmt_partialfill");
                    detailSummary = statusDetail;
                } else {
                    statusSummary = Resource.localizeString("orderstatus_fmt_canceled");
                    detailSummary = statusDetail;
                }
            } else if (change == OrderChange.TradeCompleted) {
                statusSummary = totalFillVolume < currentVolume ? Resource.localizeString("orderstatus_fmt_completed") + ", " + Resource.localizeString("orderstatus_fmt_partialfill") : Resource.localizeString("orderstatus_fmt_completed") + ", " + Resource.localizeString("orderstatus_fmt_filled");
                detailSummary = statusDetail;
            } else if (change == OrderChange.StatusRequestFailed || change == OrderChange.StatusRequestRejected || change == OrderChange.StatusRequestRiskFailed || change == OrderChange.StatusRequestRiskSuccess || change == OrderChange.StatusRequestSent || change == OrderChange.StatusRequestSuccess) {
                statusSummary = totalFillVolume < currentVolume ? Resource.localizeString("orderstatus_fmt_completed") + ", " + Resource.localizeString("orderstatus_fmt_partialfill") + ", " + change.getDescription() : Resource.localizeString("orderstatus_fmt_completed") + ", " + Resource.localizeString("orderstatus_fmt_filled") + ", " + change.getDescription();
                detailSummary = statusDetail;
            } else if (change == OrderChange.RevisionRiskFailed) {
                if (totalFillVolume == currentVolume) {
                    statusSummary = Resource.localizeString("orderstatus_fmt_completed") + ", " + Resource.localizeString("orderstatus_fmt_filled") + ", " + change.getDescription();
                }
            } else if (change == OrderChange.TradeBusted) {
                statusSummary = Resource.localizeString("orderstatus_fmt_completed") + ", " + change.getDescription();
            } else if (change == OrderChange.SubmissionSuccess && priceType.equals(PriceType.RFQ)) {
                statusSummary = Resource.localizeString("orderstatus_fmt_completed");
            }
        } else if (status == OrderStatus.Rejected) {
            if (change == OrderChange.StatusRequestFailed || change == OrderChange.StatusRequestRejected || change == OrderChange.StatusRequestRiskFailed || change == OrderChange.StatusRequestRiskSuccess || change == OrderChange.StatusRequestSent || change == OrderChange.StatusRequestSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_rejected") + ", " + change.getDescription();
                detailSummary = statusDetail;
            } else {
                statusSummary = Resource.localizeString("orderstatus_fmt_rejected");
                detailSummary = statusDetail;
            }
        } else if (status == OrderStatus.Working) {
            if (change == OrderChange.PullRiskSuccess || change == OrderChange.PullSent || change == OrderChange.PullSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_canceling") + "...";
                detailSummary = statusDetail;
            } else if (change == OrderChange.RevisionSent || change == OrderChange.RevisionRiskSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_revising") + "...";
                detailSummary = statusDetail;
            } else if (change == OrderChange.RevisionSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + Resource.localizeString("orderstatus_fmt_revised");
            } else if (change == OrderChange.RevisionFailed || change == OrderChange.RevisionRejected || change == OrderChange.RevisionRiskFailed) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + Resource.localizeString("orderstatus_fmt_revisionfailed");
                detailSummary = statusDetail;
            } else if (change == OrderChange.RevisionFailed || change == OrderChange.RevisionRejected || change == OrderChange.RevisionRiskFailed) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + Resource.localizeString("orderstatus_fmt_revisionfailed");
                detailSummary = statusDetail;
            } else if (change == OrderChange.PullFailed || change == OrderChange.PullRejected || change == OrderChange.PullRiskFailed) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + Resource.localizeString("orderstatus_fmt_cancelfailed");
                detailSummary = statusDetail;
            } else if (change == OrderChange.Trade || change == OrderChange.SubmissionSent || change == OrderChange.SubmissionSuccess || change == OrderChange.SubmissionRiskSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + "...";
                detailSummary = statusDetail;
            } else if (change == OrderChange.Handover) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + Resource.localizeString("orderstatus_fmt_handover");
                detailSummary = statusDetail;
            } else if (change == OrderChange.Rollover) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + Resource.localizeString("orderstatus_fmt_rollover");
                detailSummary = statusDetail;
            } else if (change == OrderChange.StatusRequestFailed || change == OrderChange.StatusRequestRejected || change == OrderChange.StatusRequestRiskFailed || change == OrderChange.StatusRequestRiskSuccess || change == OrderChange.StatusRequestSent || change == OrderChange.StatusRequestSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_working") + ", " + change.getDescription();
                detailSummary = statusDetail;
            }
            if (totalFillVolume > 0) {
                statusSummary = (String)statusSummary + ", " + Resource.localizeString("orderstatus_fmt_partialfill");
            }
        } else if (status == OrderStatus.None) {
            if (change == OrderChange.None) {
                statusSummary = Resource.localizeString("orderstatus_fmt_submitting") + "...";
            } else if (change == OrderChange.SubmissionRiskSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_submittingtoexchange");
            } else if (change == OrderChange.SubmissionRejected || change == OrderChange.SubmissionRiskRejected) {
                statusSummary = Resource.localizeString("orderstatus_fmt_submissionrejected");
            } else if (change == OrderChange.SubmissionFailed) {
                statusSummary = Resource.localizeString("orderstatus_fmt_submissionfailed");
            } else if (change == OrderChange.SubmissionSent || change == OrderChange.SubmissionSuccess) {
                statusSummary = Resource.localizeString("orderstatus_fmt_submissionsent");
            }
            detailSummary = statusDetail;
        } else if (status == OrderStatus.Held) {
            // empty if block
        }
        statusSummary = ((String)statusSummary).trim();
        detailSummary = detailSummary.trim();
        Object summary = ((String)statusSummary).isEmpty() && detailSummary.isEmpty() ? "~ " + status.getDescription() + ", " + change.getDescription() : statusSummary;
        if (!detailSummary.isEmpty()) {
            summary = (String)summary + ", " + detailSummary;
        }
        return summary;
    }

    public static boolean isFillUpdate(Order order) {
        if (order.getPriceType().equals(PriceType.Pit)) {
            return false;
        }
        if (order.getPriceType().equals(PriceType.OvernightPosition)) {
            return false;
        }
        if (order.getChange() != OrderChange.Trade && order.getChange() != OrderChange.TradeCompleted) {
            return false;
        }
        if (order.getTotalFillVolume() == 0) {
            return false;
        }
        return order.getWorkingVolume() == 0;
    }

    public static boolean isPartialFillUpdate(Order order) {
        if (order.getPriceType().equals(PriceType.Pit)) {
            return false;
        }
        if (order.getPriceType().equals(PriceType.OvernightPosition)) {
            return false;
        }
        if (order.getChange() != OrderChange.Trade && order.getChange() != OrderChange.TradeCompleted) {
            return false;
        }
        if (order.getTotalFillVolume() == 0) {
            return false;
        }
        return order.getWorkingVolume() != 0;
    }

    public static boolean passesFilter(Order order, OrderBookFilter filter) {
        MsgOrderUpdateD det = order.getLastUpdate();
        return !(switch (filter) {
            case OrderBookFilter.Canceled -> {
                boolean canceled = det.WorkingVolume == 0 && det.TotalFillVolume == 0 && det.Status != OrderStatus.Rejected && det.Status != OrderStatus.Held;
                yield !canceled;
            }
            case OrderBookFilter.Filled -> det.TotalFillVolume == 0;
            case OrderBookFilter.PreviousDayFills -> det.TotalFillVolume == 0 || !det.PriceType.equals(PriceType.OvernightPosition) && !det.PriceType.equals(PriceType.BackOfficePosition);
            case OrderBookFilter.CurrentDayFills -> det.TotalFillVolume == 0 || det.PriceType.equals(PriceType.OvernightPosition) || det.PriceType.equals(PriceType.BackOfficePosition);
            case OrderBookFilter.CurrentDayFillsNoPit -> det.TotalFillVolume == 0 || det.PriceType.equals(PriceType.OvernightPosition) || det.PriceType.equals(PriceType.BackOfficePosition) || det.PriceType.equals(PriceType.Pit);
            case OrderBookFilter.AllCurrentDay -> det.PriceType.equals(PriceType.OvernightPosition) || det.PriceType.equals(PriceType.BackOfficePosition);
            case OrderBookFilter.HeldOnServer -> det.Status != OrderStatus.Held;
            case OrderBookFilter.Rejected -> det.Status != OrderStatus.Rejected;
            case OrderBookFilter.Working -> det.Status != OrderStatus.Working;
            case OrderBookFilter.WorkingGTC -> det.Status != OrderStatus.Working || !det.TimeType.equals(TimeType.GoodTillCancelled);
            case OrderBookFilter.WorkingNonGTC -> det.Status != OrderStatus.Working || det.TimeType.equals(TimeType.GoodTillCancelled);
            default -> false;
        });
    }
}

