/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.FirmData;
import com.t4login.api.IFirmDataHandler;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.MarketDataHandler;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.api.SubscriptionLevel;
import com.t4login.api.T4HostService;
import com.t4login.api.accounts.Account;
import com.t4login.api.accounts.AccountData;
import com.t4login.api.accounts.AccountDataHandler;
import com.t4login.api.accounts.AccountProfit;
import com.t4login.api.accounts.MatchedTrade;
import com.t4login.api.accounts.NetPosition;
import com.t4login.api.accounts.Position;
import com.t4login.api.accounts.PositionProfit;
import com.t4login.api.accounts.TradeMatching;
import com.t4login.api.currencies.Currency;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.settings.AppSettings;
import com.t4login.definitions.AccountMode;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.MarginCalc;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.FirmContract;
import com.t4login.messages.MsgAccountPosition2;
import com.t4login.util.PerformanceTimer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class AccountProfitUpdater {
    public static final String TAG = "AccountProfitUpdater";
    private DepthBuffer mDepthBuffer = DepthBuffer.SlowSmart;
    private DepthLevels mDepthLevel = DepthLevels.BestOnly;
    private Hashtable<String, AccountProfit> mProfit = new Hashtable();
    private List<UpdateHandler> mUpdateHandlers = new CopyOnWriteArrayList<UpdateHandler>();
    private MarketData mMarketData;
    private AccountData mAccountData;
    private FirmData mFirmData;
    private final Set<PositionKey> mPositionMarketSubscriptions = ConcurrentHashMap.newKeySet();
    private final Hashtable<String, PositionProfit> mPositionProfits = new Hashtable();
    private Configurable.ConfigurationChangedHandler mConfigChangedHandler = new Configurable.ConfigurationChangedHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigurationChanged(boolean restored) {
            Iterator<Account> iterator = AccountProfitUpdater.this.mAccountData.getAccounts().iterator();
            while (iterator.hasNext()) {
                Account account;
                Account account2 = account = iterator.next();
                synchronized (account2) {
                    AccountProfitUpdater.this.calculateAccountProfit(account, false, null, null);
                }
            }
        }
    };
    private final MarketDataHandler marketDataHandler = new MarketDataHandler(){

        @Override
        public String getDescription() {
            return AccountProfitUpdater.TAG;
        }

        @Override
        public void onCheckSubscriptions(Map<String, SubscriptionLevel> subscriptions) {
            List<String> subs = AccountProfitUpdater.this.mPositionMarketSubscriptions.stream().map(PositionKey::marketID).distinct().toList();
            for (String marketID : subs) {
                SubscriptionLevel subscriptionLevel = subscriptions.get(marketID);
                if (subscriptionLevel == null) continue;
                subscriptionLevel.update(AccountProfitUpdater.this.mDepthBuffer, AccountProfitUpdater.this.mDepthLevel, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMarketUpdate(MarketDataSnapshot snapshot) {
            Set subs = AccountProfitUpdater.this.mPositionMarketSubscriptions.stream().map(PositionKey::marketID).collect(Collectors.toSet());
            if (subs.contains(snapshot.Market.getMarketID())) {
                Iterator<Account> iterator = AccountProfitUpdater.this.mAccountData.getAccounts().iterator();
                while (iterator.hasNext()) {
                    Account account;
                    Account account2 = account = iterator.next();
                    synchronized (account2) {
                        AccountProfitUpdater.this.calculateAccountProfit(account, false, null, snapshot.Market.getMarketID());
                    }
                }
            }
        }
    };
    private AccountDataHandler accountDataHandler = new AccountDataHandler(){

        @Override
        public String getDescription() {
            return AccountProfitUpdater.TAG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAccountComplete(Account acct) {
            try {
                3 var2_2 = this;
                synchronized (var2_2) {
                    AccountProfitUpdater.this.calculateAccountProfit(acct, false, null, null);
                }
            }
            catch (Exception ex) {
                Log.e(AccountProfitUpdater.TAG, "AccountDataHandler.onAccountComplete(), Error", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAccountUpdate(Account acct, boolean dueToPosition) {
            try {
                3 var3_3 = this;
                synchronized (var3_3) {
                    AccountProfitUpdater.this.calculateAccountProfit(acct, false, null, null);
                }
            }
            catch (Exception ex) {
                Log.e(AccountProfitUpdater.TAG, "AccountDataHandler.onAccountUpdate(), Error", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPositionUpdate(Account acct, Position position) {
            try {
                3 var3_3 = this;
                synchronized (var3_3) {
                    AccountProfitUpdater.this.calculateAccountProfit(acct, false, position, null);
                }
            }
            catch (Exception ex) {
                Log.e(AccountProfitUpdater.TAG, "AccountDataHandler.onPositionUpdate(), Error", ex);
            }
        }
    };
    private final IFirmDataHandler firmDataHandler = new IFirmDataHandler(){

        @Override
        public String getDescription() {
            return AccountProfitUpdater.TAG;
        }

        @Override
        public void onFirmContractsRefreshed(Map<String, FirmContract> contracts) {
            for (Account account : AccountProfitUpdater.this.mAccountData.getAccounts()) {
                AccountProfitUpdater.this.calculateAccountProfit(account, true, null, null);
            }
        }

        @Override
        public void onFirmContractUpdated(FirmContract firmContract) {
            for (Account account : AccountProfitUpdater.this.mAccountData.getAccounts()) {
                AccountProfitUpdater.this.calculateAccountProfit(account, true, null, null);
            }
        }
    };
    private static final long CRITICAL_MS = 200L;
    private static final long WARN_MS = 100L;
    private static final long LOG_MS = 10L;

    public AccountProfit getAccountProfit(String accountID) {
        return this.mProfit.get(accountID);
    }

    public PositionProfit getPositionProfit(String accountID, String marketID) {
        return this.mPositionProfits.get(accountID + "_" + marketID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(T4HostService service) {
        try {
            AppSettings.registerForConfigurationChanges(this.mConfigChangedHandler);
            if (service != null) {
                if (this.mAccountData != null) {
                    this.disconnect();
                }
                this.mMarketData = service.getMarketData();
                if (this.mMarketData != null) {
                    this.mMarketData.registerForMarketData(this.marketDataHandler);
                }
                this.mAccountData = service.getAccountData();
                if (this.mAccountData != null) {
                    this.mAccountData.registerForAccountData(this.accountDataHandler);
                    Iterator<Account> iterator = this.mAccountData.getAccounts().iterator();
                    while (iterator.hasNext()) {
                        Account acct;
                        Account account = acct = iterator.next();
                        synchronized (account) {
                            for (Position pos : acct.getPositions()) {
                                Market market;
                                MsgAccountPosition2 acctPos = pos.getPositionUpdate();
                                if (acctPos == null || acctPos.Buys - acctPos.Sells == 0 || (market = this.mMarketData.getMarket(pos.MarketID)) == null) continue;
                                this.mMarketData.subscribeForMarketDepth(market, this.mDepthBuffer, this.mDepthLevel, true, false);
                                this.mPositionMarketSubscriptions.add(new PositionKey(pos.AccountID, pos.MarketID));
                            }
                        }
                    }
                }
                this.mFirmData = service.getFirmData();
                if (this.mFirmData != null) {
                    this.mFirmData.registerForFirmData(this.firmDataHandler);
                }
            } else {
                this.mAccountData = null;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "connect(), Error.", ex);
        }
    }

    public void disconnect() {
        AppSettings.unregisterForConfigurationChanges(this.mConfigChangedHandler);
        if (this.mFirmData != null) {
            this.mFirmData.unregisterForFirmData(this.firmDataHandler);
        }
        if (this.mAccountData != null) {
            this.mAccountData.unregisterForAccountData(this.accountDataHandler);
        }
        if (this.mMarketData != null) {
            this.mMarketData.unregisterForMarketData(this.marketDataHandler);
            List<String> subs = this.mPositionMarketSubscriptions.stream().map(PositionKey::marketID).distinct().toList();
            this.mPositionMarketSubscriptions.clear();
            for (String marketid : subs) {
                Market market = this.mMarketData.getMarket(marketid);
                this.mMarketData.subscribeForMarketDepth(market, DepthBuffer.NoSubscription, this.mDepthLevel, false);
            }
        }
        this.mAccountData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Iterator<Account> iterator = this.mAccountData.getAccounts().iterator();
        while (iterator.hasNext()) {
            Account account;
            Account account2 = account = iterator.next();
            synchronized (account2) {
                this.calculateAccountProfit(account, true, null, null);
            }
        }
    }

    public void registerForUpdates(UpdateHandler updateHandler) {
        this.mUpdateHandlers.add(updateHandler);
        if (this.mAccountData != null) {
            for (Account account : this.mAccountData.getAccounts()) {
                this.calculateAccountProfit(account, true, null, null);
            }
        }
    }

    public void unregisterForUpdates(UpdateHandler updateHandler) {
        this.mUpdateHandlers.remove(updateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAccountProfit(Account account, boolean recalculateAllPositions, Position updatedPosition, String updatedMarketID) {
        if (account == null) {
            return;
        }
        boolean implySpreadPositions = account.isComplete() && account.getAccountMode() != AccountMode.ByMarket && AppSettings.instance.MarketData.ImpliedSpreadPositions;
        try {
            BigDecimal upl = BigDecimal.ZERO;
            BigDecimal uplt = BigDecimal.ZERO;
            ArrayList<PositionProfit> updatedPositionProfits = new ArrayList<PositionProfit>(account.getPositionCount());
            BigDecimal dayMargin = BigDecimal.ZERO;
            BigDecimal fullMargin = BigDecimal.ZERO;
            Account account2 = account;
            synchronized (account2) {
                for (Position position : account.getPositions()) {
                    PositionProfit pp = this.getPositionProfit(account.getAccountID(), position.MarketID);
                    if (pp == null || recalculateAllPositions || updatedPosition != null && updatedPosition.MarketID.equals(position.MarketID) || updatedMarketID != null && updatedMarketID.equals(position.MarketID)) {
                        pp = this.calculatePositionProfit(account, position);
                        updatedPositionProfits.add(pp);
                        this.mPositionProfits.put(account.getAccountID() + "_" + position.MarketID, pp);
                    } else if (implySpreadPositions && pp != null && pp.isImplied()) {
                        Market market = this.mMarketData.getMarket(position.MarketID);
                        for (int l = 0; l < market.getLegCount(); ++l) {
                            Market.Leg leg = market.getLeg(l);
                            if ((updatedPosition == null || !updatedPosition.MarketID.equals(leg.getMarketID())) && (updatedMarketID == null || !updatedMarketID.equals(leg.getMarketID()))) continue;
                            pp = this.calculatePositionProfit(account, position);
                            updatedPositionProfits.add(pp);
                            this.mPositionProfits.put(account.getAccountID() + "_" + position.MarketID, pp);
                            break;
                        }
                    }
                    if (pp.isImplied()) continue;
                    if (account.getUsePremium() && pp.IsOptions) {
                        if (pp.getNet() > 0) {
                            upl = upl.add(pp.UPLUSD.max(BigDecimal.ZERO));
                            uplt = uplt.add(pp.UPLTradeUSD.max(BigDecimal.ZERO));
                        } else if (pp.getNet() < 0) {
                            upl = upl.add(pp.UPLUSD.min(BigDecimal.ZERO));
                            uplt = uplt.add(pp.UPLTradeUSD.min(BigDecimal.ZERO));
                        } else {
                            upl = upl.add(pp.UPLUSD);
                            uplt = uplt.add(pp.UPLTradeUSD);
                        }
                    } else {
                        upl = upl.add(pp.UPLUSD);
                        uplt = uplt.add(pp.UPLTradeUSD);
                    }
                    dayMargin = dayMargin.add(pp.DayMargin);
                    fullMargin = fullMargin.add(pp.FullMargin);
                }
            }
            AccountProfit prevProfit = this.mProfit.get(account.getAccountID());
            AccountProfit ap = new AccountProfit(account, upl, uplt, 0, 0, 0, 0, 0, dayMargin, fullMargin, prevProfit);
            this.mProfit.put(account.getAccountID(), ap);
            for (PositionProfit pp : updatedPositionProfits) {
                for (UpdateHandler cb : this.mUpdateHandlers) {
                    cb.onPositionProfitUpdated(pp);
                }
            }
            for (UpdateHandler cb : this.mUpdateHandlers) {
                cb.onAccountProfitUpdated(ap);
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "calculateAccountProfit(), Error", ex);
        }
    }

    private PositionProfit calculatePositionProfit(Account account, Position position) {
        PerformanceTimer timer = new PerformanceTimer(true);
        MsgAccountPosition2 pos = position.getPositionUpdate();
        BigDecimal upl = BigDecimal.ZERO;
        BigDecimal uplt = BigDecimal.ZERO;
        BigDecimal uplUSD = BigDecimal.ZERO;
        BigDecimal upltUSD = BigDecimal.ZERO;
        boolean isOptions = false;
        boolean hasData = false;
        NetPosition net = new NetPosition(pos.Buys, pos.Sells, pos.Buys - pos.Sells, false, false);
        Market market = this.mMarketData.getMarket(position.MarketID);
        if (account.getAccountMode() != AccountMode.ByMarket && AppSettings.instance.MarketData.ImpliedSpreadPositions && market != null && !market.getStrategyType().equals(StrategyType.None) && !market.isOrderTypeSupported(OrderType.NotReducible)) {
            net = this.computeImpliedNetPosition(account, position);
        }
        PositionKey posKey = new PositionKey(pos.AccountID, pos.MarketID);
        if (net.Net != 0 && !net.Implied) {
            if (!this.mPositionMarketSubscriptions.contains(posKey)) {
                if (market != null) {
                    Log.d(TAG, "calculatePositionProfit(), Net = %d, Subscribing. Pos Market: %s, Account: %s, Buys: %d, Sells: %d", net.Net, pos.MarketID, pos.AccountID, pos.Buys, pos.Sells);
                    this.mPositionMarketSubscriptions.add(posKey);
                    this.mMarketData.subscribeForMarketDepth(market, this.mDepthBuffer, this.mDepthLevel, true, false);
                }
            } else {
                MarketDataSnapshot marketSnapshot = this.mMarketData.getMarketDataSnapshot(position.MarketID);
                if (marketSnapshot.hasDepth()) {
                    Contract contract = this.mMarketData.getContract(marketSnapshot.Market.getExchangeID(), marketSnapshot.Market.getContractID());
                    if (contract == null) {
                        Log.e(TAG, "calculatePositionProfit(), Unable to load contract e: " + marketSnapshot.Market.getExchangeID() + ", c: " + marketSnapshot.Market.getContractID());
                    } else {
                        Currency currency = this.mAccountData.getCurrency(contract.getCurrency());
                        isOptions = ContractType.isOption(contract.getContractType());
                        BigDecimal wideMarket = currency.fromUSD(new BigDecimal(account.getWideMarket()));
                        Price avgOpenTicks = position.getAverageOpenPrice();
                        if (net.Net > 0) {
                            BigDecimal cashValue;
                            Price bidValue = marketSnapshot.getBidValue(wideMarket);
                            Price tradeValue = marketSnapshot.getTradeValue();
                            if (bidValue != null) {
                                cashValue = PriceFormat.convertPriceToCashValue(bidValue.subtract(avgOpenTicks), marketSnapshot.Market);
                                upl = cashValue.multiply(new BigDecimal(net.Net));
                            }
                            if (tradeValue != null) {
                                cashValue = PriceFormat.convertPriceToCashValue(tradeValue.subtract(avgOpenTicks), marketSnapshot.Market);
                                uplt = cashValue.multiply(new BigDecimal(net.Net));
                            }
                        } else if (net.Net < 0) {
                            BigDecimal cashValue;
                            Price offerValue = marketSnapshot.getOfferValue(wideMarket);
                            Price tradeValue = marketSnapshot.getTradeValue();
                            if (offerValue != null) {
                                cashValue = PriceFormat.convertPriceToCashValue(offerValue.subtract(avgOpenTicks), marketSnapshot.Market);
                                upl = cashValue.multiply(new BigDecimal(net.Net));
                            }
                            if (tradeValue != null) {
                                cashValue = PriceFormat.convertPriceToCashValue(tradeValue.subtract(avgOpenTicks), marketSnapshot.Market);
                                uplt = cashValue.multiply(new BigDecimal(net.Net));
                            }
                        }
                        uplUSD = currency.toUSD(upl);
                        upltUSD = currency.toUSD(uplt);
                    }
                }
            }
        } else if (this.mPositionMarketSubscriptions.contains(posKey) && market != null) {
            Log.d(TAG, "calculatePositionProfit(), Net = %d, Unsubscribing. Pos Market: %s, Account: %s, Buys: %d, Sells: %d", net.Net, pos.MarketID, pos.AccountID, pos.Buys, pos.Sells);
            this.mPositionMarketSubscriptions.remove(posKey);
            this.mMarketData.subscribeForMarketDepth(market, DepthBuffer.NoSubscription, this.mDepthLevel, false, false);
        }
        hasData |= position.getOrderCount() > 0;
        hasData |= pos.Buys > 0;
        hasData |= pos.Sells > 0;
        hasData |= pos.WorkingBuys > 0;
        hasData |= pos.WorkingSells > 0;
        hasData |= pos.MP > 0.0;
        long executionTime = timer.elapsedMilliseconds();
        if (executionTime > 200L) {
            Log.e(TAG, "calculatePositionProfit(), time: %dms", executionTime);
        } else if (executionTime > 100L) {
            Log.w(TAG, "calculatePositionProfit(), time: %dms", executionTime);
        } else if (executionTime > 10L) {
            Log.d(TAG, "calculatePositionProfit(), time: %dms", executionTime);
        }
        BigDecimal dayMargin = BigDecimal.ZERO;
        BigDecimal fullMargin = BigDecimal.ZERO;
        if (this.mFirmData != null && market != null) {
            BigDecimal fullMarginRate;
            BigDecimal dayMarginRate = this.mFirmData.getDayMargin(market);
            if (dayMarginRate != null) {
                dayMargin = BigDecimal.valueOf(MarginCalc.calculateMargin(pos, dayMarginRate.doubleValue()));
            }
            if ((fullMarginRate = this.mFirmData.getAdjustedFullMargin(market)) != null) {
                fullMargin = BigDecimal.valueOf(MarginCalc.calculateMargin(pos, fullMarginRate.doubleValue()));
            }
        }
        List<MatchedTrade> matchedTrades = Collections.unmodifiableList(TradeMatching.computePositionMatchedTrades(position, market, account));
        return new PositionProfit(pos, account.getAccountID(), position.MarketID, isOptions, hasData, net, upl, uplt, uplUSD, upltUSD, dayMargin, fullMargin, market.getContract().getIsEventBased(), matchedTrades);
    }

    private NetPosition computeImpliedNetPosition(Account account, Position position) {
        Market market = this.mMarketData.getMarket(position.MarketID);
        Integer net = null;
        boolean balanced = true;
        for (int i = 0; i < market.getLegCount(); ++i) {
            Position legPosition = this.mAccountData.getPosition(account.getAccountID(), market.getLeg(i).getMarketID());
            if (legPosition != null) {
                int legNet = legPosition.getPositionUpdate().Buys - legPosition.getPositionUpdate().Sells;
                int netPos = legNet / market.getLeg(i).getVolume();
                if (i == 0) {
                    net = netPos;
                    continue;
                }
                if (net.equals(netPos)) continue;
                balanced = false;
                if (netPos == 0 || net == 0) {
                    net = 0;
                    break;
                }
                if (net > 0 && netPos < 0 || net < 0 && netPos > 0) {
                    net = 0;
                    break;
                }
                if (Math.abs(netPos) >= Math.abs(net)) continue;
                net = netPos;
                continue;
            }
            net = null;
            break;
        }
        if (net == null) {
            net = 0;
        }
        Integer buys = 0;
        Integer sells = 0;
        for (int i = 0; i < market.getLegCount(); ++i) {
            Position legPosition = this.mAccountData.getPosition(account.getAccountID(), market.getLeg(i).getMarketID());
            Market.Leg leg = market.getLeg(i);
            int absLegVol = Math.abs(leg.getVolume());
            if (legPosition == null) continue;
            MsgAccountPosition2 legUpdate = legPosition.getPositionUpdate();
            if (i == 0) {
                if (leg.getVolume() < 0) {
                    buys = legUpdate.Sells / absLegVol;
                    sells = legUpdate.Buys / absLegVol;
                    continue;
                }
                buys = legUpdate.Buys / absLegVol;
                sells = legUpdate.Sells / absLegVol;
                continue;
            }
            if (leg.getVolume() < 0) {
                buys = Math.min(buys, legUpdate.Sells / absLegVol);
                sells = Math.min(sells, legUpdate.Buys / absLegVol);
                continue;
            }
            buys = Math.min(buys, legUpdate.Buys / absLegVol);
            sells = Math.min(sells, legUpdate.Sells / absLegVol);
        }
        if (Math.abs(buys - sells) != Math.abs(net)) {
            if (net == 0) {
                buys = sells;
            } else if (net > 0) {
                if (buys > sells) {
                    buys = net + sells;
                } else {
                    sells = net + buys;
                }
            } else if (buys > sells) {
                sells = net + buys;
            } else {
                buys = net + sells;
            }
        }
        return new NetPosition(buys, sells, net, true, balanced);
    }

    private record PositionKey(String accountID, String marketID) {
    }

    public static interface UpdateHandler {
        public void onAccountProfitUpdated(AccountProfit var1);

        public void onPositionProfitUpdated(PositionProfit var1);
    }
}

