/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.api.accounts.Account;
import com.t4login.messages.MsgAccountUpdate2;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AccountProfit {
    public final Account Account;
    private final MsgAccountUpdate2 mAccountUpdate;
    public final BigDecimal UPL;
    public final BigDecimal UPLTrade;
    public final int WarningPL;
    public final int WarningLossLimit;
    public final int WarningMargin;
    public final int TotalWorkingOrders;
    public final int TotalWorkingVolume;
    public final BigDecimal DayMargin;
    public final BigDecimal FullMargin;
    public final Boolean IsAlertingLiveMargin;
    public final Boolean IsAlertingFullMargin;

    public AccountProfit(String acctID) {
        this.Account = null;
        this.mAccountUpdate = new MsgAccountUpdate2();
        this.mAccountUpdate.AccountID = acctID;
        this.UPL = BigDecimal.ZERO;
        this.UPLTrade = BigDecimal.ZERO;
        this.WarningPL = 0;
        this.WarningLossLimit = 0;
        this.WarningMargin = 0;
        this.TotalWorkingOrders = 0;
        this.TotalWorkingVolume = 0;
        this.DayMargin = BigDecimal.ZERO;
        this.FullMargin = BigDecimal.ZERO;
        this.IsAlertingLiveMargin = false;
        this.IsAlertingFullMargin = false;
    }

    public AccountProfit(Account account, BigDecimal upl, BigDecimal uplt, int wpl, int wll, int wm, int totord, int totwvol, BigDecimal dayMarg, BigDecimal fullMarg, AccountProfit prevProfit) {
        this.Account = account;
        this.mAccountUpdate = account.getAccountUpdateMessage();
        this.UPL = upl;
        this.UPLTrade = uplt;
        this.WarningPL = wpl;
        this.WarningLossLimit = wll;
        this.WarningMargin = wm;
        this.TotalWorkingOrders = totord;
        this.TotalWorkingVolume = totwvol;
        this.DayMargin = dayMarg;
        this.FullMargin = fullMarg;
        BigDecimal netEquity = this.getNetEquity();
        BigDecimal accountMargin = this.getMargin();
        BigDecimal liveMarginRatio = BigDecimal.ONE;
        if (accountMargin.compareTo(BigDecimal.ZERO) > 0 && netEquity.compareTo(BigDecimal.ZERO) > 0) {
            liveMarginRatio = BigDecimal.ONE.subtract(accountMargin.divide(netEquity, 18, RoundingMode.HALF_EVEN));
        }
        BigDecimal liveMarginPercentage = liveMarginRatio.multiply(new BigDecimal(100));
        this.IsAlertingLiveMargin = prevProfit != null && prevProfit.IsAlertingLiveMargin != false && liveMarginPercentage.compareTo(new BigDecimal(28)) >= 0 ? Boolean.valueOf(false) : (liveMarginPercentage.compareTo(new BigDecimal(25)) < 0 ? Boolean.valueOf(true) : Boolean.valueOf(prevProfit != null && prevProfit.IsAlertingLiveMargin != false));
        BigDecimal alertingMargin = this.getAlertingMargin();
        this.IsAlertingFullMargin = alertingMargin.compareTo(BigDecimal.ZERO) > 0 && alertingMargin.compareTo(netEquity) > 0;
    }

    public BigDecimal getPL() {
        if (this.mAccountUpdate != null) {
            return new BigDecimal(this.mAccountUpdate.RPL).add(this.UPL);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getPLTrade() {
        if (this.mAccountUpdate != null) {
            return new BigDecimal(this.mAccountUpdate.RPL).add(this.UPLTrade);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getSettlementPL() {
        if (this.mAccountUpdate != null) {
            return this.getPL().subtract(new BigDecimal(this.mAccountUpdate.OvernightUPL));
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getSettlementPLTrade() {
        if (this.mAccountUpdate != null) {
            return this.getPLTrade().subtract(new BigDecimal(this.mAccountUpdate.OvernightUPL));
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAvailableCash() {
        if (this.mAccountUpdate != null && this.Account != null) {
            boolean usePLForMargin = this.Account.getUsePLForMargin();
            boolean usePremium = this.Account.getUsePremium();
            if (usePLForMargin) {
                if (usePremium) {
                    return new BigDecimal(this.mAccountUpdate.Balance + this.getPL().doubleValue() - this.mAccountUpdate.Margin + Math.min(0.0, this.mAccountUpdate.Premium) - this.mAccountUpdate.FeesAndCommissions);
                }
                return new BigDecimal(this.mAccountUpdate.Balance + this.getPL().doubleValue() - this.mAccountUpdate.Margin - this.mAccountUpdate.FeesAndCommissions);
            }
            return new BigDecimal(this.mAccountUpdate.Balance - this.mAccountUpdate.Margin - this.mAccountUpdate.FeesAndCommissions);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getNetEquity() {
        if (this.mAccountUpdate != null && this.Account != null) {
            boolean usePremium = this.Account.getUsePremium();
            if (usePremium) {
                return new BigDecimal(this.mAccountUpdate.Balance + this.getPL().doubleValue() + this.mAccountUpdate.Premium - this.mAccountUpdate.FeesAndCommissions);
            }
            return new BigDecimal(this.mAccountUpdate.Balance + this.getPL().doubleValue() - this.mAccountUpdate.FeesAndCommissions);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getMargin() {
        if (this.mAccountUpdate != null) {
            return new BigDecimal(this.mAccountUpdate.Margin);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAlertingMargin() {
        if (this.mAccountUpdate != null && this.mAccountUpdate.T500AlertingMargin != null) {
            return new BigDecimal(this.mAccountUpdate.T500AlertingMargin);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getFeesAndComissions() {
        if (this.mAccountUpdate != null) {
            return new BigDecimal(this.mAccountUpdate.FeesAndCommissions);
        }
        return BigDecimal.ZERO;
    }
}

